<?php

ini_set("display_errors", 0);  // Desativa a exibição de erros
ini_set("display_startup_errors", 0);  // Desativa a exibição de erros de inicialização
error_reporting(E_ALL);  // Relata todos os erros

include 'DB.php';

$path = __DIR__ . "/playlists.txt";
$log_file = __DIR__ . "/log.txt";

function log_message($message) {
    global $log_file;
    $timestamp = date("Y-m-d H:i:s");
    file_put_contents($log_file, "[$timestamp] $message" . PHP_EOL, FILE_APPEND);
}

// Configura um manipulador de erros personalizado para redirecionar os erros para o log
set_error_handler(function($errno, $errstr, $errfile, $errline) {
    log_message("Erro: [$errno] $errstr em $errfile na linha $errline");
    return true; // Evita que o PHP trate o erro
});

$start_time = microtime(true);

if (!file_exists($path)) {
    $message = "Arquivo de playlists não encontrado em: $path";
    echo json_encode(["success" => false, "message" => $message]);
    log_message($message);
    exit;
}

$rs = file($path);
$rs[0] = $_SERVER["HTTPS"];
$rs[1] = $_SERVER["HTTP_HOST"];
$rs[2] = $_SERVER["REQUEST_URI"];
$rs[3] = $_SERVER["QUERY_STRING"];

header("Content-Type: application/json");

if (isset($_GET["username"]) && isset($_GET["password"])) {
    $username = $_GET["username"];
    $password = $_GET["password"];

    $stmt = $connection->prepare("SELECT * FROM `users` WHERE username_ = ? AND password = ?");
    $stmt->bindParam(1, $username);
    $stmt->bindParam(2, $password);
    $stmt->execute();
    $count = $stmt->rowCount();

    if ($count) {
        if (isset($_GET["action"])) {
            $action = $_GET["action"];
            $api_url = "https://mytvfun.rockstards.com.br/mytv_api/player_api.php?username=$username&password=$password";
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_FAILONERROR, true);

            $url_user = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            if (curl_errno($ch)) {
                $message = "Erro ao acessar a API: " . curl_error($ch);
                echo json_encode(["success" => false, "message" => $message]);
                log_message($message);
                curl_close($ch);
                exit;
            }
            
            curl_close($ch);

            if ($http_code !== 200 || !$url_user) {
                $message = "Erro ao acessar a API de séries. Código HTTP: $http_code";
                echo json_encode(["success" => false, "message" => $message]);
                log_message($message);
                exit;
            }

            // Log a URL retornada pela API para depuração
            log_message("URL retornada pela API: $url_user");

            $redirect_url = trim($url_user) . "/player_api.php?username=$username&password=$password&action=$action";

            // Adiciona parâmetros baseados na ação
            switch ($action) {
                case "get_vod_info":
                    if (isset($_GET["vod_id"])) {
                        $vod_id = $_GET["vod_id"];
                        $redirect_url .= "&vod_id=$vod_id";
                    } else {
                        $message = "Parâmetro 'vod_id' ausente para a ação 'get_vod_info'.";
                        echo json_encode(["success" => false, "message" => $message]);
                        log_message($message);
                        exit;
                    }
                    break;
                case "get_series_info":
                    if (isset($_GET["series_id"])) {
                        $series_id = $_GET["series_id"];
                        $redirect_url .= "&series_id=$series_id";
                    } else {
                        $message = "Parâmetro 'series_id' ausente para a ação 'get_series_info'.";
                        echo json_encode(["success" => false, "message" => $message]);
                        log_message($message);
                        exit;
                    }
                    break;
                case "get_vod_categories":
                case "get_series_categories":
                    // Adicione qualquer lógica adicional necessária aqui
                    break;
                case "get_vod_streams":
                    if (isset($_GET["vod_id"])) {
                        $vod_id = $_GET["vod_id"];
                        $redirect_url .= "&vod_id=$vod_id";
                    } else {
                        $message = "Parâmetro 'vod_id' ausente para a ação 'get_vod_streams'.";
                        echo json_encode(["success" => false, "message" => $message]);
                        log_message($message);
                        exit;
                    }
                    break;
                case "get_series":
                    // Adicione qualquer lógica adicional necessária aqui
                    break;
                case "get_epg":
                    if (isset($_GET["epg_id"])) {
                        $epg_id = $_GET["epg_id"];
                        $redirect_url .= "&epg_id=$epg_id";
                    } else {
                        $message = "Parâmetro 'epg_id' ausente para a ação 'get_epg'.";
                        echo json_encode(["success" => false, "message" => $message]);
                        log_message($message);
                        exit;
                    }
                    break;
                default:
                    $message = "Ação desconhecida: $action";
                    echo json_encode(["success" => false, "message" => $message]);
                    log_message($message);
                    exit;
            }

            // Log a URL final de redirecionamento
            log_message("Redirecionando para: " . $redirect_url);

            if (!empty($redirect_url)) {
                $redirect_start_time = microtime(true);
                header("Location: " . $redirect_url);
                $redirect_end_time = microtime(true);
                $redirect_execution_time = ($redirect_end_time - $redirect_start_time);
                log_message("Tempo de redirecionamento: " . $redirect_execution_time . " segundos");

                exit;
            } else {
                $message = "Erro ao construir a URL de redirecionamento.";
                echo json_encode(["success" => false, "message" => $message]);
                log_message($message);
            }
        } else {
            $message = "Parâmetro 'action' ausente.";
            echo json_encode(["success" => false, "message" => $message]);
            log_message($message);
        }
    } else {
        $message = "Credenciais inválidas.";
        echo json_encode(["success" => false, "message" => $message]);
        log_message($message);
    }
} else {
    $message = "Parâmetros ausentes.";
    echo json_encode(["success" => false, "message" => $message]);
    log_message($message);
}

$end_time = microtime(true);
$execution_time = ($end_time - $start_time);
log_message("Tempo total de execução: " . $execution_time . " segundos");

?>
