<?php

ini_set("display_errors", 1);  // Alterar para 1 para exibir erros durante o desenvolvimento
ini_set("display_startup_errors", 1);
error_reporting(E_ALL);
include 'DB.php';

// Definir o caminho absoluto para o arquivo de playlists
$path = __DIR__ . "/playlists.txt";  // __DIR__ fornece o diretório atual do script

// Definir o caminho absoluto para o arquivo de log
$log_file = __DIR__ . "/log.txt";

// Função para registrar mensagens no log
function log_message($message) {
    global $log_file;
    $timestamp = date("Y-m-d H:i:s");
    file_put_contents($log_file, "[$timestamp] $message" . PHP_EOL, FILE_APPEND);
}

// Verificar se o arquivo de playlists existe
if (!file_exists($path)) {
    echo json_encode(["success" => false, "message" => "Arquivo de playlists não encontrado em: $path"]);
    exit;
}

// Carregar dados do arquivo de playlists
$rs = file($path);
$rs[0] = $_SERVER["HTTPS"];
$rs[1] = $_SERVER["HTTP_HOST"];
$rs[2] = $_SERVER["REQUEST_URI"];
$rs[3] = $_SERVER["QUERY_STRING"];

header("Content-Type: application/json");

// Verificar se os parâmetros necessários foram passados
if (isset($_GET["username"]) && isset($_GET["password"])) {
    $username = $_GET["username"];
    $password = $_GET["password"];

    // Consulta no banco de dados
    $stmt = $connection->prepare("SELECT * FROM `users` WHERE username_ = ? AND password = ?");
    $stmt->bindParam(1, $username);
    $stmt->bindParam(2, $password);
    $stmt->execute();
    $count = $stmt->rowCount();

    if ($count) {
        // Obter URL do usuário a partir da API usando cURL
        $api_url = "https://mytvfun.rockstards.com.br/mytv_api/player_api.php?username=$username&password=$password&action=get_series";
        
        // Inicializar cURL
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);  // Timeout de 30 segundos
        curl_setopt($ch, CURLOPT_FAILONERROR, true);

        // Medir tempo de execução
        $curl_start_time = microtime(true);
        $url_user = curl_exec($ch);
        $curl_end_time = microtime(true);
        $curl_execution_time = ($curl_end_time - $curl_start_time);
        log_message("Tempo de execução da chamada API 'get_series': " . $curl_execution_time . " segundos");

        // Verificar erros cURL
        if (curl_errno($ch)) {
            log_message("Erro ao acessar a API: " . curl_error($ch));
            echo json_encode(["success" => false, "message" => "Erro ao acessar a API: " . curl_error($ch)]);
            curl_close($ch);
            exit;
        }
        
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        log_message("Código HTTP da resposta da API: $http_code");
        log_message("Resposta completa da API: " . $url_user);

        // Verificar se a resposta da API é válida
        if ($http_code !== 200 || !$url_user) {
            log_message("Erro ao acessar a API de séries. Código HTTP: $http_code");
            echo json_encode(["success" => false, "message" => "Erro ao acessar a API de séries. Código HTTP: $http_code"]);
            exit;
        }

        // Definir a ação e construir a URL de redirecionamento
        $action = $_GET["action"];
        $redirect_url = trim($url_user) . "/player_api.php?username=$username&password=$password&action=$action";

        // Adicionar parâmetros adicionais para VOD ou séries
        if ($action === "get_vod_info" && isset($_GET["vod_id"])) {
            $vod_id = $_GET["vod_id"];
            $redirect_url .= "&vod_id=$vod_id";
        } elseif ($action === "get_series_info" && isset($_GET["series_id"])) {
            $series_id = $_GET["series_id"];
            $redirect_url .= "&series_id=$series_id";
        } elseif ($action === "get_vod_categories") {
            // Adicionar parâmetros específicos para `get_vod_categories` se necessário
        } elseif ($action === "get_series_categories") {
            // Adicionar suporte para `get_series_categories` se necessário
        } elseif ($action === "get_vod_streams" && isset($_GET["vod_id"])) {
            $vod_id = $_GET["vod_id"];
            $redirect_url .= "&vod_id=$vod_id";
        } elseif ($action === "get_series" && isset($_GET["series_id"])) {
            $series_id = $_GET["series_id"];
            $redirect_url .= "&series_id=$series_id";
        } elseif ($action === "get_series_streams" && isset($_GET["series_id"])) {
            $series_id = $_GET["series_id"];
            $redirect_url .= "&series_id=$series_id";
        }

        // Verificar se a URL foi construída corretamente
        if (!empty($redirect_url)) {
            log_message("Redirecionando para: " . $redirect_url);
            header("Location: " . $redirect_url);
            exit;
        } else {
            echo json_encode(["success" => false, "message" => "Erro ao construir a URL de redirecionamento."]);
        }
    } else {
        // Caso as credenciais estejam incorretas
        echo json_encode(["success" => false, "message" => "Credenciais inválidas."]);
    }
} else {
    // Caso os parâmetros estejam ausentes
    echo json_encode(["success" => false, "message" => "Parâmetros ausentes."]);
}

?>
