<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include 'DB.php';
include_once 'teste_gratis.php';
date_default_timezone_set('America/Sao_Paulo');

header('Content-Type: application/json');

if (!isset($_GET['mac'])) {
    $response = array('status' => 'failed', 'message' => 'Falha ao obter status do dispositivo!');
    die(json_encode($response));
}

$mac = $_GET['mac'];
$mac = str_replace(":", "", $mac);
$mac = strtoupper($mac);

if(isset($_GET['rev_id'])) {
    $rev_id = $_GET['rev_id'];
} else {
    $rev_id = 1;
}


if (empty($mac)) {
    $response = array('status' => 'failed', 'message' => 'MAC Inválido!');
    die(json_encode($response));
}

// Filtrar usuário
$stmt = $connection->prepare("SELECT * FROM `users` WHERE username = ?");
$stmt->bindParam(1, $mac);

if ($stmt->execute() === FALSE) {
    $response = array('status' => 'failed', 'message' => 'Erro na consulta SQL!');
    die(json_encode($response));
}

$isTeste = 0;

if ($stmt->rowCount() <= 0) {
    
    if($rev_id == 0) {
        $rev_id = 1;
    }
    // MAC não existe no Banco de Dados, gerar teste...
    $stmt = $connection->prepare("SELECT * FROM teste_automatico WHERE id = '$rev_id' LIMIT 1");
    $stmt->execute();
$dados_teste = $stmt->fetch(PDO::FETCH_ASSOC); // Certifique-se de usar FETCH_ASSOC para evitar problemas

if (!$dados_teste) {
    $response = array('status' => 'failed', 'message' => 'Nenhum teste disponível para este revendedor!');
    die(json_encode($response));
}

$status = $dados_teste['status'];
 //   $dados_teste = $stmt->fetch();
//    $status = $dados_teste['status'];
    
    if($status == "on") {
        gerarTesteGratis($connection, $mac, $rev_id);
        $isTeste = 1;
        $stmt = $connection->prepare("SELECT * FROM `users` WHERE username = ?");
        $stmt->bindParam(1, $mac);
        $stmt->execute();
    } else {
        $response = array('status' => 'failed', 'message' => 'MAC não encontrado no servidor!');
        die(json_encode($response));
    }
    
}


while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $username = $row['username'];
    $user_id = $row["id"];
    $seller = $row['member_id'];

    // Prepara a consulta SQL com um parâmetro
    $stmt2 = $connection->prepare("SELECT url_do_futebol FROM reg_users WHERE id = :seller");
    $stmt2->bindParam(':seller', $seller, PDO::PARAM_INT);

    // Executa a consulta
    if ($stmt2->execute()) {
        if ($rowx = $stmt2->fetch(PDO::FETCH_ASSOC)) {
            $url_do_futebol = $rowx['url_do_futebol'];
        } else {
            $url_do_futebol = "Nenhum resultado encontrado para o ID fornecido.";
        }
    } else {
        $response = array('status' => 'failed', 'message' => 'Erro ao executar a consulta de URL!');
        die(json_encode($response));
    }

    $status = $row['enabled'];
    $password = $row['password'];
    $username = $row['username_'];
    $devices_number = $row['max_connections'];
    $device_1 = $row['device_1'];
    $device_2 = $row['device_2'];
    $expiration = $row['exp_date'];
    $registration = $row['created_at'];
}

if ($status == 0) {
    $response = array('status' => 'failed', 'message' => 'Dispositivo desativado!');
    die(json_encode($response));
}

// Verifica e corrige o formato do timestamp de expiração
$currentDateTime = new DateTime();
$expirationDateTime = new DateTime();
$expirationDateTime->setTimestamp($expiration); // Verifique se $expiration é um timestamp Unix

if ($currentDateTime > $expirationDateTime) {
    $response = array('status' => 'failed', 'message' => 'Dispositivo expirado!');
    die(json_encode($response));
}

// Calcular tempo restante até a expiração
$interval = $currentDateTime->diff($expirationDateTime);

$days = $interval->days;
$hours = $interval->h;
$minutes = $interval->i;

// Tentar acessar o portal com cURL
$portal_url = "https://americamais.com/mytvfun/mytv_api/player_api.php?username=$username&password=$password";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $portal_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response_from_portal = curl_exec($ch);

if (curl_errno($ch)) {
    $portal = "Falha ao acessar o portal: " . curl_error($ch);
} else {
    // Verifique se a resposta está vazia ou contém erros
    if (empty($response_from_portal)) {
        $portal = "Resposta vazia do portal.";
    } else {
        $portal = $response_from_portal;
    }
}

curl_close($ch);

$response = array(
    'status' => 'success',
    'message' => 'Login bem-sucedido!',
    'expiration' => "$days dias $hours hrs $minutes min",
    'username' => $username,
    'password' => $password,
    'codigoRevendedor' => $seller,
    'portal' => $portal,
    'url_do_futebol' => $url_do_futebol,
    'isTeste' => $isTeste
);

die(json_encode($response));

?>
