<?php
if (!isset($_GET["client_id"])) {
	exit;
}
include_once "./system/functions.php";
isLogged();

$logged_user = getLoggedUser();
if (!isAdmin($logged_user) && getServerProperty("manutencaoPainel", 0)) {
  header("Location: ./sair.php");
  exit();
}
$server_name = getServerProperty("server_name");

$bouquets = getBouquets();
$bouquets_ = getBouquets();

$allowed_bouquets = json_decode(getServerProperty("allowed_bouquets"), true);
$fast_packages = json_decode(getServerProperty("fast_packages"), true);
$logotipo = getUserProperty($logged_user['id'], "logotipo");
$titulo = getUserProperty($logged_user['id'], "nomePainel");
$copyright = getUserProperty($logged_user['id'], "copyright");
$client_id = intval($_GET["client_id"]);
$client = getClientByID($client_id);
if (!$client) {
	exit;
}
if (!hasPermission($logged_user["id"], $client["id"])) {
	exit;
}
$user_bouquets = json_decode($client["bouquet"], true);
$server_dns = getServerDNS();

if (isset($_POST["username"]) && isset($_POST["password"]) && isset($_POST["reseller_notes"]) && isset($_POST["bouquet"])) {
	$username = $_POST["username"];
	$mac = $_POST['mac'];
	$mac = strtoupper($mac);
	$password = $_POST["password"];
	$reseller_notes = $_POST["reseller_notes"];
	$bouquet_post = array();
	$bouquet_post = $_POST["bouquet"];
	//var_dump($bouquet_post);die();
	if (is_array($bouquet_post)) {
		foreach ($bouquet_post as $a => $b) {
			if (!in_array($b, $allowed_bouquets)) {
				header("location: ?client_id=" . $client_id . "&result=invalid_bouquet");
				exit;
			}
		}
		if (strlen($username) < 6 || 255 < strlen($username)) {
			header("location: ?client_id=" . $client_id . "&result=invalid_username");
			exit;
		}
		if (strlen($mac) != 12) {
			header("location: ?client_id=" . $client_id . "&result=invalid_mac");
			exit;
		}
		if (strlen($password) < 6 || 255 < strlen($password)) {
			header("location: ?client_id=" . $client_id . "&result=invalid_password");
			exit;
		}
		if (500 < strlen($reseller_notes)) {
			header("location: ?client_id=" . $client_id . "&result=invalid_notes");
			exit;
		}
		$bouquet_post = json_encode($bouquet_post,true);
		//var_dump($bouquet_post);die();
		if (updateClient($client_id, $username, $password, $reseller_notes, $bouquet_post, $mac)) {
			insertRegUserLog($logged_user["id"], $username, $password, "[UserPanel -> Line Edit]");
			header("location: ?client_id=" . $client_id . "&result=success");
			
			exit;
		}
	}

	
}

?>
<!DOCTYPE html>
<html class="no-js css-menubar" lang="en">
<head>

	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
	<meta name="description" content="bootstrap admin template">
	<meta name="author" content="">

	<title>GERENCIADOR</title>

	<link rel="apple-touch-icon" href="temp/assets/images/apple-touch-icon.png">
	<link rel="shortcut icon" href="temp/assets/images/favicon.ico">

	<!-- Stylesheets -->
	<link rel="stylesheet" href="temp/global/css/bootstrap.min.css">
	<link rel="stylesheet" href="temp/global/css/bootstrap-extend.min.css">
	<link rel="stylesheet" href="temp/assets/css/site.min.css">
	<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet"/>
	<link rel="stylesheet" href="temp/global/vendor/toastr/toastr.css">
	<link rel="stylesheet" href="temp/assets/examples/css/advanced/toastr.css">

	<!-- Plugins -->
	<link rel="stylesheet" href="temp/global/vendor/animsition/animsition.css">
	<link rel="stylesheet" href="temp/global/vendor/asscrollable/asScrollable.css">
	<link rel="stylesheet" href="temp/global/vendor/switchery/switchery.css">
	<link rel="stylesheet" href="temp/global/vendor/intro-js/introjs.css">
	<link rel="stylesheet" href="temp/global/vendor/slidepanel/slidePanel.css">
	<link rel="stylesheet" href="temp/global/vendor/flag-icon-css/flag-icon.css">
	<link rel="stylesheet" href="temp/global/vendor/footable/footable.core.css">
	<link rel="stylesheet" href="temp/assets/examples/css/tables/footable.css">


	<!-- Fonts -->
	<link rel="stylesheet" href="temp/global/fonts/font-awesome/font-awesome.css">
	<link rel="stylesheet" href="temp/global/fonts/web-icons/web-icons.min.css">
	<link rel="stylesheet" href="temp/global/fonts/brand-icons/brand-icons.min.css">
	<link rel='stylesheet' href='http://fonts.googleapis.com/css?family=Roboto:300,400,500,300italic'>



	<!-- Scripts -->
	<script src="temp/global/vendor/breakpoints/breakpoints.js"></script>
	<script>
		Breakpoints();
	</script>
</head>
<?php 
include_once "./incluir/menu_lateral.php";
?>


<!-- Page -->
<div class="page">
	<div class="page-header">
		<h1 class="page-title">Editar cliente</h1>
		<ol class="breadcrumb">
			<li class="breadcrumb-item"><a href="/">Painel</a></li>

			<li class="breadcrumb-item active">Editar cliente</li>
		</ol>
		<div class="page-header-actions">

			<button type="button" class="btn btn-sm btn-icon btn-default btn-outline btn-round" data-toggle="tooltip" data-original-title="Refresh" id="goBack">
				<i class="icon wb-refresh" aria-hidden="true"></i>
			</button>

		</div>
	</div>

	<div class="page-content">
		<?php 
		if (isset($_GET["result"])) {
			$result = $_GET["result"];
			$result_message = "Aconteceu um problema, tente novamente mais tarde!";
			$result_type = "warning";
			switch ($result) {
				case "success":
				$result_message = "As alterações foram salvas com sucesso.";
				$result_type = "success";
				break;
				case "invalid_username":
				$result_message = "O nome de usuário escolhido é invalido!, deve ter no mínimo 6 caracteres.";
				break;
				
					case "invalid_mac":
				$result_message = "Mac deve ter 12 caracteres";
				break;
				case "invalid_password":
				$result_message = "A senha escolhida é invalida!, deve ter no mínimo 6 caracteres.";
				break;
				case "invalid_notes":
				$result_message = "A observação escolhida é invalida!, deve ter no máximo 500 caracteres.";
				break;
				case "invalid_bouquet":
				$result_message = "Os pacotes escolhidos são inválidos.";
				break;
			}
			echo "<div id='toast-bottomFullWidth' class='toast-bottom-full-width' aria-live='polite' role='alert'>
			<div class='toast toast-$result_type' style=''>
			<div class='toast-message'>$result_message</div>
			</div>
			</div>";
		}
		?>   
		<div class="panel">
			<div class="panel-body container-fluid">
				<div class="row row-lg">
					<div class="col-md-6">
						<!-- Example Basic Form (Form grid) -->
						<div class="example-wrap">

							<p>Conta vence em: <i><?php echo date("d/m/Y H:i", $client["exp_date"]); ?></i></p>
							<div class="example">
								<form method="post"  action="./clientes_edit.php?client_id=<?= $client_id ?>"  id="editarcliente" class="fv-form fv-form-bootstrap4">

									<div class="row">

										<div class="form-group col-md-12">
										
										</div>
										<div class="form-group col-md-6">
											<label class="form-control-label" for="inputBasicFirstName">MAC</label>
											<input type="text" class="form-control" id="inputBasicFirstName" required="" data-fv-field="mac" placeholder="Mac" autocomplete="off" value="<?php echo $client["username"]; ?>" name="mac" data-minlength="12">
											<span class="text-help">12 caracteres</span>
											<small class="invalid-feedback" data-fv-validator="notEmpty" data-fv-for="username" data-fv-result="NOT_VALIDATED" style="display: none;">Campo mac não pode ser vazio</small><small class="invalid-feedback" data-fv-validator="stringLength" data-fv-for="mac" data-fv-result="NOT_VALIDATED" style="display: none;">deve ter 12 caracteres</small></div>
											
												<div class="form-group col-md-6">
											<label class="form-control-label" for="inputBasicFirstName">Login</label>
											<input type="text" class="form-control" id="inputBasicFirstName" required="" data-fv-field="username" placeholder="Login" autocomplete="off" value="<?php echo $client["username_"]; ?>" name="username" data-minlength="6">
											<span class="text-help">Minimo 6 caracteres</span>
											<small class="invalid-feedback" data-fv-validator="notEmpty" data-fv-for="username" data-fv-result="NOT_VALIDATED" style="display: none;">Campo username não pode ser vazio</small><small class="invalid-feedback" data-fv-validator="stringLength" data-fv-for="username" data-fv-result="NOT_VALIDATED" style="display: none;">Usuário precisa ter mais de 6 caracteres</small></div>
											
											<div class="form-group col-md-6">
												<label class="form-control-label" for="inputBasicLastName">Senha</label>
												<input type="text" class="form-control" id="inputBasicLastName" required="" data-fv-field="password" placeholder="Senha" autocomplete="off" value="<?php echo $client["password"]; ?>" name="password" data-minlength="6">
												<span class="text-help">Minimo 6 caracteres, misturar pelo menos 1 numero ou 1 letra</span>
												<small class="invalid-feedback" data-fv-validator="notEmpty" data-fv-for="password" data-fv-result="NOT_VALIDATED" style="display: none;">Campo Senha não pode ser vazio</small><small class="invalid-feedback" data-fv-validator="stringLength" data-fv-for="password" data-fv-result="NOT_VALIDATED" style="display: none;">Senha precisa ter mais de 6 caracteres</small></div>

												<div class="form-group col-md-6">

												</div>


												<div class="form-group col-md-6">




												</div>
											</div>





											<div class="form-group">
												<label class="form-control-label" for="inputBasicFirstName">Observações</label>
												<textarea class="form-control" placeholder="Adicione informações relevantes" name="reseller_notes"><?php echo $client["reseller_notes"]; ?></textarea>
											</div>



											<div class="form-group">
												<label class="form-control-label" for="inputBasicFirstName">Definir Pacotes <span class="text-danger">* selecione apenas os pacotes desejados e orderne da forma desejada</span></label>




												<div class="row">
													<div class="col-md-5 col-xs-5">
														<select name="from[]" id="multiselect" class="form-control" size="10" multiple="multiple" style="overflow:auto">
															<?php 
															$bouq = array();
															$allow = $allowed_bouquets;


															foreach ($bouquets as $bq) {
																/* filtrar somente pacotes validos (liberados) */																	
																if (in_array($bq["id"], $allowed_bouquets)) {
																	/* filtrar(excluir) os pacotes que já foram selecionados */
																	if (!in_array($bq["id"], $user_bouquets)) {
																		$bouq[] = array(
																			"id" => $bq["id"],
																			"bouquet_name" => $bq["bouquet_name"]
																		);

																	}


																}


															}


															/* exibir pacotes filtrados no array */
															foreach ($bouq as $item) {

																echo "                                  <option value=\"";
																echo $item["id"];
																echo "\">";
																echo $item["bouquet_name"];
																echo "</option>\n                                ";

															}
															?>
														</select>
													</div>

													<div class="col-sm-2">

														<button type="button" id="multiselect_rightSelected" class="btn btn-block btn-direction btn-right btn-warning"><i class="icon wb-chevron-right-mini"></i></button>
														<button type="button" id="multiselect_leftSelected" class="btn btn-block btn-direction btn-left btn-warning mt-5"><i class="icon wb-chevron-left-mini"></i></button>

													</div>

													<div class="col-md-5 col-xs-5">
														<select name="bouquet[]" id="multiselect_to" class="form-control" size="10" multiple="multiple" style="overflow:auto">

															<?php 

															foreach($user_bouquets as $key => $val){


																$titulo = filtro($bouquets,"id","bouquet_name",$user_bouquets[$key]);
																$id = filtro($bouquets,"id","id",$user_bouquets[$key]);


																var_dump($titulo);
																echo "                                                <option value=\"";
																echo $id;
																echo "\" selected>";
																echo $titulo;
																echo "</option>\n                                        ";


															}                                    
															?>
														</select>
														<div class="row mt-10">
															<div class="col-sm-6">
																<button type="button" id="multiselect_move_up" class="btn btn-block btn-direction btn-up btn-warning"><i class="icon wb-chevron-up-mini"></i></button>
															</div>
															<div class="col-sm-6">
																<button type="button" id="multiselect_move_down" class="btn btn-block btn-direction btn-bottom btn-warning"><i class="icon wb-chevron-down-mini"></i></button>
															</div>
														</div>
													</div>
												</div>


											</div>

											<!-- fecha aqui -->


											<div class="form-group">
												<button type="submit" class="btn btn-primary" id="validateButton">Editar Cliente</button>
											</div>
											
										</div>
									</div>
								</form>
							</div>
							<!-- End Example Basic Form (Form grid) -->
							<div class="col-md-6">


								<!--<div class="form-group">
									<label class="form-control-label" for="inputBasicFirstName">Link Atual do Cliente</label>

									<div class="input-group">
										<div class="input-group-addon">
											<span class="input-group-text">m3u plus</span>
										</div>
										<input type="text" class="form-control" id="copymplus" placeholder="link" value="<?php echo $server_dns . "/get.php?username=" . $client["username"] . "&password=" . $client["password"] . "&type=m3u_plus&output=ts"; ?>">
										<span class="input-group-append">
											<button type="button" class="btn btn-success btncopiar" data-clipboard-target="#copymplus">COPIAR</button>
										</span>
									</div>

								</div>
								<div class="form-group">

									<div class="input-group">
										<div class="input-group-addon">
											<span class="input-group-text">m3u</span>
										</div>
										<input type="text" class="form-control" id="copym" placeholder="link" value="<?php echo $server_dns . "/get.php?username=" . $client["username"] . "&password=" . $client["password"] . "&type=m3u&output=ts"; ?>">
										<span class="input-group-append">
											<button type="button" class="btn btn-success btncopiar" data-clipboard-target="#copym">COPIAR</button>
										</span>
									</div>
								</div>


								<div class="form-group">

									<div class="input-group">
										<div class="input-group-addon">
											<span class="input-group-text">hls plus</span>
										</div>
										<input type="text" class="form-control" id="copyhplus" placeholder="link" value="<?php echo $server_dns . "/get.php?username=" . $client["username"] . "&password=" . $client["password"] . "&type=m3u_plus&output=m3u8"; ?>">
										<span class="input-group-append">
											<button type="button" class="btn btn-info btncopiar" data-clipboard-target="#copyhplus">COPIAR</button>
										</span>
									</div>
								</div>

								<div class="form-group">

									<div class="input-group">
										<div class="input-group-addon">
											<span class="input-group-text">hls</span>
										</div>
										<input type="text" class="form-control" id="copyh" placeholder="link" value="<?php echo $server_dns . "/get.php?username=" . $client["username"] . "&password=" . $client["password"] . "&type=m3u&output=m3u8"; ?>">
										<span class="input-group-append">
											<button type="button" class="btn btn-info btncopiar" data-clipboard-target="#copyh">COPIAR</button>
										</span>
									</div>
								</div>-->


							</div>
						</div>
					</div>


				</div>
			</div>



		</div>
	</div>
</div>
</div>
<!-- End Page -->


<!-- Footer -->
<footer class="site-footer">
	<?php 
	include_once "./incluir/footer.php";
	?>
</footer>
<!-- Core  -->
<script src="temp/global/vendor/babel-external-helpers/babel-external-helpers.js"></script>
<script src="temp/global/vendor/jquery/jquery.js"></script>
<script src="temp/global/vendor/popper-js/umd/popper.min.js"></script>
<script src="temp/global/vendor/bootstrap/bootstrap.js"></script>
<script src="temp/global/vendor/animsition/animsition.js"></script>
<script src="temp/global/vendor/mousewheel/jquery.mousewheel.js"></script>
<script src="temp/global/vendor/asscrollbar/jquery-asScrollbar.js"></script>
<script src="temp/global/vendor/asscrollable/jquery-asScrollable.js"></script>
<script src="temp/global/vendor/ashoverscroll/jquery-asHoverScroll.js"></script>

<!-- Plugins -->
<script src="temp/global/vendor/switchery/switchery.js"></script>
<script src="temp/global/vendor/intro-js/intro.js"></script>
<script src="temp/global/vendor/screenfull/screenfull.js"></script>
<script src="temp/global/vendor/slidepanel/jquery-slidePanel.js"></script>
<script src="temp/global/vendor/moment/moment.min.js"></script>
<script src="temp/global/vendor/footable/footable.min.js"></script>

<!-- Scripts -->
<script src="temp/global/js/Component.js"></script>
<script src="temp/global/js/Plugin.js"></script>
<script src="temp/global/js/Base.js"></script>
<script src="temp/global/js/Config.js"></script>

<script src="temp/assets/js/Section/Menubar.js"></script>
<script src="temp/assets/js/Section/GridMenu.js"></script>
<script src="temp/assets/js/Section/Sidebar.js"></script>
<script src="temp/assets/js/Section/PageAside.js"></script>
<script src="temp/assets/js/Plugin/menu.js"></script>

<script src="temp/global/js/config/colors.js"></script>
<script src="temp/assets/js/config/tour.js"></script>
<script>Config.set('assets', 'temp/assets');</script>

<!-- Page -->
<script src="temp/assets/js/Site.js"></script>
<script src="temp/global/js/Plugin/asscrollable.js"></script>
<script src="temp/global/js/Plugin/slidepanel.js"></script>
<script src="temp/global/js/Plugin/switchery.js"></script>

<script src="temp/assets/examples/js/tables/footable.js"></script>
<script src="temp/assets/js/clipboard.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/multiselect/2.2.9/js/multiselect.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/multiselect/2.2.9/js/multiselect.min.js"></script>
<script src="temp/global/vendor/toastr/toastr.js"></script>
<script src="temp/global/js/Plugin/toastr.js"></script>
<script type="text/javascript">
	$('#multiselect').multiselect({sort: false,keepOrder: true  });
</script>
<script type="text/javascript">
	new ClipboardJS('.btncopiar');
</script>
<script type="text/javascript">
  $("#toast-bottomFullWidth").show();
  setTimeout(function () {
    $("#toast-bottomFullWidth").fadeOut();
  }, 6000);
</script>
</body>
</html>
