<?php

include_once './system/functions.php';
isLogged();
$logged_user = getLoggedUser();
$theme_color = getServerProperty("theme_color", "red-skin");
if (!isAdmin($logged_user) && getServerProperty("manutencaoPainel", 0)) {
  header("Location: ./sair.php");
  exit();
}
if (!isAdmin($logged_user)) {
  header("Location: ./index.php");
  exit;
}

$server_name = getServerProperty("server_name");
$fast_packages = json_decode(getServerProperty("fast_packages"), true);
$logotipo = getUserProperty($logged_user['id'], "logotipo");
$titulo = getUserProperty($logged_user['id'], "nomePainel");
$copyright = getUserProperty($logged_user['id'], "copyright");
$settings = getServerProperties();
$fixed_informations = $settings["fixed_informations"];
$fixed_informations2 = $settings["fixed_informations2"];
$fixed_informations3 = $settings["fixed_informations3"];
$email_messages = json_decode($settings["email_messages"], true);
$allowed_groups = isset($settings["allowed_groups"]) ? json_decode($settings["allowed_groups"], true) : array();
$allowed_bouquets = isset($settings["allowed_bouquets"]) ? json_decode($settings["allowed_bouquets"], true) : array();
$automatic_test_packages = isset($settings["automatic_test_packages"]) ? json_decode($settings["automatic_test_packages"], true) : array();
$email_settings = json_decode($settings["email_settings"], true);


if (isset($_POST["save_email_messages"]) && isset($_POST["auto_test_subject"]) && isset($_POST["auto_test_message"]) && isset($_POST["pass_recovery_subject"]) && isset($_POST["pass_recovery_message"])) {
  // var_dump($_POST["save_email_messages"]); die();
  $email_messages = $_POST;
  unset($email_messages["save_email_messages"]);
  $email_messages = json_encode($email_messages);
  $result1 = updateServerProperty("email_messages", $email_messages);
  if ($result1) {
    header("location: ?result=email_messages_saved");
    exit;
  }
  header("location: ?result=failed");
  exit;
}


// ATUALIZAR DADOS DO FORM E TRATAR ERROS
if (isset($_POST["fixed_informations"])) {
  $fixed_informations = $_POST["fixed_informations"];
  $result1 = updateServerProperty("fixed_informations", $fixed_informations);
  if ($result1) {
    header("location: ?result=fixed_informations_saved");
    exit;
  }
  header("location: ?result=failed");
  exit;
}
// ATUALIZAR DADOS DO FORM E TRATAR ERROS
if (isset($_POST["fixed_informations2"])) {
  $fixed_informations2 = $_POST["fixed_informations2"];
  $result2 = updateServerProperty("fixed_informations2", $fixed_informations2);
  if ($result2) {
    header("location: ?result=fixed_informations_saved");
    exit;
  }
  header("location: ?result=failed");
  exit;
}

// ATUALIZAR DADOS DO FORM E TRATAR ERROS
if (isset($_POST["fixed_informations3"])) {
  $fixed_informations3 = $_POST["fixed_informations3"];
  $result3 = updateServerProperty("fixed_informations3", $fixed_informations3);
  if ($result3) {
    header("location: ?result=fixed_informations_saved");
    exit;
  }
  header("location: ?result=failed");
  exit;
}

// GRUPOS PERMITIDOS
if (isset($_POST["save_allowed_groups"]) && isset($_POST["allowed_groups"])) {
  $allowed_groups = json_encode($_POST["allowed_groups"]);
  $result1 = updateServerProperty("allowed_groups", $allowed_groups);
  if ($result1) {
    header("location: ?result=allowed_groups_saved");
    exit;
  }
  header("location: ?result=failed");
  exit;
}
// LISTAS PERMITIDAS
if (isset($_POST["save_allowed_bouquets"]) && isset($_POST["allowed_bouquets"])) {
  $allowed_bouquets = json_encode($_POST["allowed_bouquets"]);
  $result1 = updateServerProperty("allowed_bouquets", $allowed_bouquets);
  if ($result1) {
    header("location: ?result=allowed_bouquets_saved");
    exit;
  }
  header("location: ?result=failed");
  exit;
}
// TESTE MANUAL (TESTE RAPIDO)
if (isset($_POST["save_manual_test"]) && isset($_POST["fast_packages"]) && isset($_POST["test_time"]) && isset($_POST["min_credits"])) {
  $fast_packages = json_encode($_POST["fast_packages"]);
  updateServerProperty("fast_packages", $fast_packages);
  $test_time = intval($_POST["test_time"]);
  updateServerProperty("test_time", $test_time);
  $min_credits = intval($_POST["min_credits"]);
  updateServerProperty("test_min_credits", $min_credits);
  header("location: ?result=manual_test_saved");
  exit;
}
// TESTE AUTOMÁTICO
if (isset($_POST["save_automatic_test"]) && isset($_POST["disabled_days_automatic_test"]) && isset($_POST["automatic_test_packages"]) && isset($_POST["automatic_test_min_credits"])) {
  $automatic_test = isset($_POST["automatic_test"]) ? 1 : 0;
  updateServerProperty("automatic_test", $automatic_test);
  $random_name_automatic_test = isset($_POST["random_name_automatic_test"]) ? 1 : 0;
  updateServerProperty("random_name_automatic_test", $random_name_automatic_test);
  $only_valid_emails_automatic_test = isset($_POST["only_valid_emails_automatic_test"]) ? 1 : 0;
  updateServerProperty("only_valid_emails_automatic_test", $only_valid_emails_automatic_test);
  $disabled_days_automatic_test = $_POST["disabled_days_automatic_test"];
  updateServerProperty("disabled_days_automatic_test", $disabled_days_automatic_test);
  $automatic_test_packages = json_encode($_POST["automatic_test_packages"]);
  updateServerProperty("automatic_test_packages", $automatic_test_packages);
  $automatic_test_min_credits = intval($_POST["automatic_test_min_credits"]);

  // var_dump($automatic_test_min_credits); die();
  
  updateServerProperty("automatic_test_min_credits", $automatic_test_min_credits);
  header("location: ?result=automatic_test_saved");
  exit;
}
// CONFIGURAÇÃO DO EMAIL
if (isset($_POST["save_email_settings"]) && isset($_POST["encryption_type"]) && isset($_POST["sender_name"]) && isset($_POST["sender_email"]) && isset($_POST["use_smtp"]) && isset($_POST["smtp_server"]) && isset($_POST["smtp_port"]) && isset($_POST["smtp_username"]) && isset($_POST["smtp_password"])) {
  $email_settings = $_POST;
  unset($email_settings["save_email_settings"]);
  $email_settings = json_encode($email_settings);
  $result1 = updateServerProperty("email_settings", $email_settings);
  if ($result1) {
    header("location: ?result=email_settings_saved");
    exit;
  }
  header("location: ?result=failed");
  exit;
}
// TRANSFERENCIA DE REVENDAS (ULTILIDADES)
if (isset($_POST["change_resellers"]) && isset($_POST["selected_resellers"]) && isset($_POST["new_owner"]) && isset($_POST["new_group_name"])) {
  $selected_resellers = $_POST["selected_resellers"];
  $new_owner = intval($_POST["new_owner"]);
  $new_group = $_POST["new_group_name"];
  if (is_array($selected_resellers)) {
    $group_settings = json_decode(getServerProperty("group_settings"), true);
    $group_id = isset($group_settings[$new_group]) ? $group_settings[$new_group] : 0;
    if (transferResellers($selected_resellers, $new_owner, $group_id)) {
      header("location: ?result=resellers_changed");
      exit;
    }
  }
  header("location: ?result=failed");
  exit;
}
// ATIVAR EPG
if (isset($_POST["salverEPG"])) {
  $ativare = isset($_POST["ativar_epg"]) ? 1 : 0;
  updateServerProperty("dns", $ativare);
  header("location: ?result=sucesso_epg");
  exit;
}
// ATIVAR LOGIN PERSONALIZADO
if (isset($_POST["salvarLoginPersona"])) {
  $ativarl = isset($_POST["pagLogin"]) ? 1 : 0;
  updateServerProperty("pagLogin", $ativarl);
  header("location: ?result=sucesso_login_personalizado");
  exit;
}
// ATIVAR API DE INFORMAÇÕES DO SERVIDOR DASHBOARD
if (isset($_POST["apiDashSalvar"])) {
  $ativarapi = isset($_POST["apiDashboard"]) ? 1 : 0;
  updateServerProperty("apiDash", $ativarapi);
  header("location: ?result=sucesso_api_dashboard");
  exit;
}
// ATIVAR MANUTENÇÃO DO PAINEL
if (isset($_POST["manutencaoPainelSalvar"])) {
  $manutencaoPainel = isset($_POST["manutencaoPainel"]) ? 1 : 0;
  updateServerProperty("manutencaoPainel", $manutencaoPainel);
  header("location: ?result=sucesso_manutencaoPainel");
  exit;
}



?>
<!DOCTYPE html>
<html class="no-js css-menubar" lang="en">
<head>
  <style type="text/css">
    .paragrafo1{

      color: #ff0000;

    }
  </style>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
  <meta name="description" content="bootstrap admin template">
  <meta name="author" content="">

  <title> GERENCIADOR</title>

  <link rel="apple-touch-icon" href="temp/assets/images/apple-touch-icon.png">
  <link rel="shortcut icon" href="temp/assets/images/favicon.ico">

  <!-- Stylesheets -->
  <link rel="stylesheet" href="temp/global/css/bootstrap.min.css">
  <link rel="stylesheet" href="temp/global/css/bootstrap-extend.min.css">
  <link rel="stylesheet" href="temp/assets/css/site.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.3/css/responsive.bootstrap.min.css">
  <link rel="stylesheet" type="text/css" href="temp/assets/css/responsive.dataTables.min.css"/>
  <link rel="stylesheet" href="temp/global/vendor/summernote/summernote.css">
  <link rel="stylesheet" href="temp/global/vendor/clockpicker/clockpicker.css">
  <link rel="stylesheet" href="temp/global/vendor/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
  <link rel="stylesheet" href="temp/global/vendor/select2/select2.css">




  <!-- Plugins -->
  <link rel="stylesheet" href="temp/global/vendor/animsition/animsition.css">
  <link rel="stylesheet" href="temp/global/vendor/asscrollable/asScrollable.css">
  <link rel="stylesheet" href="temp/global/vendor/switchery/switchery.css">
  <link rel="stylesheet" href="temp/global/vendor/intro-js/introjs.css">
  <link rel="stylesheet" href="temp/global/vendor/slidepanel/slidePanel.css">
  <link rel="stylesheet" href="temp/global/vendor/flag-icon-css/flag-icon.css">
  <link rel="stylesheet" href="temp/assets/css/datatablesEdit.min.css">
  <link rel="stylesheet" href="temp/global/vendor/toastr/toastr.css">
  <link rel="stylesheet" href="temp/assets/examples/css/advanced/toastr.css">
  <link rel="stylesheet" href="temp/global/vendor/bootstrap-select/bootstrap-select.css">
  


  <!-- Fonts -->
  <link rel="stylesheet" href="temp/global/fonts/font-awesome/font-awesome.css">
  <link rel="stylesheet" href="temp/global/fonts/web-icons/web-icons.min.css">
  <link rel="stylesheet" href="temp/global/fonts/brand-icons/brand-icons.min.css">
  <link rel='stylesheet' href='http://fonts.googleapis.com/css?family=Roboto:300,400,500,300italic'>




  <!-- Scripts -->
  <script src="temp/global/vendor/breakpoints/breakpoints.js"></script>
  <script>
    Breakpoints();
  </script>
</head>
<?php 
include_once "./incluir/menu_lateral.php";
?>


<!-- Page -->
<!-- Page -->
<div class="page">
  <div class="page-header">
    <h1 class="page-title">Configurações do painel</h1>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="/">Painel</a></li>

      <li class="breadcrumb-item active">Configurar painel</li>
    </ol>
    <div class="page-header-actions">

    </div>
  </div>

  <div class="page-content container-fluid">
    <?php 
    if (isset($_GET["result"])) {
      $result = $_GET["result"];
      $result_message = "Aconteceu um problema, tente novamente mais tarde!";
      $result_type = "warning";
      switch ($result) {
        case "geral_settings_saved":
        $result_message = "Configurações gerais salvadas com sucesso.";
        $result_type = "success";
        break;
        case "fixed_informations_saved":
        $result_message = "Informações Fixas salvadas com sucesso.";
        $result_type = "success";
        break;
        case "allowed_groups_saved":
        $result_message = "Grupos permitidos salvados com sucesso.";
        $result_type = "success";
        break;
        case "allowed_bouquets_saved":
        $result_message = "Listas permitidas salvadas com sucesso.";
        $result_type = "success";
        break;
        case "manual_test_saved":
        $result_message = "As configurações de teste manual foram salvadas com sucesso.";
        $result_type = "success";
        break;
        case "automatic_test_saved":
        $result_message = "As configurações do gerador de teste automático foram salvadas com sucesso.";
        $result_type = "success";
        break;
        case "resellers_changed":
        $result_message = "Os revendedores foram transferidos com sucesso.";
        $result_type = "success";
        break;
        case "email_messages_saved":
        $result_message = "Mensagens de email salvadas com sucesso.";
        $result_type = "success";
        break;
        case "email_settings_saved":
        $result_message = "Configurações de email salvadas com sucesso.";
        $result_type = "success";
        break;
        case "sucesso_epg":
        $result_message = "Epg Ativado/Desativado com sucesso!!";
        $result_type = "success";
        break;
        case "sucesso_login_personalizado":
        $result_message = "Pág.Login Ativado/Desativado com sucesso!!";
        $result_type = "success";
        break;
        case "sucesso_api_dashboard":
        $result_message = "Api Dashboard Ativado/Desativado com sucesso!!";
        $result_type = "success";
        break;
        case "sucesso_manutencaoPainel":
        $result_message = "manutenção Ativado/Desativado com sucesso!!";
        $result_type = "success";
        break;
      }
      echo'<div id="toast-bottomFullWidth" class="toast-bottom-center" aria-live="polite" role="alert"><div class="toast toast-'.$result_type.'" style=""><div class="toast-message">'.$result_message.'</div></div></div>';
    }
    ?>


    <div class="panel">
      <div class="panel-body container-fluid">
        <div class="row row-lg">
          <div class="col-md-6 col-xl-4">
           <!-- Example Basic -->
           <form autocomplete="off"  action="#" method="post" name="frm1">
             <div class="example-wrap m-lg-0">
              <h4 class="example-title">DNS do servidor</h4>
              <p>Exibição do DNS na página inicial</p>
              <ul class="list-unstyled list-inline example">
                <li class="list-inline-item mr-25 mb-25">
                  <input type="checkbox" data-plugin="switchery" data-color="#9463f7" <?php if (getServerProperty("dns", 0)) {echo "checked";} ?> name="ativar_epg" />
                  <label >Desativar/ativar</label>
                </li>
                <div class="form-group">
                  <button type="submit" class="btn btn-primary btn-block btn-round col-md-6 col-xl-4" name="salverEPG"><i class="icon wb-menu" aria-hidden="true"></i>Editar dados</button>
                </div>
              </ul>
            </div>
          </form>
          <!-- End Example Basic -->
        </div>

        <div class="col-md-6 col-xl-4">
          <!-- Example Basic -->
          <form autocomplete="off"  action="#" method="post" name="frm1">
            <div class="example-wrap m-lg-0">
              <h4 class="example-title">Login personalizado</h4>
              <p>Exibição da página de login personalizada para revenda</p>
              <ul class="list-unstyled list-inline example">
                <li class="list-inline-item mr-25 mb-25">
                  <input type="checkbox" data-plugin="switchery" data-color="#ff4c52" <?php if (getServerProperty("pagLogin", 0)) {echo "checked";} ?> name="pagLogin" />
                  <label >Desativar/ativar</label>
                </li>
                <div class="form-group">
                  <button type="submit" class="btn btn-primary btn-block btn-round col-md-6 col-xl-4" name="salvarLoginPersona"><i class="icon wb-menu" aria-hidden="true"></i>Editar dados</button>
                </div>
              </ul>
            </div>
          </form>
          <!-- End Example Basic -->
        </div>

        <div class="col-md-6 col-xl-4">
          <!-- Example Basic -->
          <form autocomplete="off"  action="#" method="post" name="frm1">
            <div class="example-wrap m-lg-0">
              <h4 class="example-title">DASHBOARD API DE INFORMAÇÕES</h4>
              <p>API de exibição: canais online, offline, total vod, total série da dashboard</p>
              <ul class="list-unstyled list-inline example">
                <li class="list-inline-item mr-25 mb-25">
                  <input type="checkbox" data-plugin="switchery" data-color="#eb6709" <?php if (getServerProperty("apiDash", 0)) {echo "checked";} ?> name="apiDashboard" />
                  <label >Desativar/ativar</label>
                </li>
                <div class="form-group">
                  <button type="submit" class="btn btn-primary btn-block btn-round col-md-6 col-xl-4" name="apiDashSalvar"><i class="icon wb-menu" aria-hidden="true"></i>Editar dados</button>
                </div>
              </ul>
            </div>
          </form>
          <!-- End Example Basic -->
        </div>
        <div class="col-md-6 col-xl-4">
          <!-- Example Basic -->
          <form autocomplete="off"  action="#" method="post" name="frm1">
            <div class="example-wrap m-lg-0">
              <h4 class="example-title">PÁGINA DE MANUTENÇÃO</h4>
              <p>Com o modo manutenção ativado, nenhum revendedor tera acesso ao painel com excessão do administrador</p>
              <ul class="list-unstyled list-inline example">
                <li class="list-inline-item mr-25 mb-25">
                  <input type="checkbox" data-plugin="switchery" data-color="#eb6709" <?php if (getServerProperty("manutencaoPainel", 0)) {echo "checked";} ?> name="manutencaoPainel" />
                  <label >Desativar/ativar</label>
                </li>
                <div class="form-group">
                  <button type="submit" class="btn btn-primary btn-block btn-round col-md-6 col-xl-4" name="manutencaoPainelSalvar"><i class="icon wb-menu" aria-hidden="true"></i>Editar dados</button>
                </div>
              </ul>
            </div>
          </form>
          <!-- End Example Basic -->
        </div>
      </div>
    </div>
  </div>

  <div class="panel">
    <div class="panel-heading">
      <h3 class="panel-title" style="color: red;">Configurar informações primaria da dashboard</h3>
    </div>
    <div class="panel-body">
      <form autocomplete="off"  action="#" method="post" name="frm1">
        <div class="form-group">
         <label class="form-control-label" for="inputBasicFirstName">Informações principal</label>
         <textarea class="form-control" placeholder="Adicione informações na dashboard" id="fixed_informations" name="fixed_informations"><?php echo $fixed_informations;  ?></textarea>
       </div>
       <div class="form-group">
        <button type="submit" class="btn btn-primary btn-block btn-round"><i class="icon wb-menu" aria-hidden="true"></i>Editar dados</button>
      </div>
    </div>
  </form>
</div>



<div class="panel">
  <div class="panel-body container-fluid">
    <div class="row row-lg">
      <div class="col-md-6">
        <!-- Example Basic Form (Form grid) -->
        <div class="example-wrap">
          <div class="example">
            <div class="row">                       
              <div class="form-group col-md-12">
                <h4 class="example-title" style="color: red;"><b>Configurar informação secundária da dashboard</b></h4>
              </div>
            </div>
            <form autocomplete="off"  action="#" method="post" name="frm1">
              <div class="form-group">
               <textarea class="form-control" placeholder="Adicione informações na dashboard" id="fixed_informations2" name="fixed_informations2"><?php echo $fixed_informations2; ?></textarea>
             </div>
             <div class="form-group">
              <button type="submit" class="btn btn-primary btn-block btn-round"><i class="icon wb-menu" aria-hidden="true"></i>Editar dados</button>
            </div>
          </div>
        </form>
      </div>
    </div>
    <!-- End Example Basic Form (Form grid) -->
    <div class="col-md-6">
        <!-- Example Basic Form (Form grid) -->
        <div class="example-wrap">
          <div class="example">
            <div class="row">                       
              <div class="form-group col-md-12">
                <h4 class="example-title" style="color: red;"><b>Configurar informação terceiras da dashboard</b></h4>
              </div>
            </div>
            <form autocomplete="off"  action="#" method="post" name="frm1">
              <div class="form-group">
               <textarea class="form-control" placeholder="Adicione informações na dashboard" id="fixed_informations3" name="fixed_informations3"><?php echo $fixed_informations3; ?></textarea>
             </div>
             <div class="form-group">
              <button type="submit" class="btn btn-primary btn-block btn-round"><i class="icon wb-menu" aria-hidden="true"></i>Editar dados</button>
            </div>
          </div>
        </form>
      </div>
    </div>
    <!-- End Example Basic Form (Form grid) -->



  </div>
</div>



<!-- End Example Striped Rows -->
</div>
<div class="panel">
  <div class="panel-body container-fluid">
    <div class="row row-lg">
      <div class="col-md-6">
        <!-- Example Basic Form (Form grid) -->
        <div class="example-wrap">
          <div class="example">
            <div class="row">                       
              <div class="form-group col-md-6">
                <h4 class="example-title" style="color: red;"><b>Configurar modelo de email (TESTE)</b></h4>
              </div>
            </div>
            <form autocomplete="off"  action="#" method="post" name="frm1">
              <div class="form-group form-material" data-plugin="formMaterial">
                <label class="form-control-label" for="inputHint" style="color: red;"><b>Titulo do email</b></label>
                <input type="text" value="<?php echo $email_messages["auto_test_subject"]; ?>" class="form-control" id="auto_test_subject" name="auto_test_subject" placeholder="Insira o titulo do seu email" data-hint="Insira o titulo do seu email"><div class="hint">Titulo da mensagem que você ira enviar no teste automático</div>
              </div>
              <div class="form-group">
               <textarea class="form-control" placeholder="Adicione informações na dashboard" id="auto_test_message" name="auto_test_message"><?php echo $email_messages["auto_test_message"]; ?></textarea>
             </div>
           </div>
           <div class="form-group col-md-12 text-center">
            <button type="submit" name="save_email_messages" class="btn btn-primary btn-block btn-round"><i class="icon wb-menu" aria-hidden="true"></i>Editar dados</button>
          </div>
        </div>
      </div>
      <div class="col-md-6">
        <!-- Example Basic Form (Form grid) -->
        <div class="example-wrap">
          <div class="example">
            <div class="row">                       
              <div class="form-group col-md-6">
                <h4 class="example-title" style="color: red;"><b>Configurar modelo de email (RESET SENHA)</b></h4>
              </div>
            </div>
            <div class="form-group form-material" data-plugin="formMaterial">
              <label class="form-control-label" for="inputHint" style="color: red;"><b><?php echo $email_messages["pass_recovery_subject"]; ?></b></label>
              <input type="text" value="<?php echo $email_messages["pass_recovery_subject"]; ?>" class="form-control" id="pass_recovery_subject" name="pass_recovery_subject" placeholder="Insira o titulo do seu email" data-hint="Insira o titulo do seu email"><div class="hint">Titulo da mensagem que você ira enviar na redefinição de senha</div>
            </div>
            <div class="form-group">
             <textarea class="form-control" placeholder="Adicione informações na dashboard" id="pass_recovery_message" name="pass_recovery_message"><?php echo $email_messages["pass_recovery_message"]; ?></textarea>
           </div>
         </div>
         <div class="form-group col-md-12 text-center">
          <button type="submit" name="save_email_messages" class="btn btn-primary btn-block btn-round"><i class="icon wb-menu" aria-hidden="true"></i>Editar dados</button>
        </div>
      </div>
    </form>
  </div>
  <!-- End Example Basic Form (Form grid) -->
</div>
</div>
<!-- Panel Click To Edit -->
</div>
<!-- FINAL -->
<!-- INICIO -->
<div class="panel">
  <div class="panel-heading">
    <h3 class="panel-title" style="color: red;">Servidor SMTP - Envios de e-mail em massa</h3>
  </div>
  <div class="panel-body container-fluid">
    <div class="row row-lg">
      <!-- 1 -->
      <div class="col-md-6 col-lg-6">
        <h4 class="example-title">Nome do remetente</h4>
        <div class="input-group">
          <span class="input-group-addon">
            <span class="icon fa-user"></span>
          </span>
          <input type="text" class="form-control round" name="sender_name" placeholder="Nome do remetente" value="<?php echo $email_settings["sender_name"]; ?>">
        </div>
      </div>
      <!-- 1 FINAL -->
      <!-- 1 -->
      <div class="col-md-6 col-lg-6">
        <h4 class="example-title">Email do remetente</h4>
        <div class="input-group">
          <span class="input-group-addon">
            <span class="icon fa-envelope"></span>
          </span>
          <input type="text" class="form-control round use_smtp" name="sender_email" placeholder="Email do remetente" value="<?php echo $email_settings["sender_email"]; ?>">
        </div>
      </div>
      <!-- 1 FINAL -->
    </div>
    <h4 class="example-title">Métodos de envio</h4>
    <div class="radio-custom radio-primary">
      <input type="radio" name="use_smtp" class="flat-red use_smtp" value="0" <?php if ($email_settings["use_smtp"] == 0) {echo "checked";}?>>
      <label for="inputRadiosChecked">Direto do servidor</label>
    </div>
    <div class="radio-custom radio-primary">
      <input type="radio" name="use_smtp" class="flat-red use_smtp" value="1" <?php if ($email_settings["use_smtp"] == 1) {echo "checked";}?>>
      <label for="inputRadiosChecked">Servidor SMTP</label>
    </div>
    <div class="row row-lg">
      <!-- 1 -->
      <div class="col-md-6 col-lg-6">
        <h4 class="example-title">SMTP Server</h4>
        <div class="input-group smtp_form">
          <span class="input-group-addon">
            <span class="icon fa-server"></span>
          </span>
          <input type="text" class="form-control round" id="smtp_server" name="smtp_server" autocomplete="off" maxlength="255" placeholder="SMTP Server" value="<?php echo $email_settings["smtp_server"]; ?>" <?php if ($email_settings["use_smtp"] == 0) {echo "readonly";}?>>
        </div>
      </div>
      <!-- 1 FINAL -->
      <!-- 1 -->
      <div class="col-md-6 col-lg-6">
        <h4 class="example-title">SMTP Port</h4>
        <div class="input-group">
          <span class="input-group-addon">
            <span class="fa fa-plug"></span>
          </span>
          <input type="text" class="form-control round" id="smtp_port" name="smtp_port" placeholder="SMTP Porta" value="<?php echo $email_settings["smtp_port"]; ?>" autocomplete="off" <?php if ($email_settings["use_smtp"] == 0) {echo "readonly";}?>>
        </div>
      </div>
      <!-- 1 FINAL -->
      <!-- 1 -->
      <div class="col-md-6 col-lg-6">
        <h4 class="example-title">Usuario</h4>
        <div class="input-group">
          <span class="input-group-addon">
            <span class="fa fa-plug"></span>
          </span>
          <input type="text" class="form-control round" id="smtp_username" name="smtp_username" placeholder="SMTP Username" value="<?php echo $email_settings["smtp_username"]; ?>" autocomplete="off" maxlength="100" <?php if ($email_settings["use_smtp"] == 0) {echo "readonly";}?>>
        </div>
      </div>
      <!-- 1 FINAL -->
      <!-- 1 -->
      <div class="col-md-6 col-lg-6">
        <h4 class="example-title">Senha</h4>
        <div class="input-group">
          <span class="input-group-addon">
            <span class="fa fa-plug"></span>
          </span>
          <input type="password" class="form-control round" id="smtp_password" name="smtp_password" placeholder="SMTP Password" value="<?php echo $email_settings["smtp_password"]; ?>" autocomplete="off" maxlength="100" <?php if ($email_settings["use_smtp"] == 0) {echo "readonly";}?>>
        </div>
      </div>
      <!-- 1 FINAL -->
    </div>
    <h4 class="example-title">Modos de segurança</h4>
    <div class="radio-custom radio-primary">
      <input type="radio" name="encryption_type" <?php if ($email_settings["encryption_type"] === "") {echo "checked";}?> <?php if ($email_settings["use_smtp"] == 0) {echo "readonly";}?>>
      <label for="inputRadiosChecked">Não usar</label>
    </div>
    <div class="radio-custom radio-primary">
      <input type="radio" name="encryption_type" value="TLS" <?php if ($email_settings["encryption_type"] === "TLS") {echo "checked";}?> <?php if ($email_settings["use_smtp"] == 0) {echo "readonly";}?>>
      <label for="inputRadiosChecked">TLS</label>
    </div>
    <div class="radio-custom radio-encryption_type">
      <input type="radio" name="encryption_type" value="SSL" <?php if ($email_settings["encryption_type"] === "SSL") {echo "checked";}?> <?php if ($email_settings["use_smtp"] == 0) {echo "readonly";}?>>
      <label for="inputRadiosChecked">SSL</label>
    </div>
  </form>
</div>



</div>
<!-- FINAL -->
<!-- COMEÇO -->
<div class="panel">
  <div class="row row-lg">
    <div class="col-md-6">
      <div class="panel-heading">
        <h3 class="panel-title" style="color: red;">Controle de acesso ao painel</h3>
      </div>
      <div class="panel-body">
        <form autocomplete="off" action="#" method="post">
          <div class="form-group">
            <h4 class="example-title">Selecione os grupos que tem permissão para acessar o painel office.</h4>
            <select class="form-control" multiple="" name="allowed_groups[]" id="allowed_groups">
              <?php  
              foreach (getAllGroups() as $group) {
                if (in_array($group["group_id"], $allowed_groups)) {
                  echo "                            <option value=\"";
                  echo $group["group_id"];
                  echo "\" selected>";
                  echo $group["group_name"];
                  echo "</option>\n                      ";
                } else {
                  echo "                            <option value=\"";
                  echo $group["group_id"];
                  echo "\">";
                  echo $group["group_name"];
                  echo "</option>\n                      ";
                }
              }
              ?>
            </select>
          </div>
          <div class="form-group col-md-12 text-center">
            <button type="submit" name="save_allowed_groups" class="btn btn-primary btn-block btn-round"><i class="icon wb-menu" aria-hidden="true"></i>Editar dados</button>
          </div>
        </form>
      </div>
    </div>
    <div class="col-md-6">
      <div class="panel-heading">
        <h3 class="panel-title" style="color: red;">Controle de pacotes permitidos</h3>
      </div>
      <div class="panel-body">
        <h4 class="example-title">Selecione os pacotes permitidos para os revendedores.</h4>
        <form autocomplete="off" action="#" method="post">
          <div class="form-group">
            <select class="form-control" multiple="" name="allowed_bouquets[]" id="allowed_bouquets">
              <?php  
              foreach (getBouquets() as $bouquet) {
                if (in_array($bouquet["id"], $allowed_bouquets)) {
                  echo "                            <option value=\"";
                  echo $bouquet["id"];
                  echo "\" selected>";
                  echo $bouquet["bouquet_name"];
                  echo "</option>\n                      ";
                } else {
                  echo "                            <option value=\"";
                  echo $bouquet["id"];
                  echo "\">";
                  echo $bouquet["bouquet_name"];
                  echo "</option>\n                      ";
                }
              }
              ?>
            </select>
          </div>
          <div class="form-group col-md-12 text-center">
            <button type="submit" name="save_allowed_bouquets" class="btn btn-primary btn-block btn-round"><i class="icon wb-menu" aria-hidden="true"></i>Editar dados</button>
          </div>
        </form>
      </div>
    </div>
  </div>
  <!-- FINAL -->
</div>
<!-- COMEÇO -->
<div class="panel">
  <div class="row row-lg">
    <div class="col-md-6">
      <div class="panel-heading">
        <h3 class="panel-title" style="color: red;">Configurar teste rápido - MANUAL</h3>
      </div>

      <div class="panel-body">
        <h4 class="example-title">Selecione os pacotes para criação de teste rápido no menu lateral.</h4>
        <form autocomplete="off" action="#" method="post">
          <div class="form-group">
            <select class="form-control" multiple="" name="fast_packages[]">
              <?php  
              foreach (getPackages() as $package) {
                if ($package["is_trial"]) {
                  if (in_array($package["id"], $fast_packages)) {
                    echo "                              <option value=\"";
                    echo $package["id"];
                    echo "\" selected>";
                    echo $package["package_name"];
                    echo "</option>\n                      ";
                  } else {
                    echo "                              <option value=\"";
                    echo $package["id"];
                    echo "\">";
                    echo $package["package_name"];
                    echo "</option>\n                      ";
                  }
                }
              }
              ?>
            </select>
          </div>
          <div class="example-wrap">
            <h4 class="example-title">Defina o tempo do teste customizado</h4>
            <div class="input-group">
              <span class="input-group-addon">
                <span class="wb-time"></span>
              </span>
              <input type="number" class="form-control round" value="<?php echo getServerProperty("test_time", 1); ?>" data-minlength="0" minlength="0" autocomplete="off" name="test_time">
            </div>
            <h4 class="example-title">Defina o minimo de créditos para a criação de testes</h4>
            <div class="input-group">
              <span class="input-group-addon">
                <span class="icon fa-money"></span>
              </span>
              <input type="text" class="form-control round"  value="<?php echo getServerProperty("test_min_credits", 0); ?>" data-minlength="0" minlength="0" autocomplete="off"  name="min_credits">
            </div>
          </div>
          <div class="form-group col-md-12 text-center">
            <button type="submit" name="save_manual_test" class="btn btn-primary btn-block btn-round"><i class="icon wb-menu" aria-hidden="true"></i>Editar dados</button>
          </div>
        </form>
      </div>
    </div>
    <!-- 2 -->
    <div class="col-md-6">
      <div class="panel-heading">
        <h3 class="panel-title" style="color: red;">Transferir revendedores</h3>
      </div>

      <div class="panel-body">
        <h4 class="example-title">Selecione os revendedores que você deseja transferir.</h4>
        <form autocomplete="off" action="#" method="post">
          <div class="form-group">
            <select class="form-control" multiple data-plugin="select2" id="selected_resellers" name="selected_resellers[]">
              <?php  
              $all_users = getAllUsers();
              foreach ($all_users as $user) {
                $owner_name = "-";
                if ($user["owner_id"]) {
                  $user_key = array_search($user["owner_id"], array_column($all_users, "id"));
                  if ($user_key !== false) {
                    $owner_name = $all_users[$user_key]["username"];
                  }
                }
                echo "                                  <option value=\"";
                echo $user["id"];
                echo "\">";
                echo $user["username"] . " (" . $owner_name . ")";
                echo "</option>\n                              ";
              }
              ?>
            </select>
          </div>
          <div class="example-wrap">
            <h4 class="example-title">Selecione o novo dono</h4>
            <div class="example">
              <select class="form-control" data-plugin="select2" id="new_owner" name="new_owner">
                <?php  
                $all_users = getAllUsers();
                foreach ($all_users as $user) {
                  echo "                                  <option value=\"";
                  echo $user["id"];
                  echo "\">";
                  echo $user["username"];
                  echo "</option>\n                              ";
                }
                ?>
              </select>
            </div>
            <h4 class="example-title">Alterar grupo</h4>
            <select class="form-control" data-plugin="select2" id="new_group_name" name="new_group_name">
              <?php  
              $group_settings = json_decode(getServerProperty("group_settings"), true);
              $ultra_group = getGroupByID($group_settings["ultra"]);
              $master_group = getGroupByID($group_settings["master"]);
              $reseller_group = getGroupByID($group_settings["reseller"]);
              echo "<option value=''>*Não alterar o grupo dos revendedores</option>";
              echo "<option value='ultra'>" . $ultra_group["group_name"] . "</option>";
              echo "<option value='master'>" . $master_group["group_name"] . "</option>";
              echo "<option value='reseller'>" . $reseller_group["group_name"] . "</option>";
              ?>
            </select>
          </div>
          <div class="form-group col-md-12 text-center">
            <button type="submit" name="change_resellers" class="btn btn-primary btn-block btn-round"><i class="icon wb-menu" aria-hidden="true"></i>Editar dados</button>
          </div>
        </form>
      </div>
    </div>
  </div>
  <!-- FINAL -->
</div>
<div class="panel">
  <div class="panel-heading">
    <h3 class="panel-title" style="color: red;">Configurar teste rápido - AUTOMÁTICO</h3>
  </div>
  <div class="panel-body">
    <form autocomplete="off" action="#" method="post">
      <h4 class="example-title">Gerador de teste automático. <label> *Ativa ou Desativa o teste automático</label></h4>
      <div class="checkbox-custom checkbox-primary">
        <input type="checkbox" <?php if (getServerProperty("automatic_test", 0)) {echo "checked";} ?> name="automatic_test">
        <label >Ativar/desativar</label>
      </div><hr>
      <h4 class="example-title">Gerar nome de usuário aleatório. <label> *Com essa opção ativada o painel irá gerar um nome de usuário aleatorio.</label></h4>
      <div class="checkbox-custom checkbox-primary">
        <input type="checkbox" <?php if (getServerProperty("random_name_automatic_test", 0)) {echo "checked";}?> name="random_name_automatic_test">
        <label >Ativar/desativar</label>
      </div><hr>
      <h4 class="example-title">Permitir apenas e-mails válidos. <label> *Com essa opção ativada o painel irá permitir apenas e-mails válidos(@gmail, @hotmail, @outlook e @icloud).</label></h4>
      <div class="checkbox-custom checkbox-primary">
        <input type="checkbox" <?php if (getServerProperty("only_valid_emails_automatic_test", 0)) {echo "checked";}?> name="only_valid_emails_automatic_test">
        <label >Ativar/desativar</label>
      </div><hr>
      <div class="form-group">
        <h4 class="example-title">Selecione os pacotes para o gerador de teste automático.</h4>
        <select class="form-control" multiple="" name="automatic_test_packages[]" id="automatic_test_packages">
          <?php  
          foreach (getPackages() as $package) {
            if ($package["is_trial"]) {
              if (in_array($package["id"], $automatic_test_packages)) {
                echo "                              <option value=\"";
                echo $package["id"];
                echo "\" selected>";
                echo $package["package_name"];
                echo "</option>\n                      ";
              } else {
                echo "                              <option value=\"";
                echo $package["id"];
                echo "\">";
                echo $package["package_name"];
                echo "</option>\n                      ";
              }
            }
          }
          ?>
        </select>
      </div>
      <div class="example-wrap">
        <h4 class="example-title">DEFINA O MINIMO DE CRÉDITOS PARA A UTILIZAÇÃO DO GERADOR DE TESTE AUTOMÁTICO.</h4>
        <div class="input-group">
          <span class="input-group-addon">
            <span class="icon fa-money"></span>
          </span>
          <input type="number" class="form-control round" value="<?php echo getServerProperty("automatic_test_min_credits", 1); ?>" data-minlength="0" minlength="0" autocomplete="off" name="automatic_test_min_credits">
        </div>
        <h4 class="example-title">Selecione dias para deixar o gerador de teste desativado. <label> *Útil para desativar o gerador de teste em dia de jogo.</label>
          <div class="input-group">
            <span class="input-group-addon">
              <span class="icon fa-calendar"></span>
            </span>
            <input type="text" class="form-control datepair-date datepair-end" name="disabled_days_automatic_test" data-plugin="datepicker" id="datepicker" value="<?php echo getServerProperty("disabled_days_automatic_test", ""); ?>">
          </div>
        </div>
        <div class="form-group col-md-12 text-center">
          <button type="submit" name="save_automatic_test" class="btn btn-primary btn-block btn-round"><i class="icon wb-menu" aria-hidden="true"></i>Editar dados</button>
        </div>
      </form>
    </div>
  </div>
</div>
</div>
<!-- End Page -->


<!-- Footer -->
<footer class="site-footer">
  <?php 
  include_once "./incluir/footer.php";
  ?>
</footer>
<!-- Core  -->
<script src="temp/global/vendor/babel-external-helpers/babel-external-helpers.js"></script>
<script src="temp/global/vendor/jquery/jquery.js"></script>
<script src="temp/global/vendor/popper-js/umd/popper.min.js"></script>
<script src="temp/global/vendor/bootstrap/bootstrap.js"></script>
<script src="temp/global/vendor/animsition/animsition.js"></script>
<script src="temp/global/vendor/mousewheel/jquery.mousewheel.js"></script>
<script src="temp/global/vendor/asscrollbar/jquery-asScrollbar.js"></script>
<script src="temp/global/vendor/asscrollable/jquery-asScrollable.js"></script>
<script src="temp/global/vendor/ashoverscroll/jquery-asHoverScroll.js"></script>

<!-- Plugins -->
<script src="temp/global/vendor/switchery/switchery.js"></script>
<script src="temp/global/vendor/intro-js/intro.js"></script>
<script src="temp/global/vendor/screenfull/screenfull.js"></script>
<script src="temp/global/vendor/slidepanel/jquery-slidePanel.js"></script>
<script src="temp/global/vendor/moment/moment.min.js"></script>
<script src="temp/global/vendor/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>

<!-- Scripts -->
<script src="temp/global/js/Component.js"></script>
<script src="temp/global/js/Plugin.js"></script>
<script src="temp/global/js/Base.js"></script>
<script src="temp/global/js/Config.js"></script>

<script src="temp/assets/js/Section/Menubar.js"></script>
<script src="temp/assets/js/Section/GridMenu.js"></script>
<script src="temp/assets/js/Section/Sidebar.js"></script>
<script src="temp/assets/js/Section/PageAside.js"></script>
<script src="temp/assets/js/Plugin/menu.js"></script>

<script src="temp/global/js/config/colors.js"></script>
<script src="temp/assets/js/config/tour.js"></script>
<script>Config.set('assets', 'temp/assets');</script>

<!-- Page -->
<script src="temp/assets/js/Site.js"></script>
<script src="temp/global/js/Plugin/asscrollable.js"></script>
<script src="temp/global/js/Plugin/slidepanel.js"></script>
<script src="temp/global/js/Plugin/switchery.js"></script>


<script src="temp/assets/js/bootbox.js"></script>
<script src="temp/assets/js/bootbox.min.js"></script>
<script src="temp/assets/js/ckeditor/ckeditor.js"></script>



<script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>

<script src="https://cdn.datatables.net/responsive/2.2.3/js/dataTables.responsive.min.js"></script>
<script src="temp/global/vendor/summernote/summernote.min.js"></script>
<script src="temp/global/js/Plugin/summernote.js"></script>
<script src="temp/global/js/Plugin/toastr.js"></script>
<script src="temp/global/vendor/toastr/toastr.js"></script>
<script src="temp/assets/examples/js/forms/editor-summernote.js"></script>
<script src="temp/global/js/Plugin/clockpicker.js"></script>
<script src="temp/global/vendor/clockpicker/bootstrap-clockpicker.min.js"></script>
<script src="temp/global/vendor/bootstrap-select/bootstrap-select.js"></script>
<script src="temp/global/js/Plugin/bootstrap-select.js"></script>
<script src="temp/global/js/Plugin/select2.js"></script>
<script src="temp/global/vendor/select2/select2.full.min.js"></script>
<script type="text/javascript">
  CKEDITOR.replace('fixed_informations');
  CKEDITOR.replace('fixed_informations2');
  CKEDITOR.replace('fixed_informations3');
  CKEDITOR.replace('auto_test_message');
  CKEDITOR.replace('pass_recovery_message');
  CKEDITOR.config.defaultLanguage = 'pt-br';
</script>

<script type="text/javascript">
  $("#toast-bottomFullWidth").show();
  setTimeout(function () {
    $("#toast-bottomFullWidth").fadeOut();
  }, 6000);
</script>
<script type="text/javascript">
  ("#datepicker").datepicker({
    'multidate:' true,
    'howOtherMonths:' true,
    'selectOtherMonths:' true});
  </script>
  <script type="text/javascript">
    $(".alert").delay(3000).slideUp(200, function() {
      $(this).alert('close');
    });
    $('input[type="checkbox"].flat-red, input[type="radio"].flat-red').iCheck({
      checkboxClass: 'icheckbox_flat-green',    
      radioClass   : 'iradio_flat-green'
    });
    $('.use_smtp').on('ifChecked', function(event){
      if($('.use_smtp:checked').val() === '0'){
        $(".smtp_form :input").attr("readonly", true);
      } else {
        $(".smtp_form :input").removeAttr("readonly");
      }
    });
    $('#checkbox_id').on('ifUnchecked', function () ({});
  </script>
</body>
</html>
