<?php
include_once "./system/functions.php";
isLogged();
$logged_user = getLoggedUser();
if (!isAdmin($logged_user) && getServerProperty("manutencaoPainel", 0)) {
  header("Location: ./sair.php");
  exit();
}
$server_name = getServerProperty("server_name");
$allowed_bouquets = json_decode(getServerProperty("allowed_bouquets"), true);
$fast_packages = json_decode(getServerProperty("fast_packages"), true);
$logotipo = getUserProperty($logged_user['id'], "logotipo");
$titulo = getUserProperty($logged_user['id'], "nomePainel");
$copyright = getUserProperty($logged_user['id'], "copyright");
$test_time = getServerProperty("test_time", 1);
if (isset($_POST["username"]) && isset($_POST["password"]) && isset($_POST["duration"]) && isset($_POST["reseller_notes"]) && isset($_POST["bouquet"])) {
	if (!isAdmin($logged_user) && $logged_user["credits"] < getServerProperty("test_min_credits", 0)) {
		header("location: ?result=no_min_credits");
		exit;
	}
	
    $mac = $_POST["MAC"];
	$username = $_POST["username"];
	$password = $_POST["password"];
	$duration = intval($_POST["duration"]);
	$reseller_notes = $_POST["reseller_notes"];
	$bouquet = $_POST["bouquet"];
	$email = isset($_POST["email"]) ? $_POST["email"] : "";
	$send_email = isset($_POST["send_email"]);
	if (is_array($bouquet)) {
		foreach ($bouquet as $a => $b) {
			if (!in_array($b, $allowed_bouquets)) {
				header("location: ?result=invalid_bouquet");
				exit;
			}
		}
		$duration = $test_time . " hours";
		if (strlen($mac) != 12) {
		    $len =  strlen($mac);
			header("location: ?result=invalid_mac&len=$len");
			exit;
		}
		
		if (strlen($username) < 6 || 255 < strlen($username)) {
			header("location: ?result=invalid_username");
			exit;
		}
		if (strlen($password) < 6 || 255 < strlen($password)) {
			header("location: ?result=invalid_password");
			exit;
		}
		if (500 < strlen($reseller_notes)) {
			header("location: ?result=invalid_notes");
			exit;
		}
		$bouquet = json_encode($bouquet);
		if ($send_email && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
			header("location: ?key=" . $key . "&result=invalid_email");
			exit;
		}
		
		if (createClient($logged_user["id"], $username, $password, $duration, $bouquet, $reseller_notes, 1, $mac)) {
			insertRegUserLog($logged_user["id"], $username, $password, "[<b>UserPanel</b> -> <u>New Line</u>] with Package [Custom Package], Credits: <font color=\"green\">" . $logged_user["credits"] . "</font> -> <font color=\"red\">" . $logged_user["credits"] . "</font>");
			if ($send_email) {
				$list_link = GetList($username, $password);
				$email_messages = json_decode(getServerProperty("email_messages"), true);
				$whatsapp = getUserProperty($logged_user["id"], "whatsapp");
				$telegram = getUserProperty($logged_user["id"], "telegram");
				$auto_test_subject = str_replace(array("{USERNAME}", "{PASSWORD}", "{SERVER_NAME}"), array($username, $password, $server_name), $email_messages["auto_test_subject"]);
				$auto_test_message = str_replace(array("{USERNAME}", "{PASSWORD}", "{LIST_LINK}", "{SERVER_NAME}", "{RESELLER_EMAIL}", "{WHATSAPP}", "{TELEGRAM}"), array($username, $password, $list_link, $server_name, $logged_user["email"], $whatsapp, $telegram), $email_messages["auto_test_message"]);
				if (smtpmailer($email, $auto_test_subject, $auto_test_message)) {
					header("location: ?key=" . $key . "&result=success");
					exit;
				}
				header("location: ?result=cant_send_email");
				exit;
			}
			
			// Obtém a data atual
                $dataAtual = date('Y/m/d H:i:s');
                // Adiciona um mês à data atual usando strtotime
                $dataFutura = date('Y/m/d H:i:s', strtotime("+6 hours", strtotime($dataAtual)));
				header("location: ?result=success&user=$username&pass=$password&exp=$dataFutura&opcional=$reseller_notes");
				
			//header("location: ?result=success");
			exit;
		}
		header("location: ?result=exist_client");
		exit;
	}
}
?>
<!DOCTYPE html>
<html class="no-js css-menubar" lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
	<meta name="description" content="bootstrap admin template">
	<meta name="author" content="">

	<title>CRIAR TESTE</title>

	<link rel="apple-touch-icon" href="temp/assets/images/apple-touch-icon.png">
	<link rel="shortcut icon" href="temp/assets/images/favicon.ico">

	<!-- Stylesheets -->
	<link rel="stylesheet" href="temp/global/css/bootstrap.min.css">
	<link rel="stylesheet" href="temp/global/css/bootstrap-extend.min.css">
	<link rel="stylesheet" href="temp/assets/css/site.min.css">
	<link rel="stylesheet" href="temp/global/vendor/toastr/toastr.css">
	<link rel="stylesheet" href="temp/assets/examples/css/advanced/toastr.css">
	<!-- Plugins -->
	<link rel="stylesheet" href="temp/global/vendor/animsition/animsition.css">
	<link rel="stylesheet" href="temp/global/vendor/asscrollable/asScrollable.css">
	<link rel="stylesheet" href="temp/global/vendor/switchery/switchery.css">
	<link rel="stylesheet" href="temp/global/vendor/intro-js/introjs.css">
	<link rel="stylesheet" href="temp/global/vendor/slidepanel/slidePanel.css">
	<link rel="stylesheet" href="temp/global/vendor/flag-icon-css/flag-icon.css">
	<link rel="stylesheet" href="temp/global/vendor/footable/footable.core.css">
	<link rel="stylesheet" href="temp/assets/examples/css/tables/footable.css">


	<!-- Fonts -->
	<link rel="stylesheet" href="temp/global/fonts/font-awesome/font-awesome.css">
	<link rel="stylesheet" href="temp/global/fonts/web-icons/web-icons.min.css">
	<link rel="stylesheet" href="temp/global/fonts/brand-icons/brand-icons.min.css">
	<link rel='stylesheet' href='http://fonts.googleapis.com/css?family=Roboto:300,400,500,300italic'>



	<!-- Scripts -->
	<script src="temp/global/vendor/breakpoints/breakpoints.js"></script>
	<script>
		Breakpoints();
	</script>
</head>
<?php 
include_once "./incluir/menu_lateral.php";
?>

<!-- Page -->
<div class="page">
	<div class="page-header">
		<h1 class="page-title">Criar cliente</h1>
		<ol class="breadcrumb">
			<li class="breadcrumb-item"><a href="/">Painel</a></li>

			<li class="breadcrumb-item active">Criar cliente</li>
		</ol>
		<div class="page-header-actions">

			<button type="button" class="btn btn-sm btn-icon btn-default btn-outline btn-round" data-toggle="tooltip" data-original-title="Refresh" id="goBack">
				<i class="icon wb-refresh" aria-hidden="true"></i>
			</button>

		</div>
	</div>

	<div class="page-content">
		<?php 
		if (isset($_GET["result"])) {
			$result = $_GET["result"];
				$user = $_GET['user'];
			$pass= $_GET['pass'];
	
			$devices = $_GET['dispositivos'];
			$exp = $_GET['exp'];
			$result_message = "Aconteceu um problema, tente novamente mais tarde!";
			$result_type = "warning";
			switch ($result) {
				case "success":
				$result_message = "O teste foi criado com sucesso.  Veja as informações abaixo:
				<div id='ShowInfo_modal_content'><br>Usuario de testes criado:<br><br>✅ | Usuário: $user

                   <br> ✅ | Senha: $pass

                   <br> ✅ | Expiração: $exp
                    
                   <br> ✅ | Informações opcionais: $opcional
                    
                   </div><br>
                   <button class=\"btn btn-warning\" id=\"registerUser_Copy\" onclick=\"RegisterUser_copy();\" style=\"font-family: arial; display: inline-block;\">Copiar Informações</button>
                   ";
				$result_type = "success";
				break;
				case "invalid_username":
				$result_message = "O nome de usuário escolhido é invalido!, deve ter no mínimo 6 caracteres.";
				break;
				case "invalid_password":
				$result_message = "A senha escolhida é invalida!, deve ter no mínimo 6 caracteres.";
				break;
				case "invalid_notes":
				$result_message = "A observação escolhida é invalida!, deve ter no máximo 500 caracteres.";
				break;
				case "invalid_bouquet":
				$result_message = "Os pacotes escolhidos são inválidos.";
				break;
				case "invalid_email":
				$result_message = "O e-mail escolhido é invalido!";
				break;
				case "cant_send_email":
				$result_message = "O teste foi criado com sucesso, mas não foi possível enviar o e-mail com os dados de acesso.";
				break;
				case "exist_client":
				$result_message = "Já existe um usuário com este nome de usuário, escolha outro.";
				break;
				case "no_min_credits":
				$result_message = "Você não tem a quantidade minima de créditos para criar o teste.";
				break;
				case 'invalid_mac':
				    	$result_message = "MAC deve possuir 12 caracteres.";
				    break;
			}
			echo'<div id="toast-bottomFullWidth" class="toast-bottom-center" aria-live="polite" role="alert"><div class="toast toast-'.$result_type.'" style=""><div class="toast-message">'.$result_message.'</div></div></div>';
		}
		?>   
		<div class="panel">
			<div class="panel-body container-fluid">
				<div class="row row-lg">
					<div class="col-md-6">
						<!-- Example Basic Form (Form grid) -->
						<div class="example-wrap">

							<div class="example">
								<form autocomplete="off" action="#" method="post" name="frm1" id="editarcliente" novalidate="novalidate" class="fv-form fv-form-bootstrap4"><button type="submit" class="fv-hidden-submit" style="display: none; width: 0px; height: 0px;"></button>
									<div class="row">
										<div class="form-group col-md-12">
											<label class="form-control-label" for="inputBasicFirstName">Duração do Teste</label>
											<div class="radio-custom radio-primary">
												<input type="radio" name="duration" value="1" checked="">
												<label for="inputRadiosUnchecked"><?php echo $test_time; ?> Hora(s)</label>
											</div>                  
										</div>  
										
											<div class="form-group col-md-6">
											<label class="form-control-label" for="inputBasicFirstName">MAC</label>
											<input type="text" class="form-control" required="required" placeholder="MAC" autocomplete="off" value="" name="MAC" data-minlength="11" data-fv-field="MAC">
											<span class="text-help">12 caracteres</span>
											<small class="invalid-feedback" data-fv-validator="notEmpty" data-fv-for="MAC" data-fv-result="NOT_VALIDATED" style="display: none;">Campo MAC não pode ser vazio</small><small class="invalid-feedback" data-fv-validator="stringLength" data-fv-for="MAC" data-fv-result="NOT_VALIDATED" style="display: none;">MAC precisa ter 12 caracteres</small></div>
										
										
										<div class="form-group col-md-6">
											<label class="form-control-label" for="inputBasicFirstName">Login</label>
											<input type="text" class="form-control" required="required" placeholder="Login" autocomplete="off" value="" name="username" data-minlength="6" data-fv-field="username">
											<span class="text-help">Minimo 6 caracteres</span>
											<small class="invalid-feedback" data-fv-validator="notEmpty" data-fv-for="username" data-fv-result="NOT_VALIDATED" style="display: none;">Campo username não pode ser vazio</small><small class="invalid-feedback" data-fv-validator="stringLength" data-fv-for="username" data-fv-result="NOT_VALIDATED" style="display: none;">Usuário precisa ter mais de 6 caracteres</small></div>
											
											
											<div class="form-group col-md-6">
												<label class="form-control-label" for="inputBasicLastName">Senha</label>
												<input type="text" class="form-control" required="required" placeholder="Senha" autocomplete="off" value="" name="password" data-minlength="6" data-fv-field="password">
												<span class="text-help">Minimo 6 caracteres, misturar pelo menos 1 numero ou 1 letra</span>
												<small class="invalid-feedback" data-fv-validator="notEmpty" data-fv-for="password" data-fv-result="NOT_VALIDATED" style="display: none;">Campo Senha não pode ser vazio</small><small class="invalid-feedback" data-fv-validator="stringLength" data-fv-for="password" data-fv-result="NOT_VALIDATED" style="display: none;">Senha precisa ter mais de 6 caracteres</small></div>
												<div class="form-group col-md-6">
													<label class="form-control-label" for="inputBasicLastName">Email</label>         
													<input type="email" class="form-control" id="inputBasicLastName" placeholder="Email, não obrigatório" autocomplete="off" value="" name="email" data-fv-field="email">         
													<small class="invalid-feedback" data-fv-validator="emailAddress" data-fv-for="email" data-fv-result="NOT_VALIDATED" style="display: none;">Please enter a valid email address</small>
												</div>
												<div class="form-group col-md-6">
												</div>
											</div>
											<div class="form-group">
												<label class="form-control-label" for="inputBasicFirstName">Observações</label>
												<textarea class="form-control" placeholder="Adicione informações relevantes" name="reseller_notes"></textarea>
											</div>
											<div class="form-group">
												<label class="form-control-label" for="inputBasicFirstName">Definir Pacotes <span class="text-danger">* selecione apenas os pacotes desejados e orderne da forma desejada</span></label>
												<div class="row">
													<div class="col-md-5 col-xs-5">
														<select name="from[]" id="multiselect" class="form-control" size="10" multiple="multiple" style="overflow:auto">
															<?php 
															$bouquets = getBouquets();
															foreach ($bouquets as $bouquet) {
																if (in_array($bouquet["id"], $allowed_bouquets)) {
																	echo "                                  <option value=\"";
																	echo $bouquet["id"];
																	echo "\">";
																	echo $bouquet["bouquet_name"];
																	echo "</option>\n                                ";
																}
															}
															?>
														</select>
													</div>
													<div class="col-sm-2">
														<button type="button" id="multiselect_rightSelected" class="btn btn-block btn-direction btn-right btn-warning"><i class="icon wb-chevron-right-mini"></i></button>
														<button type="button" id="multiselect_leftSelected" class="btn btn-block btn-direction btn-left btn-warning mt-5"><i class="icon wb-chevron-left-mini"></i></button>
													</div>
													<div class="col-md-5 col-xs-5">
														<select name="bouquet[]" id="multiselect_to" class="form-control" size="10" multiple="multiple" style="overflow:auto">
														</select>               
													</div>
												</div>
											</div>
											<div class="form-group">
												<button type="submit" class="btn btn-success" id="validateButton">Criar teste customizado</button>
											</div>
										</form>
									</div>
								</div>
								<!-- End Example Basic Form (Form grid) -->
							</div>





						</div>
					</div>
				</div>


			</div>
		</div>



	</div>
</div>
</div>
</div>
<!-- End Page -->


<!-- Footer -->
<footer class="site-footer">
	<?php 
	include_once "./incluir/footer.php";
	?>
</footer>
<!-- Core  -->
<script src="temp/global/vendor/babel-external-helpers/babel-external-helpers.js"></script>
<script src="temp/global/vendor/jquery/jquery.js"></script>
<script src="temp/global/vendor/popper-js/umd/popper.min.js"></script>
<script src="temp/global/vendor/bootstrap/bootstrap.js"></script>
<script src="temp/global/vendor/animsition/animsition.js"></script>
<script src="temp/global/vendor/mousewheel/jquery.mousewheel.js"></script>
<script src="temp/global/vendor/asscrollbar/jquery-asScrollbar.js"></script>
<script src="temp/global/vendor/asscrollable/jquery-asScrollable.js"></script>
<script src="temp/global/vendor/ashoverscroll/jquery-asHoverScroll.js"></script>

<!-- Plugins -->
<script src="temp/global/vendor/switchery/switchery.js"></script>
<script src="temp/global/vendor/intro-js/intro.js"></script>
<script src="temp/global/vendor/screenfull/screenfull.js"></script>
<script src="temp/global/vendor/slidepanel/jquery-slidePanel.js"></script>
<script src="temp/global/vendor/moment/moment.min.js"></script>
<script src="temp/global/vendor/footable/footable.min.js"></script>

<!-- Scripts -->
<script src="temp/global/js/Component.js"></script>
<script src="temp/global/js/Plugin.js"></script>
<script src="temp/global/js/Base.js"></script>
<script src="temp/global/js/Config.js"></script>

<script src="temp/assets/js/Section/Menubar.js"></script>
<script src="temp/assets/js/Section/GridMenu.js"></script>
<script src="temp/assets/js/Section/Sidebar.js"></script>
<script src="temp/assets/js/Section/PageAside.js"></script>
<script src="temp/assets/js/Plugin/menu.js"></script>

<script src="temp/global/js/config/colors.js"></script>
<script src="temp/assets/js/config/tour.js"></script>
<script>Config.set('assets', 'temp/assets');</script>

<!-- Page -->
<script src="temp/assets/js/Site.js"></script>
<script src="temp/global/js/Plugin/asscrollable.js"></script>
<script src="temp/global/js/Plugin/slidepanel.js"></script>
<script src="temp/global/js/Plugin/switchery.js"></script>

<script src="temp/assets/examples/js/tables/footable.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/multiselect/2.2.9/js/multiselect.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/multiselect/2.2.9/js/multiselect.min.js"></script>
<script src="temp/global/js/Plugin/toastr.js"></script>
<script src="temp/global/vendor/toastr/toastr.js"></script>
<script type="text/javascript">
	$("#toast-bottomFullWidth").show();
	setTimeout(function () {
		$("#toast-bottomFullWidth").fadeOut();
	}, 6000);
</script>
<script type="text/javascript">
	jQuery(document).ready(function($) {
		$('#multiselect').multiselect({
			sort: false,
			keepOrder: true  
		});
	});
		function  RegisterUser_copy() {
   // console.log("copy1");
  
  var elemento =  document.getElementById("ShowInfo_modal_content");
    var texto = elemento.innerText || elemento.textContent;
   texto = texto.replace('Verifique se as informações abaixo estão corretas:\n\n\n\n', '');
    texto = texto.replace('\n\n\nCopiar Informações', '');
    texto = texto.replace(/\n\n/g, "\n");
    // Substitui <br> por quebras de linha reconhecidas
    texto = texto.replace(/<br\s*[\/]?>/gi, "\n");
  //console.log("copy2");
    // Cria uma textarea e copia o texto para ela
    var textarea = document.createElement('textarea');
    textarea.value = texto;

    // Adiciona a textarea à árvore do DOM para que o método execCommand funcione
    document.body.appendChild(textarea);

    // Seleciona o texto na textarea
    textarea.select();

    // Executa o comando de cópia
    document.execCommand('copy');
  //    console.log("copy3");

    // Remove a textarea da árvore do DOM
    document.body.removeChild(textarea);
    copiarTextoPersonalizado();
}

function copiarTextoPersonalizado() {
 //   console.log("copy1");

    var elemento = document.getElementById("ShowInfo_modal_content");
    var texto = elemento.innerText || elemento.textContent;
    
    // Remove o cabeçalho e o rodapé específicos
    texto = texto.replace('Verifique se as informações abaixo estão corretas:\n\n\n\n', '');
    texto = texto.replace('\n\n\nCopiar Informações', '');
    
    // Remove quebras de linha extras
    texto = texto.replace(/\n\n/g, "\n");

    // Substitui <br> por quebras de linha reconhecidas
    texto = texto.replace(/<br\s*[\/]?>/gi, "\n");

   // console.log("copy2");

    // Copia o texto para a área de transferência
    navigator.clipboard.writeText(texto)
        .then(function() {
            console.log("Texto copiado com sucesso!");
        })
        .catch(function(err) {
           // console.error("Erro ao copiar o texto: ", err);
        });
}
</script>
</body>
</html>
