<?php
session_start();
include_once "./system/functions.php";
isLogged();
$logged_user = getLoggedUser();
$server_name = getServerProperty("server_name");
$allowed_bouquets = json_decode(getServerProperty("allowed_bouquets"), true);
$fast_packages = json_decode(getServerProperty("fast_packages"), true);
$logotipo = getUserProperty($logged_user['id'], "logotipo");
$titulo = getUserProperty($logged_user['id'], "nomePainel");
$copyright = getUserProperty($logged_user['id'], "copyright");
$fixed_informations3 = getServerProperty('fixed_informations3');

// Configurações de erros
ini_set("display_errors", 0);
ini_set("display_startup_errors", 0);
error_reporting(E_ALL);

// Conexão com SQLite
$db = new SQLite3("./api/.bansdb.db");
$db->exec("CREATE TABLE IF NOT EXISTS ibo(
    id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
    mac_address VARCHAR(100),
    key VARCHAR(100),
    username VARCHAR(100),
    password VARCHAR(100),
    expire_date VARCHAR(100),
    dns VARCHAR(100),
    epg_url VARCHAR(100),
    title VARCHAR(100),
    url VARCHAR(100),
    type VARCHAR(100)
)");

// Processar edição
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'edit') {
    $id = intval($_POST['id']);
    $mac_address = str_replace(":", "", strtoupper($_POST['mac_address']));
    $expire_date = date("Y-m-d", strtotime($_POST['expire_date']));
    $url = ($_POST["type"] == "0") 
        ? $_POST["dns"] . "/get.php?username=" . $_POST["username"] . "&password=" . $_POST["password"] . "&type=m3u_plus&output=ts" 
        : $_POST["url"];

    $db->exec("UPDATE ibo SET
        mac_address = '$mac_address',
        key = '" . $_POST['key'] . "',
        username = '" . $_POST['username'] . "',
        password = '" . $_POST['password'] . "',
        expire_date = '$expire_date',
        dns = '" . $_POST['dns'] . "',
        epg_url = '" . $_POST['epg_url'] . "',
        title = '" . $_POST['title'] . "',
        url = '$url',
        type = '" . $_POST['type'] . "'
        WHERE id = $id
    ");

    $_SESSION['message'] = "Registro atualizado com sucesso!";
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Carregar dados para edição
if (isset($_GET['action']) && $_GET['action'] === 'edit' && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $record = $db->querySingle("SELECT * FROM ibo WHERE id = $id", true);
}
// Adicionar registro
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $mac_address = str_replace(":", "", strtoupper($_POST["mac_address"]));
    $expire_date = date("Y-m-d", strtotime($_POST["expire_date"]));
    $url = ($_POST["type"] == "0") 
        ? $_POST["dns"] . "/get.php?username=" . $_POST["username"] . "&password=" . $_POST["password"] . "&type=m3u_plus&output=ts" 
        : $_POST["url"];
    $db->exec("INSERT INTO ibo(mac_address, key, username, password, expire_date, dns, epg_url, title, url, type) VALUES(
        '" . $mac_address . "',
        '" . $_POST["key"] . "',
        '" . $_POST["username"] . "',
        '" . $_POST["password"] . "',
        '" . $expire_date . "',
        '" . $_POST["dns"] . "',
        '" . $_POST["epg_url"] . "',
        '" . $_POST["title"] . "',
        '" . $url . "',
        '" . $_POST["type"] . "'
    )");
    $_SESSION['message'] = "Registro adicionado com sucesso!";
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Excluir registro
if (isset($_GET['action']) && $_GET['action'] === 'delete' && isset($_GET['id'])) {
    $db->exec("DELETE FROM ibo WHERE id = " . intval($_GET['id']));
    $_SESSION['message'] = "Registro excluído com sucesso!";
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Obter registros
$result = $db->query("SELECT * FROM ibo");
?>

<!DOCTYPE html>
<html class="no-js css-menubar" lang="en">
<head>
    <!-- Cabeçalhos -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <title>Gerenciar Registros</title>
    <link rel="stylesheet" href="temp/global/css/bootstrap.min.css">
    <link rel="stylesheet" href="temp/assets/css/site.min.css">
</head>
<body>

<!-- Página -->
<div class="page">
    <div class="page-header">
        <h1 class="page-title">Gerenciamento de Registros</h1>
    </div>
    <div class="page-content">
<?php if (isset($record)): ?>
<div class="panel">
    <div class="panel-body">
        <h3>Editar Registro</h3>
        <form method="post" action="">
            <input type="hidden" name="action" value="edit">
            <input type="hidden" name="id" value="<?= $record['id'] ?>">

            <div class="form-group">
                <label for="mac_address">MAC Address</label>
                <input type="text" name="mac_address" class="form-control" value="<?= $record['mac_address'] ?>" required>
            </div>

            <div class="form-group">
                <label for="key">Key</label>
                <input type="text" name="key" class="form-control" value="<?= $record['key'] ?>">
            </div>

            <div class="form-group">
                <label for="username">Usuário</label>
                <input type="text" name="username" class="form-control" value="<?= $record['username'] ?>" required>
            </div>

            <div class="form-group">
                <label for="password">Senha</label>
                <input type="text" name="password" class="form-control" value="<?= $record['password'] ?>" required>
            </div>

            <div class="form-group">
                <label for="expire_date">Data de Expiração</label>
                <input type="date" name="expire_date" class="form-control" value="<?= $record['expire_date'] ?>" required>
            </div>

            <div class="form-group">
                <label for="dns">DNS</label>
                <input type="text" name="dns" class="form-control" value="<?= $record['dns'] ?>">
            </div>

            <div class="form-group">
                <label for="epg_url">EPG URL</label>
                <input type="text" name="epg_url" class="form-control" value="<?= $record['epg_url'] ?>">
            </div>

            <div class="form-group">
                <label for="title">Título</label>
                <input type="text" name="title" class="form-control" value="<?= $record['title'] ?>">
            </div>

            <div class="form-group">
                <label for="type">Tipo</label>
                <select name="type" class="form-control">
                    <option value="0" <?= $record['type'] == "0" ? "selected" : "" ?>>Tipo 0</option>
                    <option value="1" <?= $record['type'] == "1" ? "selected" : "" ?>>Tipo 1</option>
                </select>
            </div>

            <div class="form-group">
                <label for="url">URL</label>
                <input type="text" name="url" class="form-control" value="<?= $record['url'] ?>">
            </div>

            <button type="submit" class="btn btn-primary">Salvar Alterações</button>
            <a href="<?= $_SERVER['PHP_SELF'] ?>" class="btn btn-secondary">Cancelar</a>
        </form>
    </div>
</div>
<?php endif; ?>

        <!-- Formulário de Adição -->
        <div class="panel">
            <div class="panel-body">
                <h4>Adicionar Registro</h4>
                <form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                    <input type="hidden" name="action" value="add">
                    <div class="form-group">
                        <label>MAC Address:</label>
                        <input type="text" name="mac_address" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Key:</label>
                        <input type="text" name="key" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Username:</label>
                        <input type="text" name="username" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Password:</label>
                        <input type="text" name="password" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>DNS:</label>
                        <input type="text" name="dns" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>URL:</label>
                        <input type="text" name="url" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Tipo:</label>
                        <select name="type" class="form-control">
                            <option value="0">M3U</option>
                            <option value="1">Outro</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Data de Expiração:</label>
                        <input type="date" name="expire_date" class="form-control" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Adicionar</button>
                </form>
            </div>
        </div>
        <!-- Lista de Registros -->
        <div class="panel">
            <div class="panel-body">
                <h4>Registros</h4>
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>MAC Address</th>
                            <th>Usuário</th>
                            <th>Senha</th>
                            <th>Data de Expiração</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $result->fetchArray()): ?>
                        <tr>
                            <td><?php echo $row['id']; ?></td>
                            <td><?php echo $row['mac_address']; ?></td>
                            <td><?php echo $row['username']; ?></td>
                            <td><?php echo $row['password']; ?></td>
                            <td><?php echo $row['expire_date']; ?></td>
                            <td>
<a href="?action=edit&id=<?= $row['id'] ?>" class="btn btn-danger btn-sm">Editar</a>
                                <a href="?action=delete&id=<?php echo $row['id']; ?>" class="btn btn-danger btn-sm">Excluir</a>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<footer class="site-footer">
    <?php include_once "./incluir/footer.php"; ?>
</footer>

<!-- Scripts -->
<script src="temp/global/vendor/jquery/jquery.js"></script>
<script src="temp/global/vendor/bootstrap/bootstrap.js"></script>
</body>
</html>