<?php
if (!isset($_GET["reseller_id"])) {
	exit;
}
include_once "./system/functions.php";
isLogged();
$logged_user = getLoggedUser();
if (getServerProperty("manutencaoPainel", 0)) {
	header("Location: ./sair.php");
	exit();
}
if (!isAdmin($logged_user) && !isUltra($logged_user) && !isMaster($logged_user) && !isReseller($logged_user)) {
	header("Location: ./index.php");
	exit;
}
$logotipo = getUserProperty($logged_user['id'], "logotipo");
$titulo = getUserProperty($logged_user['id'], "nomePainel");
$copyright = getUserProperty($logged_user['id'], "copyright");
$server_name = getServerProperty("server_name");
$fast_packages = json_decode(getServerProperty("fast_packages"), true);
$reseller_id = intval($_GET["reseller_id"]);
$reseller = getUserByID($reseller_id);
if (!$reseller) {
	exit;
}
if (!masterHasPermission($logged_user["id"], $reseller["id"])) {
	exit;
}
$whatsapp = getUserProperty($reseller["id"], "whatsapp");
$telegram = getUserProperty($reseller["id"], "telegram");
$owner_id = $reseller["owner_id"];
$owner = NULL;
if ($owner_id) {
	$owner = getUserByID($owner_id);
}
if (isset($_POST["username"]) && isset($_POST["password"]) && isset($_POST["email"]) && isset($_POST["member_group"]) && isset($_POST["notes"]) && isset($_POST["whatsapp"]) && isset($_POST["telegram"])) {
	$username = $_POST["username"];
	$password = $_POST["password"];
	$email = $_POST["email"];
	$member_group = $_POST["member_group"];
	$notes = $_POST["notes"];
	$whatsapp = $_POST["whatsapp"];
	$telegram = $_POST["telegram"];
	if (strlen($username) < 6 || 255 < strlen($username)) {
		header("location: ?reseller_id=" . $reseller_id . "&result=invalid_username");
		exit;
	}
	if (!empty($password) && (strlen($password) < 6 || 255 < strlen($password))) {
		header("location: ?reseller_id=" . $reseller_id . "&result=invalid_password");
		exit;
	}
	if (strlen($email) < 6 || 255 < strlen($email)) {
		header("location: ?reseller_id=" . $reseller_id . "&result=invalid_email");
		exit;
	}
	$group_settings = json_decode(getServerProperty("group_settings"), true);
	$logged_user_group = array_search($logged_user["member_group_id"], $group_settings);
	if ($logged_user_group == "admin" || $logged_user_group == "ultra" && ($member_group == "master" || $member_group == "reseller") || $logged_user_group == "master" && $member_group == "reseller") {
		$group_id = isset($group_settings[$member_group]) ? $group_settings[$member_group] : false;
		if (!$group_id) {
			header("location: ?reseller_id=" . $reseller_id . "&result=error");
			exit;
		}
		if (500 < strlen($notes)) {
			header("location: ?reseller_id=" . $reseller_id . "&result=invalid_notes");
			exit;
		}
		if (updateUser($reseller_id, $username, $password, $email, $group_id, $notes)) {
			deleteUserProperty($reseller_id, "whatsapp");
			deleteUserProperty($reseller_id, "telegram");
			$result1 = addUserProperty($reseller_id, "whatsapp", $whatsapp);
			$result2 = addUserProperty($reseller_id, "telegram", $telegram);
			if ($result1 && $result2) {
				header("location: ?reseller_id=" . $reseller_id . "&result=success");
				exit;
			}
		}
	}
	header("location: ?reseller_id=" . $reseller_id . "&result=error");
	exit;
}
?>
<!DOCTYPE html>
<html class="no-js css-menubar" lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
	<meta name="description" content="bootstrap admin template">
	<meta name="author" content="">

	<title>GERENCIADOR</title>

	<link rel="apple-touch-icon" href="temp/assets/images/apple-touch-icon.png">
	<link rel="shortcut icon" href="temp/assets/images/favicon.ico">

	<!-- Stylesheets -->
	<link rel="stylesheet" href="temp/global/css/bootstrap.min.css">
	<link rel="stylesheet" href="temp/global/css/bootstrap-extend.min.css">
	<link rel="stylesheet" href="temp/assets/css/site.min.css">

	<!-- Plugins -->
	<link rel="stylesheet" href="temp/global/vendor/animsition/animsition.css">
	<link rel="stylesheet" href="temp/global/vendor/asscrollable/asScrollable.css">
	<link rel="stylesheet" href="temp/global/vendor/switchery/switchery.css">
	<link rel="stylesheet" href="temp/global/vendor/intro-js/introjs.css">
	<link rel="stylesheet" href="temp/global/vendor/slidepanel/slidePanel.css">
	<link rel="stylesheet" href="temp/global/vendor/flag-icon-css/flag-icon.css">
	<link rel="stylesheet" href="temp/global/vendor/footable/footable.core.css">
	<link rel="stylesheet" href="temp/assets/examples/css/tables/footable.css">


	<!-- Fonts -->
	<link rel="stylesheet" href="temp/global/fonts/font-awesome/font-awesome.css">
	<link rel="stylesheet" href="temp/global/fonts/web-icons/web-icons.min.css">
	<link rel="stylesheet" href="temp/global/fonts/brand-icons/brand-icons.min.css">
	<link rel='stylesheet' href='http://fonts.googleapis.com/css?family=Roboto:300,400,500,300italic'>



	<!-- Scripts -->
	<script src="temp/global/vendor/breakpoints/breakpoints.js"></script>
	<script>
		Breakpoints();
	</script>
</head>
<?php 
include_once "./incluir/menu_lateral.php";
?>

<!-- Page -->
<div class="page">
	<div class="page-header">
		<h1 class="page-title">Editar revendedor</h1>
		<ol class="breadcrumb">
			<li class="breadcrumb-item"><a href="/">Painel</a></li>

			<li class="breadcrumb-item active">Editar revendedor</li>
		</ol>
		<div class="page-header-actions">

			<button type="button" class="btn btn-sm btn-icon btn-default btn-outline btn-round" data-toggle="tooltip" data-original-title="Refresh" id="goBack">
				<i class="icon wb-refresh" aria-hidden="true"></i>
			</button>

		</div>
	</div>

	<div class="page-content">
		<?php 
		if (isset($_GET["result"])) {
			$result = $_GET["result"];
			$result_message = "Aconteceu um problema, tente novamente mais tarde!";
			$result_type = "warning";
			switch ($result) {
				case "success":
				$result_message = "As alterações foram salvas com sucesso.";
				$result_type = "success";
				break;
				case "invalid_username":
				$result_message = "O nome de usuário escolhido é invalido!, deve ter no mínimo 6 caracteres.";
				break;
				case "invalid_password":
				$result_message = "A senha escolhida é invalida!, deve ter no mínimo 6 caracteres.";
				break;
				case "invalid_email":
				$result_message = "O e-mail escolhido é invalido!";
				break;
				case "invalid_notes":
				$result_message = "A observação escolhida é invalida!, deve ter no máximo 500 caracteres.";
				break;
			}
			echo "            <div class=\"alert alert-";
			echo $result_type;
			echo " alert-dismissible\">\n              <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">×</button>\n              <i class=\"icon fa fa-check\"></i>\n              ";
			echo $result_message;
			echo "            </div>\n          ";
		}
		?>   
		<div class="panel">
			<div class="panel-body container-fluid">
				<div class="row row-lg">
					<div class="col-md-6">
						<!-- Example Basic Form (Form grid) -->
						<div class="example-wrap">
							<p>Registrado em: <i><?php echo date("d/m/Y H:i", $reseller["date_registered"]); ?></i></p>
							<p>Revendedor tem: <i><?php echo $reseller["credits"]; ?> crédito(s)</i></p>

							<div class="example">
								<form autocomplete="off" action="#" method="post" name="frm1">                                
									<input type="hidden" name="action" value="create_custom_test">                                
									<div class="row"> 

										<div class="form-group col-md-6">                                        
											<label class="form-control-label">Login</label>                                        
											<div class="input-group">                                          
												<span class="input-group-addon"><i class="fa fa-user"></i></span>                                          <input type="text" class="form-control" required="" placeholder="Login" autocomplete="off" name="username" data-minlength="6" minlength="6" maxlength="120" value="<?php echo $reseller["username"]; ?>">
											</div>
											<span class="text-help">Minimo 6 caracteres</span>                                   
										</div>   

										<div class="form-group col-md-6">                                        
											<label class="form-control-label">Senha</label>                                        
											<div class="input-group">                                          
												<span class="input-group-addon"><i class="fa fa-key"></i></span>                                          
												<input type="text" class="form-control" placeholder="Senha" autocomplete="off" name="password" data-minlength="6" minlength="6" maxlength="120" value="">                                        
											</div>                                        
											<span class="text-help">Minimo 6 caracteres (Mude apenas se desejar alterar sua Senha!)</span>                                    
										</div>    

										<div class="form-group col-md-6">                                      
											<label class="form-control-label">Grupo do Revendedor</label>                                      
											<div class="input-group">                                        
												<span class="input-group-addon"><i class="fa fa-group"></i></span>                                        
												<select id="member_group" name="member_group" class="form-control">
													<?php  
													$group_settings = json_decode(getServerProperty("group_settings"), true);
													$ultra_group = getGroupByID($group_settings["ultra"]);
													$master_group = getGroupByID($group_settings["master"]);
													$reseller_group = getGroupByID($group_settings["reseller"]);
													if (isAdmin($logged_user)) {
														$selected = isUltra($reseller) ? "selected" : "";
														echo "<option value='ultra' " . $selected . " >" . $ultra_group["group_name"] . "</option>";
														$selected = isMaster($reseller) ? "selected" : "";
														echo "<option value='master' " . $selected . " >" . $master_group["group_name"] . "</option>";
														$selected = isReseller($reseller) ? "selected" : "";
														echo "<option value='reseller' " . $selected . " >" . $reseller_group["group_name"] . "</option>";
													} else {
														if (isUltra($logged_user)) {
															if (!$owner || $owner && (isAdmin($owner) || isUltra($owner))) {
																$selected = isMaster($reseller) ? "selected" : "";
																echo "<option value='master' " . $selected . " >" . $master_group["group_name"] . "</option>";
															}
															$selected = isReseller($reseller) ? "selected" : "";
															echo "<option value='reseller' " . $selected . " >" . $reseller_group["group_name"] . "</option>";
														} else {
															if (isMaster($logged_user)) {
																$selected = isReseller($reseller) ? "selected" : "";
																echo "<option value='reseller' " . $selected . " >" . $reseller_group["group_name"] . "</option>";
															}
														}
													}
													?>
												</select>                                      
											</div>                                    
										</div>   

										<div class="form-group col-md-6">                                        
											<label class="form-control-label">E-mail</label>                                        
											<div class="input-group">                                          
												<span class="input-group-addon"><i class="fa fa-envelope"></i></span>                                     
												<input type="text" class="form-control" required="" placeholder="E-mail" autocomplete="off" name="email" maxlength="255" value="<?php echo $reseller["email"]; ?>">
											</div>                                    
										</div>  

										<div class="form-group col-md-6">                                      
											<label class="form-control-label">Numero do Whatsapp</label>                                      
											<div class="input-group">                                        
												<span class="input-group-addon"><i class="fa fa-phone"></i></span>                   
												<input type="text" class="form-control" placeholder="Whatsapp" autocomplete="off" name="whatsapp" value="<?php echo $whatsapp; ?>">
											</div>                                    
										</div>   

										<div class="form-group col-md-6">                                      
											<label class="form-control-label">Numero do Telegram</label>                                      
											<div class="input-group">                                        
												<span class="input-group-addon"><i class="fa fa-mobile"></i></span>                           
												<input type="text" class="form-control" placeholder="Telegram" autocomplete="off" name="telegram" value="<?php echo $telegram; ?>">
											</div>                                    
										</div>                                
									</div> 

									<div class="form-group">                                    
										<label class="form-control-label">Observações</label>                                    
										<textarea class="form-control" placeholder="Adicione informações relevantes" name="notes" maxlength="500"><?php echo $reseller["notes"]; ?>
									</textarea>                                
								</div>   

								<div class="form-group">                                    
									<button type="submit" class="btn btn-success">Salvar</button>                                
								</div> 

							</form>
						</div>
					</div>
					<!-- End Example Basic Form (Form grid) -->
				</div>





			</div>
		</div>
	</div>


</div>
</div>



</div>
</div>
</div>
</div>
<!-- End Page -->


<!-- Footer -->
<footer class="site-footer">
	<?php 
	include_once "./incluir/footer.php";
	?>
</footer>
<!-- Core  -->
<script src="temp/global/vendor/babel-external-helpers/babel-external-helpers.js"></script>
<script src="temp/global/vendor/jquery/jquery.js"></script>
<script src="temp/global/vendor/popper-js/umd/popper.min.js"></script>
<script src="temp/global/vendor/bootstrap/bootstrap.js"></script>
<script src="temp/global/vendor/animsition/animsition.js"></script>
<script src="temp/global/vendor/mousewheel/jquery.mousewheel.js"></script>
<script src="temp/global/vendor/asscrollbar/jquery-asScrollbar.js"></script>
<script src="temp/global/vendor/asscrollable/jquery-asScrollable.js"></script>
<script src="temp/global/vendor/ashoverscroll/jquery-asHoverScroll.js"></script>

<!-- Plugins -->
<script src="temp/global/vendor/switchery/switchery.js"></script>
<script src="temp/global/vendor/intro-js/intro.js"></script>
<script src="temp/global/vendor/screenfull/screenfull.js"></script>
<script src="temp/global/vendor/slidepanel/jquery-slidePanel.js"></script>
<script src="temp/global/vendor/moment/moment.min.js"></script>
<script src="temp/global/vendor/footable/footable.min.js"></script>

<!-- Scripts -->
<script src="temp/global/js/Component.js"></script>
<script src="temp/global/js/Plugin.js"></script>
<script src="temp/global/js/Base.js"></script>
<script src="temp/global/js/Config.js"></script>

<script src="temp/assets/js/Section/Menubar.js"></script>
<script src="temp/assets/js/Section/GridMenu.js"></script>
<script src="temp/assets/js/Section/Sidebar.js"></script>
<script src="temp/assets/js/Section/PageAside.js"></script>
<script src="temp/assets/js/Plugin/menu.js"></script>

<script src="temp/global/js/config/colors.js"></script>
<script src="temp/assets/js/config/tour.js"></script>
<script>Config.set('assets', 'temp/assets');</script>

<!-- Page -->
<script src="temp/assets/js/Site.js"></script>
<script src="temp/global/js/Plugin/asscrollable.js"></script>
<script src="temp/global/js/Plugin/slidepanel.js"></script>
<script src="temp/global/js/Plugin/switchery.js"></script>

<script src="temp/assets/examples/js/tables/footable.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/multiselect/2.2.9/js/multiselect.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/multiselect/2.2.9/js/multiselect.min.js"></script>
<script type="text/javascript">
	jQuery(document).ready(function($) {
		$('#multiselect').multiselect();
	});
</script>
</body>
</html>
