<?php

include_once "./system/functions.php";
isLogged();
$logged_user = getLoggedUser();
if (!isAdmin($logged_user) && getServerProperty("manutencaoPainel", 0)) {
	header("Location: ./sair.php");
	exit();
}
if (!isAdmin($logged_user)) {
	header("Location: ./index.php");
	exit;
}
$server_name = getServerProperty("server_name");

$logotipo = getUserProperty($logged_user['id'], "logotipo");
$titulo = getUserProperty($logged_user['id'], "nomePainel");
$copyright = getUserProperty($logged_user['id'], "copyright");
$client_id = intval($_GET["client_id"]);
$server_dns = getServerDNS();

if (isset($_GET["stream"])) {
	$streamID = $_GET["stream"];
	
	$info_stream = pegarInfoStreamID($streamID);
	$epg_geral = pegarEpg();

	// $someArray = json_decode($epg_geral[0]['data'], true);

	

	$nome_stream = $info_stream[0]['stream_display_name'];
	$link_stream = limpar($info_stream[0]['stream_source']);
	$logo_stream = $info_stream[0]['stream_icon'];
	$epg_id_stream = $info_stream[0]['epg_id'];
	$channel_id_stream = $info_stream[0]['channel_id'];

	if (pegarEpgChannelID()) {
		$get_epgs = pegarEpgChannelID();
	}


	   //echo '<pre>'; var_dump($link_stream); die(); echo '</pre>';
}

if (isset($_POST['nomecanal']) && isset($_POST['urlcanal']) && isset($_POST['logocanal']) && isset($_POST['id'])) {
	
	$nome_canal = $_POST['nomecanal'];
	$link_canal = '["'.$_POST['urlcanal'].'"]';
	$logo_canal = $_POST['logocanal'];
	$id_do_canal = $_POST['id'];

	// echo '<pre>'; var_dump($nome_canal, $link_canal, $logo_canal, $epg_canal ); die(); echo '</pre>';

	if (editarStreamId($id_do_canal, $nome_canal, $link_canal, $logo_canal)) {
		header("Location: ./editar-stream.php?stream=".$id_do_canal."&result=stream_edit_sucess");
	}else{
		header("Location: ./editar-stream.php?stream=".$id_do_canal."&result=stream_edit_falied");
	}




}

?>
<!DOCTYPE html>
<html class="no-js css-menubar" lang="en">
<head>

	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
	<meta name="description" content="bootstrap admin template">
	<meta name="author" content="">

	<title>GERENCIADOR</title>

	<link rel="apple-touch-icon" href="temp/assets/images/apple-touch-icon.png">
	<link rel="shortcut icon" href="temp/assets/images/favicon.ico">

	<!-- Stylesheets -->
	<link rel="stylesheet" href="temp/global/css/bootstrap.min.css">
	<link rel="stylesheet" href="temp/global/css/bootstrap-extend.min.css">
	<link rel="stylesheet" href="temp/assets/css/site.min.css">
	<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet"/>
	<link rel="stylesheet" href="temp/global/vendor/toastr/toastr.css">
	<link rel="stylesheet" href="temp/assets/examples/css/advanced/toastr.css">
	<link rel="stylesheet" href="temp/global/vendor/select2/select2.css">
	<link rel="stylesheet" href="temp/global/vendor/bootstrap-select/bootstrap-select.css">
	<link rel="stylesheet" href="temp/global/vendor/multi-select/multi-select.css">

	<!-- Plugins -->
	<link rel="stylesheet" href="temp/global/vendor/animsition/animsition.css">
	<link rel="stylesheet" href="temp/global/vendor/asscrollable/asScrollable.css">
	<link rel="stylesheet" href="temp/global/vendor/switchery/switchery.css">
	<link rel="stylesheet" href="temp/global/vendor/intro-js/introjs.css">
	<link rel="stylesheet" href="temp/global/vendor/slidepanel/slidePanel.css">
	<link rel="stylesheet" href="temp/global/vendor/flag-icon-css/flag-icon.css">
	<link rel="stylesheet" href="temp/global/vendor/footable/footable.core.css">
	<link rel="stylesheet" href="temp/assets/examples/css/tables/footable.css">


	<!-- Fonts -->
	<link rel="stylesheet" href="temp/global/fonts/font-awesome/font-awesome.css">
	<link rel="stylesheet" href="temp/global/fonts/web-icons/web-icons.min.css">
	<link rel="stylesheet" href="temp/global/fonts/brand-icons/brand-icons.min.css">
	<link rel='stylesheet' href='http://fonts.googleapis.com/css?family=Roboto:300,400,500,300italic'>



	<!-- Scripts -->
	<script src="temp/global/vendor/breakpoints/breakpoints.js"></script>
	<script>
		Breakpoints();
	</script>
</head>
<?php 
include_once "./incluir/menu_lateral.php";
?>


<!-- Page -->
<div class="page">
	<div class="page-header">
		<h1 class="page-title">Editar stream</h1>
		<ol class="breadcrumb">
			<li class="breadcrumb-item"><a href="/">Painel</a></li>

			<li class="breadcrumb-item active">Editar stream</li>
		</ol>
		<div class="page-header-actions">

			<button type="button" class="btn btn-sm btn-icon btn-default btn-outline btn-round" data-toggle="tooltip" data-original-title="Refresh" id="goBack">
				<i class="icon wb-refresh" aria-hidden="true"></i>
			</button>

		</div>
	</div>

	<div class="page-content">
		<?php 
		if (isset($_GET["result"])) {
			$result = $_GET["result"];
			$result_message = "Aconteceu um problema, tente novamente mais tarde!";
			$result_type = "warning";
			switch ($result) {
				case 'stream_edit_sucess':
				$result_message = "Stream editado com sucesso";
				$result_type = "success";
				break;
				case 'stream_edit_falied':
				$result_message = "Erro ao editar stream";
				$result_type = "danger";
				break;
			}
			echo "<div id='toast-bottomFullWidth' class='toast-bottom-full-width' aria-live='polite' role='alert'>
			<div class='toast toast-$result_type' style=''>
			<div class='toast-message'>$result_message</div>
			</div>
			</div>";
		}
		?>   
		<div class="panel">
			<div class="panel-body container-fluid">
				<div class="row row-lg">
					<div class="col-md-12">
						<!-- Example Basic Form (Form grid) -->
						<div class="example-wrap">
							<div class="pr-20">
								<a class="avatar" href="javascript:void(0)">
									<img class="img-fluid" src="<?php echo $logo_stream; ?>">
								</a>
							</div>
							<div class="media-body"><br>
								<h5 class="mt-0 mb-5"><button type="button" class="btn bg-purple-600 white btn-round btn-sm">
									<i class="icon fa-youtube-play" aria-hidden="true"></i><?php echo $nome_stream; ?>
								</button></h5>
							</div>
							<div class="example">
								<form method="post"  action="editar-stream.php"  id="editarcliente" class="fv-form fv-form-bootstrap4">
									<input type="hidden" name="id" value="<?php echo $streamID; ?>">
									<div class="row">
										<div class="form-group col-md-6">
											<label class="form-control-label" for="inputBasicFirstName">Nome do canal</label>
											<input type="text" class="form-control" id="inputBasicFirstName" data-fv-field="nomeDoCanal" placeholder="Ex: Globo HD" autocomplete="off" value="<?php echo $nome_stream; ?>" name="nomecanal">
											<span class="text-help">Editar nome do stream</span>
										</div>
										<div class="form-group col-md-6">
											<label class="form-control-label" for="inputBasicLastName">Link do canal</label>
											<input type="text" class="form-control" id="inputBasicLastName" data-fv-field="password" placeholder="Ex: http://DNS:PORTA/get.php? .m3u8" autocomplete="off" value="<?php echo $link_stream; ?>" name="urlcanal">
											<span class="text-help">Editar url do stream</span>
										</div>
										<div class="form-group col-md-6">
											<label class="form-control-label" for="inputBasicLastName">Link logotipo do canal</label>
											<input type="text" class="form-control" id="inputBasicLastName" data-fv-field="password" placeholder="Ex: http://DNS:PORTA/get.php? .png .jpg" autocomplete="off" value="<?php echo $logo_stream; ?>" name="logocanal">
											<span class="text-help">Editar logo do stream</span>
										</div>
										<div class="form-group col-md-6">
											
											<label class="form-control-label" for="inputBasicFirstName">Selecione o EPG para o canal</label><br>


											<select data-plugin="selectpicker" data-style="btn-outline bg-purple-600 text-white">
												<option value=""># Selecionar epg</option>
												<?php  
												foreach ($epg_geral as $key => $value) {
													$epg_geral_ID = $value['id'];
													$epg_geral_NOME = $value['epg_name'];
													?>
													<option value=""><?php echo $epg_geral_NOME; ?></option>
												<?php } ?>
											</select>


											<select data-plugin="selectpicker" data-style="btn-outline bg-purple-600 text-white">
												<option value=""># Selecionar epg</option>
												<?php  
												foreach ($get_epgs as $key => $value) {
													$nome_do_epg = $value['channel_id'];?>
													<option value="<?php echo $nome_do_epg; ?>"><?php echo $nome_do_epg; ?></option>
												<?php }  ?>
											</select>


											<span class="text-help">Selecione o EPG do stream</span>
										
									</div>
								</div>
								<!-- fecha aqui -->
								<div class="form-group">
									<button type="submit" class="btn bg-purple-600 text-white" id="validateButton">Editar stream</button>
									<input type="button" class="btn btn-danger" value="Voltar" onClick="history.go(-1)">
								</div>
							</div>
						</div>
					</form>
				</div>
				<!-- End Example Basic Form (Form grid) -->
			</div>
		</div>
	</div>
</div>



</div>
</div>
</div>
</div>
<!-- End Page -->


<!-- Footer -->
<footer class="site-footer">
	<?php 
	include_once "./incluir/footer.php";
	?>
</footer>
<!-- Core  -->
<script src="temp/global/vendor/babel-external-helpers/babel-external-helpers.js"></script>
<script src="temp/global/vendor/jquery/jquery.js"></script>
<script src="temp/global/vendor/popper-js/umd/popper.min.js"></script>
<script src="temp/global/vendor/bootstrap/bootstrap.js"></script>
<script src="temp/global/vendor/animsition/animsition.js"></script>
<script src="temp/global/vendor/mousewheel/jquery.mousewheel.js"></script>
<script src="temp/global/vendor/asscrollbar/jquery-asScrollbar.js"></script>
<script src="temp/global/vendor/asscrollable/jquery-asScrollable.js"></script>
<script src="temp/global/vendor/ashoverscroll/jquery-asHoverScroll.js"></script>

<!-- Plugins -->
<script src="temp/global/vendor/switchery/switchery.js"></script>
<script src="temp/global/vendor/intro-js/intro.js"></script>
<script src="temp/global/vendor/screenfull/screenfull.js"></script>
<script src="temp/global/vendor/slidepanel/jquery-slidePanel.js"></script>
<script src="temp/global/vendor/moment/moment.min.js"></script>
<script src="temp/global/vendor/footable/footable.min.js"></script>

<!-- Scripts -->
<script src="temp/global/js/Component.js"></script>
<script src="temp/global/js/Plugin.js"></script>
<script src="temp/global/js/Base.js"></script>
<script src="temp/global/js/Config.js"></script>

<script src="temp/assets/js/Section/Menubar.js"></script>
<script src="temp/assets/js/Section/GridMenu.js"></script>
<script src="temp/assets/js/Section/Sidebar.js"></script>
<script src="temp/assets/js/Section/PageAside.js"></script>
<script src="temp/assets/js/Plugin/menu.js"></script>

<script src="temp/global/js/config/colors.js"></script>
<script src="temp/assets/js/config/tour.js"></script>
<script>Config.set('assets', 'temp/assets');</script>
<script src="temp/global/vendor/select2/select2.full.min.js"></script>
<script src="temp/global/vendor/bootstrap-select/bootstrap-select.js"></script>
<script src="temp/global/vendor/multi-select/jquery.multi-select.js"></script>
<script src="temp/global/js/Plugin/select2.js"></script>
<script src="temp/global/js/Plugin/bootstrap-select.js"></script>
<script src="temp/global/js/Plugin/multi-select.js"></script>

<!-- Page -->
<script src="temp/assets/js/Site.js"></script>
<script src="temp/global/js/Plugin/asscrollable.js"></script>
<script src="temp/global/js/Plugin/slidepanel.js"></script>
<script src="temp/global/js/Plugin/switchery.js"></script>

<script src="temp/assets/examples/js/tables/footable.js"></script>
<script src="temp/assets/js/clipboard.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/multiselect/2.2.9/js/multiselect.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/multiselect/2.2.9/js/multiselect.min.js"></script>
<script src="temp/global/vendor/toastr/toastr.js"></script>
<script src="temp/global/js/Plugin/toastr.js"></script>
<script type="text/javascript">
	$('#multiselect').multiselect({sort: false,keepOrder: true  });
</script>
<script type="text/javascript">
	new ClipboardJS('.btncopiar');
</script>
<script type="text/javascript">
	$("#toast-bottomFullWidth").show();
	setTimeout(function () {
		$("#toast-bottomFullWidth").fadeOut();
	}, 6000);
</script>

</body>
</html>
