<?php

include_once './system/functions.php';
isLogged();
$logged_user = getLoggedUser();
if (!isAdmin($logged_user) && getServerProperty("manutencaoPainel", 0)) {
  header("Location: ./sair.php");
  exit();
}
$server_name = getServerProperty("server_name");
$fast_packages = json_decode(getServerProperty("fast_packages"), true);
$logotipo = getUserProperty($logged_user['id'], "logotipo");
$titulo = getUserProperty($logged_user['id'], "nomePainel");
$copyright = getUserProperty($logged_user['id'], "copyright");

if (isAdmin($logged_user)) {
 

if (isset($_POST["line_type"]) && isset($_POST["date"]) && isset($_POST["action"])) {
  $line_type = $_POST["line_type"];
  $date = $_POST["date"];
  $action = $_POST["action"];
  if ($action === "remove_lines" && is_array($line_type)) {
    $remove_expired = in_array("expired", $line_type);
    $remove_test = in_array("test", $line_type);
    if (strpos($date, " - ") !== false) {
      list($start_date) = explode(" - ", $date);
      $start_date .= " 00:00:00";
      list(, $end_date) = explode(" - ", $date);
      $end_date .= " 23:59:59";
      $stime = DateTime::createFromFormat("m/d/Y H:i:s", $start_date);
      $etime = DateTime::createFromFormat("m/d/Y H:i:s", $end_date);
      if ($stime && $etime) {
        $start_date = $stime->getTimestamp();
        $end_date = $etime->getTimestamp();
        if (deletarTodosOsTestes($remove_expired, $remove_test, $start_date, $end_date)) {
          header("location: ?result=lines_removed");
          exit;
        }
      }
    }
  }
  header("location: ?result=failed");
  exit;
}
}else{
  if (isset($_POST["line_type"]) && isset($_POST["date"]) && isset($_POST["action"])) {
  $line_type = $_POST["line_type"];
  $date = $_POST["date"];
  $action = $_POST["action"];
  if ($action === "remove_lines" && is_array($line_type)) {
    $remove_expired = in_array("expired", $line_type);
    $remove_test = in_array("test", $line_type);
    if (strpos($date, " - ") !== false) {
      list($start_date) = explode(" - ", $date);
      $start_date .= " 00:00:00";
      list(, $end_date) = explode(" - ", $date);
      $end_date .= " 23:59:59";
      $stime = DateTime::createFromFormat("m/d/Y H:i:s", $start_date);
      $etime = DateTime::createFromFormat("m/d/Y H:i:s", $end_date);
      if ($stime && $etime) {
        $start_date = $stime->getTimestamp();
        $end_date = $etime->getTimestamp();
        if (deleteExpiredTestUsersByOwner($logged_user["id"], $remove_expired, $remove_test, $start_date, $end_date)) {
          header("location: ?result=lines_removed");
          exit;
        }
      }
    }
  }
  header("location: ?result=failed");
  exit;
}
}
?>
<!DOCTYPE html>
<html class="no-js css-menubar" lang="en">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
  <meta name="description" content="bootstrap admin template">
  <meta name="author" content="">

  <title> FERRAMENTAS</title>

  <link rel="apple-touch-icon" href="temp/assets/images/apple-touch-icon.png">
  <link rel="shortcut icon" href="temp/assets/images/favicon.ico">

  <!-- Stylesheets -->
  <link rel="stylesheet" href="temp/global/css/bootstrap.min.css">
  <link rel="stylesheet" href="temp/global/css/bootstrap-extend.min.css">
  <link rel="stylesheet" href="temp/assets/css/site.min.css">
  <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
  <link rel="stylesheet" href="temp/global/vendor/toastr/toastr.css">
  <link rel="stylesheet" href="temp/assets/examples/css/advanced/toastr.css">

  <!-- Plugins -->
  <link rel="stylesheet" href="temp/global/vendor/animsition/animsition.css">
  <link rel="stylesheet" href="temp/global/vendor/asscrollable/asScrollable.css">
  <link rel="stylesheet" href="temp/global/vendor/switchery/switchery.css">
  <link rel="stylesheet" href="temp/global/vendor/intro-js/introjs.css">
  <link rel="stylesheet" href="temp/global/vendor/slidepanel/slidePanel.css">
  <link rel="stylesheet" href="temp/global/vendor/flag-icon-css/flag-icon.css">
  <link rel="stylesheet" href="temp/global/vendor/footable/footable.core.css">
  <link rel="stylesheet" href="temp/assets/examples/css/tables/footable.css">
  <link rel="stylesheet" href="temp/assets/css/responsive.bootstrap.min.css">


  <!-- Fonts -->
  <link rel="stylesheet" href="temp/global/fonts/font-awesome/font-awesome.css">
  <link rel="stylesheet" href="temp/global/fonts/web-icons/web-icons.min.css">
  <link rel="stylesheet" href="temp/global/fonts/brand-icons/brand-icons.min.css">
  <link rel='stylesheet' href='http://fonts.googleapis.com/css?family=Roboto:300,400,500,300italic'>

  <link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">

  <!-- Scripts -->
  <script src="temp/global/vendor/breakpoints/breakpoints.js"></script>
  <script>
    Breakpoints();
  </script>
</head>
<?php 
include_once "./incluir/menu_lateral.php";
?>    


<!-- Page -->
<!-- Page -->
<div class="page">
  <div class="page-header">
    <h1 class="page-title">Ferramentas de gestão</h1>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="/">Painel</a></li>

      <li class="breadcrumb-item active">Ferramentas</li>
    </ol>
    <div class="page-header-actions">

    </div>
  </div>

  <div class="page-content container-fluid">
    <div class="row">
      <div class="col-xl-12">
       <!-- Panel Row Toggler -->
       <div class="panel">
        <header class="panel-heading">
          <h3 class="panel-title"></h3>
        </header>
        <div class="panel-body">
          <?php  
          if (isset($_GET["result"])) {
            $result = $_GET["result"];
            $result_message = "Aconteceu um problema, tente novamente mais tarde!";
            $result_type = "warning";
            switch ($result) {
              case "lines_removed":
              if (isAdmin($logged_user)) {
              $result_message = "Listas de todos os usuarios removidas com sucesso";
            }else{
              $result_message = "Listas removidas com sucesso";
            }
              $result_type = "success";
              break;
            }
            echo'<div id="toast-bottomFullWidth" class="toast-bottom-full-width" aria-live="polite" role="alert"><div class="toast toast-'.$result_type.'" style=""><div class="toast-message">'.$result_message.'</div></div></div>';
          }
          ?>
          <div class="card-body">
            <h4 class="card-title mb-4">Ferramentas úteis </h4>
            <div class="basic-form">
             <!-- fim form original criar teste -->
             <div class="row">
              <?php  
              if (isAdmin($logged_user)) {
                ?>
                <div class="col-md-6">
                  <h4 class="card-title mb-4" style="color: red;">ATENÇÃO ! <br><br>LOGADO COMO ADMIN AFETARÁ TODOS OS USUARIOS DO SERVIDOR </h4>
                  <form id="remove-lists" autocomplete="off" method="post">
                    <input type="hidden" name="action" value="remove_lines">
                    <div class="form-group col-md-12">
                      <div class="checkbox-custom">
                        <input type="checkbox" name="line_type[]" value="test" autocomplete="off">
                        <label>Listas testes</label>
                      </div>
                      <div class="checkbox-custom">
                        <input type="checkbox" name="line_type[]" value="expired" autocomplete="off">
                        <label>Listas expiradas</label>
                      </div>
                    </div>
                    <div class="form-group col-md-12">
                      <label  class="text-label">Selecione o intervalo de data desejado.</label>
                      <div class="input-group">                                                       
                        <div class="input-group-addon">
                          <i class="fa fa-bug"></i>
                        </div>
                        <input type="text" class="form-control" name="date" id="date" autocomplete="off" required="">
                      </div>
                      <span class="text-help"></span>
                    </div>
                    <div class="form-group">
                      <button type="submit" class="btn btn-success btn-form mr-2" id="submit-button">Remover</button>
                      <a href="<?= $base_url.'public/dashboard' ?>" class="btn btn-light text-dark btn-form">Cancelar</a>
                    </div>
                  </form>
                </div>
              <?php }else{  ?>

                <div class="col-md-6">
                  <form id="remove-lists" autocomplete="off" method="post">
                    <input type="hidden" name="action" value="remove_lines">
                    <div class="form-group col-md-12">
                      <div class="checkbox-custom">
                        <input type="checkbox" name="line_type[]" value="test" autocomplete="off">
                        <label>Listas testes</label>
                      </div>
                      <div class="checkbox-custom">
                        <input type="checkbox" name="line_type[]" value="expired" autocomplete="off">
                        <label>Listas expiradas</label>
                      </div>
                    </div>
                    <div class="form-group col-md-12">
                      <label  class="text-label">Selecione o intervalo de data desejado.</label>
                      <div class="input-group">                                                       
                        <div class="input-group-addon">
                          <i class="fa fa-bug"></i>
                        </div>
                        <input type="text" class="form-control" name="date" id="date" autocomplete="off" required="">
                      </div>
                      <span class="text-help"></span>
                    </div>
                    <div class="form-group">
                      <button type="submit" class="btn btn-success btn-form mr-2" id="submit-button">Remover</button>
                      <a href="<?= $base_url.'public/dashboard' ?>" class="btn btn-light text-dark btn-form">Cancelar</a>
                    </div>
                  </form>
                </div>
              <?php } ?>

            </div>
            <!-- fim form original criar teste -->
          </div>
        </div>
      </div>
    </div>

  </div>
</div>
</div>
</div>
<!-- End Page -->


<!-- Footer -->
<footer class="site-footer">
  <?php 
  include_once "./incluir/footer.php";
  ?>
</footer>
<!-- Core  -->
<script src="temp/global/vendor/babel-external-helpers/babel-external-helpers.js"></script>
<script src="temp/global/vendor/jquery/jquery.js"></script>
<script src="temp/global/vendor/popper-js/umd/popper.min.js"></script>
<script src="temp/global/vendor/bootstrap/bootstrap.js"></script>
<script src="temp/global/vendor/animsition/animsition.js"></script>
<script src="temp/global/vendor/mousewheel/jquery.mousewheel.js"></script>
<script src="temp/global/vendor/asscrollbar/jquery-asScrollbar.js"></script>
<script src="temp/global/vendor/asscrollable/jquery-asScrollable.js"></script>
<script src="temp/global/vendor/ashoverscroll/jquery-asHoverScroll.js"></script>

<!-- Plugins -->
<script src="temp/global/vendor/switchery/switchery.js"></script>
<script src="temp/global/vendor/intro-js/intro.js"></script>
<script src="temp/global/vendor/screenfull/screenfull.js"></script>
<script src="temp/global/vendor/slidepanel/jquery-slidePanel.js"></script>
<script src="temp/global/vendor/moment/moment.min.js"></script>
<script src="temp/global/vendor/footable/footable.min.js"></script>

<!-- Scripts -->
<script src="temp/global/js/Component.js"></script>
<script src="temp/global/js/Plugin.js"></script>
<script src="temp/global/js/Base.js"></script>
<script src="temp/global/js/Config.js"></script>

<script src="temp/assets/js/Section/Menubar.js"></script>
<script src="temp/assets/js/Section/GridMenu.js"></script>
<script src="temp/assets/js/Section/Sidebar.js"></script>
<script src="temp/assets/js/Section/PageAside.js"></script>
<script src="temp/assets/js/Plugin/menu.js"></script>

<script src="temp/global/js/config/colors.js"></script>
<script src="temp/assets/js/config/tour.js"></script>
<script>Config.set('assets', 'temp/assets');</script>

<!-- Page -->
<script src="temp/assets/js/Site.js"></script>
<script src="temp/global/js/Plugin/asscrollable.js"></script>
<script src="temp/global/js/Plugin/slidepanel.js"></script>
<script src="temp/global/js/Plugin/switchery.js"></script>

<script src="temp/assets/examples/js/tables/footable.js"></script>

<script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/fixedheader/3.1.5/js/dataTables.fixedHeader.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.2.3/js/dataTables.responsive.min.js"></script>
<script src="temp/global/js/Plugin/toastr.js"></script>
<script src="temp/global/vendor/toastr/toastr.js"></script>

<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script type="text/javascript">
  $(function () {
    $('#date').daterangepicker();
    $('input[type="checkbox"].flat-red, input[type="radio"].flat-red').iCheck({
      checkboxClass: 'icheckbox_flat-green',
      radioClass   : 'iradio_flat-green'
    });
    $(".alert").delay(3000).slideUp(200, function() {
      $(this).alert('close');
    });
  });
</script>
<script type="text/javascript">
  $("#toast-bottomFullWidth").show();
  setTimeout(function () {
    $("#toast-bottomFullWidth").fadeOut();
  }, 6000);
</script>

</body>
</html>
