<?php

include_once './system/functions.php';
isLogged();
$logged_user = getLoggedUser();
if (!isAdmin($logged_user) && getServerProperty("manutencaoPainel", 0)) {
	header("Location: ./sair.php");
	exit();
}
if (!isAdmin($logged_user)) {
	header("Location: ./index.php");
	exit;
}

if (isset($_GET['id_pac'])) {
	$id_pacote = $_GET['id_pac'];
	//var_dump($id_pacote); die();

	if (excluirPacote($id_pacote)) {
		header("Location: ./gerir-pacotes.php?result=pac_excluido_sucesso");
	}else{
		header("Location: ./gerir-pacotes.php?result=erro_excluir_pacote");
	}
}

$server_name = getServerProperty("server_name");
$logotipo = getUserProperty($logged_user['id'], "logotipo");
$titulo = getUserProperty($logged_user['id'], "nomePainel");
$copyright = getUserProperty($logged_user['id'], "copyright");
$pacotes = pegarPacotes();
 // echo '<pre>';        var_dump($pacotes);      echo '</pre>'; die();
?>
<!DOCTYPE html>
<html class="no-js css-menubar" lang="en">
<head>
	<style type="text/css">
		.azul{

			color: #0bb2d4;

		}
	</style>
	<style type="text/css">
		.vermelho{

			color: #ff4c52;

		}
	</style>
	<style type="text/css">
		.verde{

			color: #28a745;

		}
	</style>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
	<meta name="description" content="bootstrap admin template">
	<meta name="author" content="">

	<title>GERENCIADOR</title>

	<link rel="apple-touch-icon" href="temp/assets/images/apple-touch-icon.png">
	<link rel="shortcut icon" href="temp/assets/images/favicon.ico">

	<!-- Stylesheets -->
	<link rel="stylesheet" href="temp/global/css/bootstrap.min.css">
	<link rel="stylesheet" href="temp/global/css/bootstrap-extend.min.css">
	<link rel="stylesheet" href="temp/assets/css/site.min.css">
	<link rel="stylesheet" href="temp/assets/css/responsive.bootstrap.min.css">
	<link rel="stylesheet" type="text/css" href="temp/assets/css/responsive.dataTables.min.css"/>
	<link rel="stylesheet" href="temp/global/vendor/toastr/toastr.css">
	<link rel="stylesheet" href="temp/assets/examples/css/advanced/toastr.css">
	<link rel="stylesheet" href="temp/global/vendor/datatables.net-bs4/dataTables.bootstrap4.css">
	<link rel="stylesheet" href="temp/global/vendor/datatables.net-fixedheader-bs4/dataTables.fixedheader.bootstrap4.css">
	<link rel="stylesheet" href="temp/global/vendor/datatables.net-fixedcolumns-bs4/dataTables.fixedcolumns.bootstrap4.css">
	<link rel="stylesheet" href="temp/global/vendor/datatables.net-rowgroup-bs4/dataTables.rowgroup.bootstrap4.css">
	<link rel="stylesheet" href="temp/global/vendor/datatables.net-scroller-bs4/dataTables.scroller.bootstrap4.css">
	<link rel="stylesheet" href="temp/global/vendor/datatables.net-select-bs4/dataTables.select.bootstrap4.css">
	<link rel="stylesheet" href="temp/global/vendor/datatables.net-responsive-bs4/dataTables.responsive.bootstrap4.css">
	<link rel="stylesheet" href="temp/global/vendor/datatables.net-buttons-bs4/dataTables.buttons.bootstrap4.css">
	<link rel="stylesheet" href="temp/assets/examples/css/tables/datatable.css">



	<!-- Plugins -->
	<link rel="stylesheet" href="temp/global/vendor/animsition/animsition.css">
	<link rel="stylesheet" href="temp/global/vendor/asscrollable/asScrollable.css">
	<link rel="stylesheet" href="temp/global/vendor/switchery/switchery.css">
	<link rel="stylesheet" href="temp/global/vendor/intro-js/introjs.css">
	<link rel="stylesheet" href="temp/global/vendor/slidepanel/slidePanel.css">
	<link rel="stylesheet" href="temp/global/vendor/flag-icon-css/flag-icon.css">
	<link rel="stylesheet" href="temp/global/vendor/footable/footable.core.css">
	<link rel="stylesheet" href="temp/assets/examples/css/tables/footable.css">
	<link rel="stylesheet" href="temp/assets/css/datatablesEdit.min.css">



	<!-- Fonts -->
	<link rel="stylesheet" href="temp/global/fonts/font-awesome/font-awesome.css">
	<link rel="stylesheet" href="temp/global/fonts/web-icons/web-icons.min.css">
	<link rel="stylesheet" href="temp/global/fonts/brand-icons/brand-icons.min.css">
	<link rel='stylesheet' href='http://fonts.googleapis.com/css?family=Roboto:300,400,500,300italic'>




	<!-- Scripts -->
	<script src="temp/global/vendor/breakpoints/breakpoints.js"></script>
	<script>
		Breakpoints();
	</script>
</head>
<?php 
include_once "./incluir/menu_lateral.php";
?>


<!-- Page -->
<!-- Page -->
<div class="page">
	<div class="page-header">
		<h1 class="page-title">Gerenciar pacotes</h1>
		<ol class="breadcrumb">
			<li class="breadcrumb-item"><a href="/">Painel</a></li>

			<li class="breadcrumb-item active">Todos pacotes</li>
		</ol>
		<div class="page-header-actions">

		</div>
	</div>

	<?php 
	if (isset($_REQUEST["result"])) {
		$result = $_REQUEST["result"];

		$result_message = "Aconteceu um problema, tente novamente mais tarde!";
		$result_type = "warning";
		switch ($result) {
			case 'pac_excluido_sucesso':
			$result_message = "Pacote excluído com sucesso";
			$result_type = "success";
			break;
			case 'erro_excluir_pacote':
			$result_message = "Erro ao excluir pacote. Tente novamente!";
			$result_type = "danger";
			break;
		}
		echo "<div id='toast-bottomFullWidth' class='toast-bottom-full-width' aria-live='polite' role='alert'>
		<div class='toast toast-$result_type' style=''>
		<div class='toast-message'>$result_message</div>
		</div>
		</div>";
	}
	?>
	<div class="page-content">
		<!-- Panel Basic -->
		<div class="panel">
			<header class="panel-heading">
				<div class="panel-actions"></div>
				<h3 class="panel-title"></h3>
			</header>
			<div class="panel-body">
				<table class="table table-hover dataTable table-striped w-full" data-plugin="dataTable">
					<thead>
						<tr>
							<th>ID</th>
							<th>Nome do pacote</th>
							<th>É teste?</th>
							<th>Valor teste</th>
							<th>Duração teste</th>
							<th>É oficial?</th>
							<th>Valor oficial</th>
							<th>Duração oficial</th>
							<th>Ações</th>
						</tr>
					</thead>
					<tbody>
						<?php  
						foreach ($pacotes as $key => $value) {
							$id = $value['id'];
							$nome_pacote = $value['package_name'];
							$eTeste = $value['is_trial'] == 1 ? 'Sim' : 'Não';
							$eOfficial = $value['is_official'] == 1 ? 'Sim' : 'Não';
							$creditosOficial = $value['official_credits'];
							$creditosTeste = $value['trial_credits'];
							$tempoDeTeste = $value['trial_duration'].' - '.$value['trial_duration_in'];
							$tempoDeTeste2 = $value['trial_duration'];
							$hora_teste = $value['trial_duration_in'];
							$tempoOfficial = $value['official_duration'].' - '.$value['official_duration_in'];
							$tempoOfficial2 = $value['official_duration'];
							$hora_official = $value['official_duration_in'];

							?>

							<tr>
								<td><?php echo $id; ?></td>
								<td><?php echo $nome_pacote; ?></td>
								<td><?php echo $eTeste; ?></td>
								<td><b><?php echo $creditosTeste; ?></b> - Créditos</td>
								<td><?php echo $tempoDeTeste; ?></td>
								<td><?php echo $eOfficial; ?></td>
								<td><b><?php echo $creditosOficial; ?></b> - Créditos</td>
								<td><?php echo $tempoOfficial; ?></td>
								<td class="actions">
									<form method="post" action="editar-pacotes.php">
										<input type="hidden" name="id" value="<?php echo $id; ?>">
										<input type="hidden" name="nome_pacote" value="<?php echo $nome_pacote; ?>">
										<input type="hidden" name="eTeste" value="<?php echo $eTeste; ?>">
										<input type="hidden" name="creditosTeste" value="<?php echo $creditosTeste; ?>">
										<input type="hidden" name="tempoDeTeste" value="<?php echo $tempoDeTeste2; ?>">
										<input type="hidden" name="hora_teste" value="<?php echo $hora_teste; ?>">
										<input type="hidden" name="eOfficial" value="<?php echo $eOfficial; ?>">
										<input type="hidden" name="creditosOficial" value="<?php echo $creditosOficial; ?>">
										<input type="hidden" name="tempoOfficial" value="<?php echo $tempoOfficial2; ?>">
										<input type="hidden" name="hora_official" value="<?php echo $hora_official; ?>">
										<button type="submit" class="btn btn-sm btn-icon btn-pure btn-default on-default edit-row"
										data-toggle="tooltip" data-original-title="Editar epg">
										<i class="icon wb-pencil" aria-hidden="true"></i></button>
									</form>

									<a href="gerir-pacotes.php?id_pac=<?php echo $id; ?>" class="btn btn-sm btn-icon btn-pure btn-danger on-default edit-row" data-toggle="tooltip" data-original-title="Excluir pacote"><i class="icon wb-trash" aria-hidden="true"></i></a>
								</td>
							</tr>
						<?php } ?>
					</tbody>
				</table>
			</div>
		</div>
		<!-- End Panel Basic -->

	</div>
</div>
</div>
</div>
<!-- End Page -->



<!-- Footer -->
<footer class="site-footer">
	<?php 
	include_once "./incluir/footer.php";
	?>
</footer>
<!-- Core  -->
<script src="temp/global/vendor/babel-external-helpers/babel-external-helpers.js"></script>
<script src="temp/global/vendor/jquery/jquery.js"></script>
<script src="temp/global/vendor/popper-js/umd/popper.min.js"></script>
<script src="temp/global/vendor/bootstrap/bootstrap.js"></script>
<script src="temp/global/vendor/animsition/animsition.js"></script>
<script src="temp/global/vendor/mousewheel/jquery.mousewheel.js"></script>
<script src="temp/global/vendor/asscrollbar/jquery-asScrollbar.js"></script>
<script src="temp/global/vendor/asscrollable/jquery-asScrollable.js"></script>
<script src="temp/global/vendor/ashoverscroll/jquery-asHoverScroll.js"></script>

<!-- Plugins -->
<script src="temp/global/vendor/switchery/switchery.js"></script>
<script src="temp/global/vendor/intro-js/intro.js"></script>
<script src="temp/global/vendor/screenfull/screenfull.js"></script>
<script src="temp/global/vendor/slidepanel/jquery-slidePanel.js"></script>
<script src="temp/global/vendor/moment/moment.min.js"></script>
<script src="temp/global/vendor/footable/footable.min.js"></script>
<script src="temp/global/vendor/datatables.net/jquery.dataTables.js"></script>
<script src="temp/global/vendor/datatables.net-bs4/dataTables.bootstrap4.js"></script>
<script src="temp/global/vendor/datatables.net-fixedheader/dataTables.fixedHeader.js"></script>
<script src="temp/global/vendor/datatables.net-fixedcolumns/dataTables.fixedColumns.js"></script>
<script src="temp/global/vendor/datatables.net-rowgroup/dataTables.rowGroup.js"></script>
<script src="temp/global/vendor/datatables.net-scroller/dataTables.scroller.js"></script>
<script src="temp/global/vendor/datatables.net-responsive/dataTables.responsive.js"></script>
<script src="temp/global/vendor/datatables.net-responsive-bs4/responsive.bootstrap4.js"></script>
<script src="temp/global/vendor/datatables.net-buttons/dataTables.buttons.js"></script>
<script src="temp/global/vendor/datatables.net-buttons/buttons.html5.js"></script>
<script src="temp/global/vendor/datatables.net-buttons/buttons.flash.js"></script>
<script src="temp/global/vendor/datatables.net-buttons/buttons.print.js"></script>
<script src="temp/global/vendor/datatables.net-buttons/buttons.colVis.js"></script>
<script src="temp/global/vendor/datatables.net-buttons-bs4/buttons.bootstrap4.js"></script>
<script src="temp/global/vendor/asrange/jquery-asRange.min.js"></script>
<script src="temp/global/vendor/bootbox/bootbox.js"></script>


<!-- Scripts -->
<script src="temp/global/js/Component.js"></script>
<script src="temp/global/js/Plugin.js"></script>
<script src="temp/global/js/Base.js"></script>
<script src="temp/global/js/Config.js"></script>

<script src="temp/assets/js/Section/Menubar.js"></script>
<script src="temp/assets/js/Section/GridMenu.js"></script>
<script src="temp/assets/js/Section/Sidebar.js"></script>
<script src="temp/assets/js/Section/PageAside.js"></script>
<script src="temp/assets/js/Plugin/menu.js"></script>

<script src="temp/global/js/config/colors.js"></script>
<script src="temp/assets/js/config/tour.js"></script>
<script>Config.set('assets', 'temp/assets');</script>

<!-- Page -->
<script src="temp/assets/js/Site.js"></script>
<script src="temp/global/js/Plugin/asscrollable.js"></script>
<script src="temp/global/js/Plugin/slidepanel.js"></script>
<script src="temp/global/js/Plugin/switchery.js"></script>
<script src="temp/global/js/Plugin/datatables.js"></script>

<script src="temp/assets/examples/js/tables/datatable.js"></script>

<script src="temp/assets/examples/js/tables/footable.js"></script>
<script src="temp/assets/js/bootbox.js"></script>
<script src="temp/assets/js/bootbox.min.js"></script>

<script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>

<script src="https://cdn.datatables.net/responsive/2.2.3/js/dataTables.responsive.min.js"></script>
<script src="temp/global/js/Plugin/toastr.js"></script>
<script src="temp/global/vendor/toastr/toastr.js"></script>
<script src="temp/assets/js/clipboard.min.js"></script>
<script type="text/javascript">
	$("#toast-bottomFullWidth").show();
	setTimeout(function () {
		$("#toast-bottomFullWidth").fadeOut();
	}, 10000);
</script>
</body>
</html>
