<?php 
ini_set('display_errors', 1);
include_once "./variadas/verificacoes.php";

if (getServerProperty("manutencaoPainel", 0)) {
  header("Location: manutencao.php");
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
  <title>Login - Express Live</title>

  <!-- Stylesheets -->
  <link rel="stylesheet" href="temp/global/css/bootstrap.min.css">
  <style>
    body {
      background-color: #121212;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      margin: 0;
    }
    .login-container {
      background-color: #1e1e1e;
      padding: 30px;
      border-radius: 8px;
      width: 100%;
      max-width: 400px;
      text-align: center;
      color: white;
    }
    .login-logo {
      margin-bottom: 20px;
    }
    .login-logo img {
      width: 100px;
    }
    .login-title {
      font-size: 24px;
      font-weight: bold;
      margin-bottom: 10px;
    }
    .form-group {
      position: relative;
      margin-bottom: 20px;
    }
    .form-control {
      background-color: #2e2e2e;
      border: 1px solid #555;
      color: white;
      padding: 12px;
      width: 100%;
      border-radius: 4px;
    }
    .form-control:focus {
      border-color: #3a82f7;
      outline: none;
    }
    .btn-primary {
      background-color: #ff3000;
      border: none;
      padding: 12px;
      width: 100%;
      border-radius: 4px;
      font-size: 16px;
      font-weight: bold;
    }
    .footer-text {
      color: #888;
      font-size: 12px;
      margin-top: 15px;
    }
    .footer-text a {
      color: #3a82f7;
      text-decoration: none;
    }
    .footer-version {
      font-size: 10px;
      color: #555;
      margin-top: 10px;
    }
    
    
  </style>
</head>
<body>
  <div class="login-container">
    <div class="login-logo">
      <img src="https://mytvfun.2bxt.xyz/root/temp/assets/images/logo-login.png" alt="Logo">
    </div>
    <div class="login-title">Login</div>

    <?php 
      if (isset($_GET["result"])) {
        $result = $_GET["result"];
        $result_message = "Aconteceu um problema, tente novamente mais tarde!";
        $result_type = "danger";
        switch ($result) {
          case "cant_connect":
            $result_message = "Não é possível se conectar agora, tente novamente em alguns minutos!";
            break;
          case "invalid_user_or_pass":
            $result_message = "Usuário ou/e senha incorreto(s).";
            break;
          case "blocked":
            $result_message = "Usuário bloqueado, contacte seu revendedor.";
            break;
          case "insufficient_permission":
            $result_message = "Você não tem permissão para acessar o painel office!";
            break;
          case "password_changed":
            $result_type = "success";
            $result_message = "Senha alterada com sucesso, conecte-se.";
            break;
          case "conta_expirada":
            $result_message = "Sua conta está expirada ou bloqueada, por favor renove!";
            break;
          case "detalhes_invalidos":
            $result_message = "Usuario ou Senha não conferem";
            break;
        }
        echo "<div class=\"alert alert-$result_type\">$result_message</div>";
      }
    ?>

    <form method="post" action="index.php">
      <input type="hidden" name="idrevenda" value="<?php echo $resselerID; ?>">
      <div class="form-group">
        <input type="text" class="form-control" name="username" placeholder="Usuário" required>
      </div>
      <div class="form-group">
        <input type="password" class="form-control" name="password" placeholder="Senha" required>
      </div>
      <button type="submit" class="btn btn-primary">Continuar</button>
    </form>
    
    <div class="footer-text">
      Sistema protegido contra bots e ferramentas de automação
    </div>
    <div class="footer-version">v1.00</div>
  </div>
</body>
</html>
