<?php

include_once './system/functions.php';
isLogged();
$logged_user = getLoggedUser();
if (!isAdmin($logged_user) && getServerProperty("manutencaoPainel", 0)) {
  header("Location: ./sair.php");
  exit();
}
$server_name = getServerProperty("server_name");
$fast_packages = json_decode(getServerProperty("fast_packages"), true);
$logotipo = getUserProperty($logged_user['id'], "logotipo");
$titulo = getUserProperty($logged_user['id'], "nomePainel");
$copyright = getUserProperty($logged_user['id'], "copyright");
if (isset($_POST["title"]) && isset($_POST["message"])) {
	$title = $_POST["title"];
	$message = $_POST["message"];
	$reseller_id = isset($_POST["reseller"]) ? $_POST["reseller"] : "";
	if (strlen($title) < 6 || 255 < strlen($title)) {
		header("location: ?result=invalid_title");
		exit;
	}
	if (strlen($message) < 6 || 1000 < strlen($message)) {
		header("location: ?result=invalid_message");
		exit;
	}
	if (createTicket($logged_user, $reseller_id, $title, $message)) {
		header("location: ?result=success");
		exit;
	}
}
?>
<!DOCTYPE html>
<html class="no-js css-menubar" lang="en">
<head>
  <style type="text/css">
    .paragrafo1{

      color: #ff0000;

    }
  </style>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
  <meta name="description" content="bootstrap admin template">
  <meta name="author" content="">

  <title> CHAMADOS</title>

  <link rel="apple-touch-icon" href="temp/assets/images/apple-touch-icon.png">
  <link rel="shortcut icon" href="temp/assets/images/favicon.ico">

  <!-- Stylesheets -->
  <link rel="stylesheet" href="temp/global/css/bootstrap.min.css">
  <link rel="stylesheet" href="temp/global/css/bootstrap-extend.min.css">
  <link rel="stylesheet" href="temp/assets/css/site.min.css">
  <link rel="stylesheet" href="temp/assets/css/responsive.bootstrap.min.css">
  <link rel="stylesheet" type="text/css" href="temp/assets/css/responsive.dataTables.min.css"/>



  <!-- Plugins -->
  <link rel="stylesheet" href="temp/global/vendor/animsition/animsition.css">
  <link rel="stylesheet" href="temp/global/vendor/asscrollable/asScrollable.css">
  <link rel="stylesheet" href="temp/global/vendor/switchery/switchery.css">
  <link rel="stylesheet" href="temp/global/vendor/intro-js/introjs.css">
  <link rel="stylesheet" href="temp/global/vendor/slidepanel/slidePanel.css">
  <link rel="stylesheet" href="temp/global/vendor/flag-icon-css/flag-icon.css">
  <link rel="stylesheet" href="temp/global/vendor/footable/footable.core.css">
  <link rel="stylesheet" href="temp/assets/examples/css/tables/footable.css">


  <!-- Fonts -->
  <link rel="stylesheet" href="temp/global/fonts/font-awesome/font-awesome.css">
  <link rel="stylesheet" href="temp/global/fonts/web-icons/web-icons.min.css">
  <link rel="stylesheet" href="temp/global/fonts/brand-icons/brand-icons.min.css">
  <link rel='stylesheet' href='http://fonts.googleapis.com/css?family=Roboto:300,400,500,300italic'>
  <link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">


  <!-- Scripts -->
  <script src="temp/global/vendor/breakpoints/breakpoints.js"></script>
  <script>
    Breakpoints();
  </script>
</head>
<?php 
include_once "./incluir/menu_lateral.php";
?>


<!-- Page -->
<div class="page">
	<div class="page-header">
		<h1 class="page-title">Meus chamados</h1>
		<ol class="breadcrumb">
			<li class="breadcrumb-item"><a href="/">Painel</a></li>

			<li class="breadcrumb-item active">Meus chamados</li>
		</ol>
		<div class="page-header-actions">

		</div>
	</div>

	<div class="page-content container-fluid">
		<?php  
		if (isset($_GET["result"])) {
			$result = $_GET["result"];
			$result_message = "Aconteceu um problema, tente novamente mais tarde!";
			$result_type = "warning";
			switch ($result) {
				case "success":
				$result_message = "O ticket foi criado com sucesso.";
				$result_type = "success";
				break;
			}
			echo "            <div class=\"alert alert-";
			echo $result_type;
			echo " alert-dismissible\">\n              <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">×</button>\n              <i class=\"icon fa fa-check\"></i>\n              ";
			echo $result_message;
			echo "            </div>\n          ";
		}
		?>
    <div class="row">
      <div class="col-xl-12">
       <!-- Panel Row Toggler -->
       <div class="panel">
        <header class="panel-heading">
          <h3 class="panel-title"></h3>
        </header>
        <div class="panel-body">
          <table class="table table-striped table-hover toggle-circle" id="exampleRowToggler">
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
</div>

</div>
</div>
</div>
</div>
<!-- End Page -->


<!-- Footer -->
<footer class="site-footer">
  <?php 
  include_once "./incluir/footer.php";
  ?>
</footer>
<!-- Core  -->
<script src="temp/global/vendor/babel-external-helpers/babel-external-helpers.js"></script>
<script src="temp/global/vendor/jquery/jquery.js"></script>
<script src="temp/global/vendor/popper-js/umd/popper.min.js"></script>
<script src="temp/global/vendor/bootstrap/bootstrap.js"></script>
<script src="temp/global/vendor/animsition/animsition.js"></script>
<script src="temp/global/vendor/mousewheel/jquery.mousewheel.js"></script>
<script src="temp/global/vendor/asscrollbar/jquery-asScrollbar.js"></script>
<script src="temp/global/vendor/asscrollable/jquery-asScrollable.js"></script>
<script src="temp/global/vendor/ashoverscroll/jquery-asHoverScroll.js"></script>

<!-- Plugins -->
<script src="temp/global/vendor/switchery/switchery.js"></script>
<script src="temp/global/vendor/intro-js/intro.js"></script>
<script src="temp/global/vendor/screenfull/screenfull.js"></script>
<script src="temp/global/vendor/slidepanel/jquery-slidePanel.js"></script>
<script src="temp/global/vendor/moment/moment.min.js"></script>
<script src="temp/global/vendor/footable/footable.min.js"></script>

<!-- Scripts -->
<script src="temp/global/js/Component.js"></script>
<script src="temp/global/js/Plugin.js"></script>
<script src="temp/global/js/Base.js"></script>
<script src="temp/global/js/Config.js"></script>

<script src="temp/assets/js/Section/Menubar.js"></script>
<script src="temp/assets/js/Section/GridMenu.js"></script>
<script src="temp/assets/js/Section/Sidebar.js"></script>
<script src="temp/assets/js/Section/PageAside.js"></script>
<script src="temp/assets/js/Plugin/menu.js"></script>

<script src="temp/global/js/config/colors.js"></script>
<script src="temp/assets/js/config/tour.js"></script>
<script>Config.set('assets', 'temp/assets');</script>

<!-- Page -->
<script src="temp/assets/js/Site.js"></script>
<script src="temp/global/js/Plugin/asscrollable.js"></script>
<script src="temp/global/js/Plugin/slidepanel.js"></script>
<script src="temp/global/js/Plugin/switchery.js"></script>

<script src="temp/assets/examples/js/tables/footable.js"></script>
<script src="temp/assets/js/bootbox.js"></script>
<script src="temp/assets/js/bootbox.min.js"></script>

<script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>

<script src="https://cdn.datatables.net/responsive/2.2.3/js/dataTables.responsive.min.js"></script>
<script type="text/javascript">
  $(function () {
    var table = $('#exampleRowToggler').DataTable({
      "ajax": '<?= $base_url; ?>' + "system/API.php?action=get_tickets",
			"processing": true,
			"serverSide": true,
			"columns": [ { 'data': null },
			{"data": "id","title":"ID"},
			{"data": "reseller","title":"Revendedor"},
			{"data": "title","title":"Título"},
			{"data": "last_reply","title":"Última Resposta"},
			{"data": "status","title":"Status"},
			{"data": "action","title":"Ações","width":"300px"}
			],
			'responsive': {
				'details': {
					'type': 'column',
					'target': 0
				}
			},
			'columnDefs': [
			{
				'data': null,
				'defaultContent': '',
				'className': 'control',
				'orderable': false,
				'targets': 0
			}
			],
			'select': {
				'style': 'multi',
				'selector': 'td:not(.control)'
			},
			"order": [[ 0, "desc" ]],
			"paging": true,
			"lengthChange": true,
			"searching": true,
			"ordering": true,
			"orderMulti": false,
			"info": true,
			"autoWidth": false,
			"language": {
				"processing": "Processando...",
				"lengthMenu": "Mostrar _MENU_ registros",
				"zeroRecords": "Não foram encontrados resultados",
				"info": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
				"infoEmpty": "Mostrando de 0 até 0 de 0 registros",
				"sInfoFiltered": "",
				"sInfoPostFix": "",
				"search": "Buscar:",
				"url": "",
				"loadingRecords": "Carregando...",
				"paginate": {
					"first": "Primeiro",
					"previous": "Anterior",
					"next": "Seguinte",
					"last": "Último"
				}
			}, 

      "drawCallback": function () {
        $('[data-toggle="tooltip"]').tooltip();
      }, 

      "createdRow": function (row, data) {
        if (data['status'].includes('Expirado')) {
          $(row).addClass('text-red');
        }
      }
      
    });

    /* ABRIR/FECHAR */
		$(document).on('click', '.bttoggle', function (e) {
			e.preventDefault();
			const id = $(this).data("id");
			bootbox.dialog({
				title: "Tem certeza que deseja abrir/fechar este ticket ?",
				message: "<p>" + $(this).data("text") + "</p>",
				buttons: {
					cancel: {
						label: "Cancelar",
						className: 'btn-danger',
						callback: function () {
						}
					},
					noclose: {
						label: "Confirmar",
						className: 'btn-success btntoggle',
						callback: function () {
							$('.btntoggle').hide();
							$.get('<?= $base_url; ?>' + 'system/API.php?action=toggle_ticket&ticket_id=' + id, function (data) {
								if (data.result === 'success') {
									table.ajax.reload();
									messageConfirm('Ticket aberto/fechado com sucesso!');
								} else {
									messageConfirm('Não foi possível abrir/fechar este usuário.');
								}
							}, "json");
						}
					},
				}
			});
		});

		/* DELETAR */
		$(document).on('click', '.btdelete', function (e) {
			e.preventDefault();
			const id = $(this).data("id");
			bootbox.dialog({
				title: "Tem certeza que deseja deletar este ticket ?",
				message: "<p>" + $(this).data("text") + "</p>",
				buttons: {
					cancel: {
						label: "Cancelar",
						className: 'btn-danger',
						callback: function () {
						}
					},
					noclose: {
						label: "Confirmar",
						className: 'btn-success btndelete',
						callback: function () {
							$('.btndelete').hide();
							$.get('<?= $base_url; ?>' + 'system/API.php?action=delete_ticket&ticket_id=' + id, function (data) {
								if (data.result === 'success') {
									table.ajax.reload();
									messageConfirm('Ticket deletado com sucesso!');
								} else {
									messageConfirm('Não foi possível deletar este ticket.');
								}
							}, "json");
						}
					},
				}
			});
		});

		/* alert */
		function messageConfirm(msg){
			bootbox.confirm(msg, function(result){ 
			});
		}


	});
</script>
<script type="text/javascript">

  $.ajax({
    statusCode: {
      500: function() {
        console.log(versao-assincrona.php?var1&var2...);
      }
    }
  });
</script>
</body>
</html>
