<?php

include_once "./system/functions.php";
isLogged();
$logged_user = getLoggedUser();
if (!isAdmin($logged_user) && getServerProperty("manutencaoPainel", 0)) {
  header("Location: ./sair.php");
  exit();
}
if (!isAdmin($logged_user) && !isUltra($logged_user) && !isMaster($logged_user)) {
  header("Location: ./index.php");
  exit;
}
$server_name = getServerProperty("server_name");
$fast_packages = json_decode(getServerProperty("fast_packages"), true);
$whatsapp = getUserProperty($logged_user["id"], "whatsapp");
$telegram = getUserProperty($logged_user["id"], "telegram");
$logotipo = getUserProperty($logged_user["id"], "logotipo");
$titulo = getUserProperty($logged_user["id"], "nomePainel");
$copyright = getUserProperty($logged_user["id"], "copyright");

if (isset($_POST["password"]) && isset($_POST["email"]) && isset($_POST["whatsapp"]) && isset($_POST["telegram"]) && isset($_POST["logotipo"]) && isset($_POST["nome-painel"]) && isset($_POST["copyright"])) {
  $password = $_POST["password"];
  $email = $_POST["email"];
  $whatsapp = $_POST["whatsapp"];
  $telegram = $_POST["telegram"];
  $logotipo = $_POST["logotipo"];
  $nomePainel = $_POST["nome-painel"];
  $copyright = $_POST["copyright"];

  if (!empty($passowrd) && (strlen($password) < 6 || 255 < strlen($password))) {
    header("location: ?result=invalid_password");
    exit;
  }
  if (updateUser($logged_user["id"], $logged_user["username"], $password, $email, $logged_user["member_group_id"], $logged_user["notes"])) {
    deleteUserProperty($logged_user["id"], "whatsapp");
    deleteUserProperty($logged_user["id"], "telegram");
    deleteUserProperty($logged_user["id"], "logotipo");
    deleteUserProperty($logged_user["id"], "nomePainel");
    deleteUserProperty($logged_user["id"], "copyright");
    $result1 = addUserProperty($logged_user["id"], "whatsapp", $whatsapp);
    $result2 = addUserProperty($logged_user["id"], "telegram", $telegram);
    $result3 = addUserProperty($logged_user["id"], "logotipo", $logotipo);
    $result4 = addUserProperty($logged_user["id"], "nomePainel", $nomePainel);
    $result5 = addUserProperty($logged_user["id"], "copyright", $copyright);
    if ($result1 && $result2 && $result3 && $result4 && $result5) {
      header("location: ?result=success");
      exit;
    }
  }
}
?>
<!DOCTYPE html>
<html class="no-js css-menubar" lang="en">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
  <meta name="description" content="bootstrap admin template">
  <meta name="author" content="">

  <title> MEU PERFIL</title>

  <link rel="apple-touch-icon" href="temp/assets/images/apple-touch-icon.png">
  <link rel="shortcut icon" href="temp/assets/images/favicon.ico">

  <!-- Stylesheets -->
  <link rel="stylesheet" href="temp/global/css/bootstrap.min.css">
  <link rel="stylesheet" href="temp/global/css/bootstrap-extend.min.css">
  <link rel="stylesheet" href="temp/assets/css/site.min.css">

  <!-- Plugins -->
  <link rel="stylesheet" href="temp/global/vendor/animsition/animsition.css">
  <link rel="stylesheet" href="temp/global/vendor/asscrollable/asScrollable.css">
  <link rel="stylesheet" href="temp/global/vendor/switchery/switchery.css">
  <link rel="stylesheet" href="temp/global/vendor/intro-js/introjs.css">
  <link rel="stylesheet" href="temp/global/vendor/slidepanel/slidePanel.css">
  <link rel="stylesheet" href="temp/global/vendor/flag-icon-css/flag-icon.css">
  <link rel="stylesheet" href="temp/global/vendor/footable/footable.core.css">
  <link rel="stylesheet" href="temp/assets/examples/css/tables/footable.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.3/css/responsive.bootstrap.min.css">


  <!-- Fonts -->
  <link rel="stylesheet" href="temp/global/fonts/font-awesome/font-awesome.css">
  <link rel="stylesheet" href="temp/global/fonts/web-icons/web-icons.min.css">
  <link rel="stylesheet" href="temp/global/fonts/brand-icons/brand-icons.min.css">
  <link rel='stylesheet' href='http://fonts.googleapis.com/css?family=Roboto:300,400,500,300italic'>

  <link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">

  <!-- Scripts -->
  <script src="temp/global/vendor/breakpoints/breakpoints.js"></script>
  <script>
    Breakpoints();
  </script>
</head>
<?php 
include_once "./incluir/menu_lateral.php";
?>   


<!-- Page -->
<div class="page">
  <div class="page-header">
    <h1 class="page-title">Meus Dados - Editar</h1>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="/">Painel</a></li>
      <li class="breadcrumb-item active">Meus Dados - Editar</li>
    </ol>
    <div class="page-header-actions">

      <button type="button" class="btn btn-sm btn-icon btn-default btn-outline btn-round" data-toggle="tooltip" data-original-title="Refresh" id="goBack">
        <i class="icon wb-refresh" aria-hidden="true"></i>
      </button>

    </div>
  </div>

  <div class="page-content">
    <?php  
    if (isset($_GET["result"])) {
      $result = $_GET["result"];
      $result_message = "Aconteceu um problema, tente novamente mais tarde!";
      $result_type = "warning";
      switch ($result) {
        case "success":
        $result_message = "Os dados foram alterados com sucesso.";
        $result_type = "success";
        break;
        case "invalid_password":
        $result_message = "A senha escolhida é invalida!, deve ter no mínimo 6 caracteres.";
        break;
      }
      echo "            <div class=\"alert alert-";
      echo $result_type;
      echo " alert-dismissible\">\n              <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">×</button>\n              <i class=\"icon fa fa-check\"></i>\n              ";
      echo $result_message;
      echo "            </div>\n          ";
    }
    ?>
    <div class="panel">
      <div class="panel-body container-fluid">
        <div class="row row-lg">
          <div class="col-md-6">
            <!-- Example Basic Form (Form grid) -->
            <div class="example-wrap">

              <div class="example">
                <form autocomplete="off" id="validar" action="#" method="post" name="frm1">
                  <div class="row">

                    <div class="form-group col-md-12">
                      <h4 class="example-title">Você possui créditos: <b><?php echo $logged_user["credits"];?></b></h4>


                    </div>
                  </div>
                  <div class="row">

                  </div> <div class="row">

                    <div class="form-group col-md-6">
                      <label class="form-control-label" for="inputBasicFirstName"> Login</label>
                      <div class="input-group">
                        <div class="input-group-addon">
                          <i class="fa fa-user"></i>
                        </div>
                        <input type="text" class="form-control" id="inputBasicFirstName" placeholder="Login" autocomplete="off" value="<?php echo $logged_user['username'] ?>" name="username" required="" disabled>
                      </div>
                    </div>
                    <div class="form-group col-md-6">
                      <label class="form-control-label" for="inputBasicFirstName"> Senha</label>
                      <div class="input-group">
                        <div class="input-group-addon">
                          <i class="fa fa-unlock-alt"></i>
                        </div>
                        <input type="text" class="form-control" id="inputBasicLastName" placeholder="Preencha apenas caso queira alterar" autocomplete="off" value="" name="password">
                      </div>
                    </div>
                    <div class="form-group col-md-6">
                      <label class="form-control-label" for="inputBasicFirstName"> Email</label>
                      <div class="input-group">
                        <div class="input-group-addon">
                          <i class="fa fa-envelope"></i>
                        </div>
                        <input type="text" class="form-control" id="inputBasicFirstName" placeholder="Email" autocomplete="off" value="<?php echo $logged_user['email']; ?>" name="email" required="">
                      </div>
                    </div>
                    <div class="form-group col-md-6">
                      <label class="form-control-label" for="inputBasicFirstName"> WhatsApp</label>
                      <div class="input-group">
                        <div class="input-group-addon">
                          <i class="fa fa-whatsapp"></i>
                        </div>
                        <input type="text" class="form-control" id="inputBasicFirstName" placeholder="WhatsApp" autocomplete="off" value="<?php echo $whatsapp; ?>" name="whatsapp">
                      </div>
                    </div>
                    <div class="form-group col-md-6">
                      <label class="form-control-label" for="inputBasicFirstName"> Telegram</label>
                      <div class="input-group">
                        <div class="input-group-addon">
                          <i class="fa fa-telegram"></i>
                        </div>
                        <input type="text" class="form-control" id="inputBasicFirstName" placeholder="Telegram" autocomplete="off" value="<?php echo $telegram; ?>" name="telegram">
                      </div>
                    </div>
                    <div class="form-group col-md-6">
                      <label class="form-control-label" for="inputBasicFirstName"> URL da sua logotipo</label>
                      <div class="input-group">
                        <div class="input-group-addon">
                          <i class="fa fa-life-ring"></i>
                        </div>
                        <input type="text" class="form-control" id="inputBasicFirstName" placeholder="Endereço URL da sua logotipo" autocomplete="off" value="<?php echo $logotipo; ?>" name="logotipo">
                      </div>
                    </div>
                    <div class="form-group col-md-6">
                      <label class="form-control-label" for="inputBasicFirstName"> Nome painel personalizado</label>
                      <div class="input-group">
                        <div class="input-group-addon">
                          <i class="fa fa-text-height"></i>
                        </div>
                        <input type="text" class="form-control" id="inputBasicLastName" placeholder="Nome do seu IPTV" autocomplete="off" value="<?php echo $titulo; ?>" name="nome-painel">
                      </div>
                    </div>
                    <div class="form-group col-md-6">
                      <label class="form-control-label" for="inputBasicFirstName"> Copyright personalizado</label>
                      <div class="input-group">
                        <div class="input-group-addon">
                          <i class="fa fa-text-height"></i>
                        </div>
                        <input type="text" class="form-control" id="inputBasicFirstName" placeholder="Direitos autorais" autocomplete="off" value="<?php echo $copyright; ?>" name="copyright">
                      </div>
                    </div>
                  </div>
                  <div class="form-group">
                    <button type="submit" class="btn btn-primary">Editar Dados</button>
                  </div>
                </form>
              </div>
            </div>
            <!-- End Example Basic Form (Form grid) -->
          </div>
          <!-- End Example Striped Rows -->
        </div>
      </div>
    </div>
  </div>


</div>
</div>
<!-- End Page -->


<!-- Footer -->
<footer class="site-footer">
  <?php 
  include_once "./incluir/footer.php";
  ?>
</footer>
<!-- Core  -->
<script src="temp/global/vendor/babel-external-helpers/babel-external-helpers.js"></script>
<script src="temp/global/vendor/jquery/jquery.js"></script>
<script src="temp/global/vendor/popper-js/umd/popper.min.js"></script>
<script src="temp/global/vendor/bootstrap/bootstrap.js"></script>
<script src="temp/global/vendor/animsition/animsition.js"></script>
<script src="temp/global/vendor/mousewheel/jquery.mousewheel.js"></script>
<script src="temp/global/vendor/asscrollbar/jquery-asScrollbar.js"></script>
<script src="temp/global/vendor/asscrollable/jquery-asScrollable.js"></script>
<script src="temp/global/vendor/ashoverscroll/jquery-asHoverScroll.js"></script>

<!-- Plugins -->
<script src="temp/global/vendor/switchery/switchery.js"></script>
<script src="temp/global/vendor/intro-js/intro.js"></script>
<script src="temp/global/vendor/screenfull/screenfull.js"></script>
<script src="temp/global/vendor/slidepanel/jquery-slidePanel.js"></script>
<script src="temp/global/vendor/moment/moment.min.js"></script>
<script src="temp/global/vendor/footable/footable.min.js"></script>

<!-- Scripts -->
<script src="temp/global/js/Component.js"></script>
<script src="temp/global/js/Plugin.js"></script>
<script src="temp/global/js/Base.js"></script>
<script src="temp/global/js/Config.js"></script>

<script src="temp/assets/js/Section/Menubar.js"></script>
<script src="temp/assets/js/Section/GridMenu.js"></script>
<script src="temp/assets/js/Section/Sidebar.js"></script>
<script src="temp/assets/js/Section/PageAside.js"></script>
<script src="temp/assets/js/Plugin/menu.js"></script>

<script src="temp/global/js/config/colors.js"></script>
<script src="temp/assets/js/config/tour.js"></script>
<script>Config.set('assets', 'temp/assets');</script>

<!-- Page -->
<script src="temp/assets/js/Site.js"></script>
<script src="temp/global/js/Plugin/asscrollable.js"></script>
<script src="temp/global/js/Plugin/slidepanel.js"></script>
<script src="temp/global/js/Plugin/switchery.js"></script>

<script src="temp/assets/examples/js/tables/footable.js"></script>

<script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/fixedheader/3.1.5/js/dataTables.fixedHeader.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.2.3/js/dataTables.responsive.min.js"></script>
</body>
</html>
