<?php

include_once './system/functions.php';

// Se o MAC for enviado pelo formulário
if (isset($_POST['mac'])) {
    $mac = strtoupper($_POST['mac']);
    
    // Função que busca as informações pelo MAC
    $client_info = getClientByMac($mac);
    
    if ($client_info) {
        $result_message = "Informações encontradas:
            <br>✅ | MAC: " . $client_info['username'] . "
            <br>✅ | Usuário: " . $client_info['username_'] . "
            <br>✅ | Senha: " . $client_info['password'] . "
            <br>✅ | Expiração: " . $client_info['exp_date'];
    } else {
        $result_message = "Nenhum cliente encontrado com esse MAC.";
    }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Consultar Cliente por MAC</title>

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="temp/global/css/bootstrap.min.css">
    <link rel="stylesheet" href="temp/global/css/bootstrap-extend.min.css">
    <link rel="stylesheet" href="temp/assets/css/site.min.css">

    <!-- Custom CSS -->
    <style>
        body {
            background-color: #a13b00; /* Cor de fundo cinza */
            /*background-image: url('path/to/your/fire-background-image.jpg');*/ /* Altere para o caminho correto da imagem */
            background-size: cover;
            background-position: center;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        
        .login-box {
            background-color: #1c1c1c;
            border-radius: 10px;
            padding: 30px;
            width: 100%;
            max-width: 400px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.5);
        }

        .login-box h1 {
            color: #ff5d00;
            text-align: center;
            margin-bottom: 20px;
        }

        .login-box .form-group label {
            color: #fff;
        }

        .login-box .btn-primary {
            background-color: #ff5d00;
            border-color: #ff5d00;
        }

        .login-box .alert {
            margin-top: 20px;
        }

        .login-box .site-footer {
            color: #fff;
            text-align: center;
            margin-top: 15px;
        }
    </style>
</head>
<body>

    <div class="login-box">
        <h1>Meu Plano</h1>
        
        <form action="#" method="post">
            <div class="form-group">
                <label for="mac">Endereço MAC:</label>
                <input type="text" class="form-control" name="mac" required placeholder="Digite seu MAC" minlength="12" maxlength="12">
                <small class="form-text text-muted">O MAC deve ter exatamente 12 caracteres.</small>
            </div>
            <button type="submit" class="btn btn-primary btn-block">Consultar</button>
        </form>

        <!-- Exibe a mensagem com o resultado -->
        <?php if (isset($result_message)): ?>
            <div class="alert alert-info">
                <?= $result_message ?>
            </div>
        <?php endif; ?>

        <div class="site-footer">
            <p>© 2024 MyTv</p>
        </div>
    </div>

    <!-- Scripts -->
    <script src="temp/global/vendor/jquery/jquery.js"></script>
    <script src="temp/global/vendor/bootstrap/bootstrap.js"></script>
</body>
</html>
