<?php

include_once './system/functions.php';
isLogged();
$logged_user = getLoggedUser();
if (!isAdmin($logged_user) && getServerProperty("manutencaoPainel", 0)) {
    header("Location: ./sair.php");
    exit();
}
$server_name = getServerProperty("server_name");
$logotipo = getUserProperty($logged_user['id'], "logotipo");
$titulo = getUserProperty($logged_user['id'], "nomePainel");
$copyright = getUserProperty($logged_user['id'], "copyright");

?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>GERENCIADOR</title>
    <link rel="shortcut icon" href="temp/assets/images/favicon.ico">
    <link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700|Roboto+Slab:400,700|Material+Icons">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/latest/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/css/bootstrap.min.css">
    <link rel="stylesheet" href="temp/assets/css/style.css">
</head>

<body>
    <div class="image-container set-full-height" style="background-image: url('./temp/assets/images/bac.svg')">
        <!-- Creative Tim Branding -->
        <a>
            <div class="logo-container">
                <div class="logo">
                    <img src="<?php echo !empty($logotipo) ? $logotipo : LOGOTIPO_PAINEL ?>">
                </div>
                <div class="brand">
                    <?php echo !empty($titulo) ? $titulo : LOGOTIPO_NOME_PAINEL ?>
                </div>
            </div>
        </a>

        <!-- Made With Material Kit -->
        <a href="dash.php" class="made-with-mk">
            <div class="brand">XX</div>
            <div class="made-with"><strong>Voltar inicio</strong></div>
        </a>

        <!-- Big container -->
        <div class="container">
            <div class="row">
                <div class="col-sm-8 col-sm-offset-2">
                    <!-- Wizard container -->
                    <div class="wizard-container">
                        <div class="card wizard-card" data-color="red" id="wizard">
                            <form action="" method="POST">
                                <!-- Wizard header -->
                                <div class="wizard-header">
                                    <h3 class="wizard-title">Comprar créditos</h3>
                                    <h5>Recarregue seu painel automaticamente</h5>
                                </div>
                                <!-- Wizard navigation -->
                                <div class="wizard-navigation">
                                    <ul>
                                        <li><a href="#details" data-toggle="tab">Quantidade</a></li>
                                        <li><a href="#captain" data-toggle="tab">Forma de pagamento</a></li>
                                        <li><a href="#description" data-toggle="tab">Finalizar</a></li>
                                    </ul>
                                </div>
                                <!-- Tab content -->
                                <div class="tab-content">
                                    <div class="tab-pane" id="details">
                                        <h4 class="info-text">Escolha a quantidade de créditos</h4>
                                        <div class="row">
                                            <div class="col-sm-10 col-sm-offset-1">
                                                <div class="col-sm-4">
                                                    <div class="choice" data-toggle="wizard-radio">
                                                        <input class="form-control" name="qnt" id="qnt" type="number" value="0" min="0" max="9999" step="1"/>
                                                        <h6>Quantidade de créditos</h6>
                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="choice" data-toggle="wizard-radio">
                                                        <input class="form-control" name="total" id="total" readonly="readonly" type="text"/>
                                                        <h6>Total da compra</h6>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="captain">
                                        <h4 class="info-text">Qual a sua forma de pagamento?</h4>
                                        <div class="row">
                                            <div class="col-sm-10 col-sm-offset-1">
                                                <div class="col-sm-4">
                                                    <div class="choice" data-toggle="wizard-radio" rel="tooltip" title="Boletos, Cartão ou Lotérica">
                                                        <input type="radio" name="payment_method" value="mercado_pago">
                                                        <div class="icon">
                                                            <span class="avatar avatar-online">
                                                                <i>
                                                                    <img src="./temp/assets/images/mercadopago.png" alt="Mercado Pago">
                                                                </i>
                                                            </span>
                                                        </div>
                                                        <h6>Mercado Pago</h6>
                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="choice" data-toggle="wizard-radio" rel="tooltip" title="Boletos ou Cartão">
                                                        <input type="radio" name="payment_method" value="pagseguro">
                                                        <div class="icon">
                                                            <span class="avatar avatar-online">
                                                                <i>
                                                                    <img src="./temp/assets/images/pagseguro.png" alt="PagSeguro">
                                                                </i>
                                                            </span>
                                                        </div>
                                                        <h6>PagSeguro</h6>
                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="choice" data-toggle="wizard-radio" rel="tooltip" title="Boletos ou Cartão">
                                                        <input type="radio" name="payment_method" value="picpay">
                                                        <div class="icon">
                                                            <span class="avatar avatar-online">
                                                                <i>
                                                                    <img src="./temp/assets/images/picpay.png" alt="PicPay">
                                                                </i>
                                                            </span>
                                                        </div>
                                                        <h6>PicPay</h6>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="description">
                                        <div class="row">
                                            <h4 class="info-text">Deixe-nos uma pequena descrição.</h4>
                                            <div class="col-sm-6 col-sm-offset-1">
                                                <div class="form-group">
                                                    <label>Descrição</label>
                                                    <textarea class="form-control" placeholder="" rows="6"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label class="control-label">Exemplo</label>
                                                    <p class="description">"O nome do quarto realmente bonito é reconhecido como sendo um quarto realmente incrível. Usamos todos os domingos quando vamos pescar e pescamos muito. Tem algum tipo de escudo mágico ao seu redor."</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Wizard footer -->
                                <div class="wizard-footer">
                                    <div class="pull-right">
                                        <input type='button' class='btn btn-next btn-fill btn-danger btn-wd' name='next' value='Next' />
                                        <input type='button' class='btn btn-finish btn-fill btn-danger btn-wd' name='finish' value='Finish' />
                                    </div>
                                    <div class="pull-left">
                                        <input type='button' class='btn btn-previous btn-fill btn-default btn-wd' name='previous' value='Previous' />
                                    </div>
                                    <div class="clearfix"></div>
                                </div>
                            </form>
                        </div>
                    </div> <!-- wizard container -->
                </div>
            </div> <!-- row -->
        </div> <!-- big container -->

        <div class="footer">
            <div class="container text-center">
                <p><?php if(!empty($copyright)){echo $copyright;}else{echo "Reservado a i9 - Team";} ?></p>
                <p>© <?php echo date("Y"); ?>. All RIGHTS RESERVED.</p>
            </div>
        </div>
    </div>

    <!-- Core JS Files -->
    <script src='https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.0/jquery.min.js'></script>
    <script src='https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.7/js/bootstrap.min.js'></script>
    <script src="temp/assets/js/index.js"></script>
    <script src="temp/assets/js/bootstrap-input-spinner.js"></script>
    <script>

<script>
    // Função para alternar entre as abas
    $(document).ready(function () {
        // Função para mostrar a aba ativa
        function showTab(tabId) {
            $('.tab-pane').removeClass('active');
            $(tabId).addClass('active');
            $('.wizard-navigation li').removeClass('active');
            $('a[href="' + tabId + '"]').parent().addClass('active');
        }

        // Navegação entre abas
        $('.btn-next').click(function () {
            var activeTab = $('.tab-pane.active');
            var nextTab = activeTab.next('.tab-pane');
            if (nextTab.length) {
                showTab(nextTab.attr('id'));
            }
        });

        $('.btn-previous').click(function () {
            var activeTab = $('.tab-pane.active');
            var prevTab = activeTab.prev('.tab-pane');
            if (prevTab.length) {
                showTab(prevTab.attr('id'));
            }
        });

        // Inicializa o primeiro passo como ativo
        showTab('#details');
    });

    // Funções para cálculos e formatação de valores
    function id(el) {
        return document.getElementById(el);
    }

    function total(un, qnt) {
        return parseFloat(un.replace(',', '.'), 10) * parseFloat(qnt.replace(',', '.'), 10);
    }

    window.onload = function () {
        id('valor_unitario').addEventListener('keyup', function () {
            var result = total(this.value, id('qnt').value);
            id('total').value = String(result.toFixed(2)).formatMoney();
        });

        id('qnt').addEventListener('keyup', function () {
            var result = total(id('valor_unitario').value, this.value);
            id('total').value = String(result.toFixed(2)).formatMoney();
        });
    }

    String.prototype.formatMoney = function () {
        var v = this;

        if (v.indexOf('.') === -1) {
            v = v.replace(/([\d]+)/, "$1,00");
        }

        v = v.replace(/([\d]+)\.([\d]{1})$/, "$1,$20");
        v = v.replace(/([\d]+)\.([\d]{2})$/, "$1,$2");
        v = v.replace(/([\d]+)([\d]{3}),([\d]{2})$/, "$1.$2,$3");

        return isNaN(v[0]) ? '' : v;
    };
</script>
