<?php

include_once './system/functions.php';
isLogged();
$logged_user = getLoggedUser();
if (!isAdmin($logged_user) && getServerProperty("manutencaoPainel", 0)) {
  header("Location: ./sair.php");
  exit();
}
if (!isAdmin($logged_user) && !isUltra($logged_user) && !isMaster($logged_user) && !isReseller($logged_user)) {
  header("Location: ./index.php");
  exit;
}
$server_name = getServerProperty("server_name");
$fast_packages = json_decode(getServerProperty("fast_packages"), true);
$logotipo = getUserProperty($logged_user['id'], "logotipo");
$titulo = getUserProperty($logged_user['id'], "nomePainel");
$copyright = getUserProperty($logged_user['id'], "copyright");
?>
<!DOCTYPE html>
<html class="no-js css-menubar" lang="en">
<head>
  <style type="text/css">
    .paragrafo1{

      color: #ff0000;

    }
  </style>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
  <meta name="description" content="bootstrap admin template">
  <meta name="author" content="">

  <title> GERENCIADOR</title>

  <link rel="apple-touch-icon" href="temp/assets/images/apple-touch-icon.png">
  <link rel="shortcut icon" href="temp/assets/images/favicon.ico">

  <!-- Stylesheets -->
  <link rel="stylesheet" href="temp/global/css/bootstrap.min.css">
  <link rel="stylesheet" href="temp/global/css/bootstrap-extend.min.css">
  <link rel="stylesheet" href="temp/assets/css/site.min.css">
  <link rel="stylesheet" href="temp/assets/css/responsive.bootstrap.min.css">
  <link rel="stylesheet" type="text/css" href="temp/assets/css/responsive.dataTables.min.css"/>



  <!-- Plugins -->
  <link rel="stylesheet" href="temp/global/vendor/animsition/animsition.css">
  <link rel="stylesheet" href="temp/global/vendor/asscrollable/asScrollable.css">
  <link rel="stylesheet" href="temp/global/vendor/switchery/switchery.css">
  <link rel="stylesheet" href="temp/global/vendor/intro-js/introjs.css">
  <link rel="stylesheet" href="temp/global/vendor/slidepanel/slidePanel.css">
  <link rel="stylesheet" href="temp/global/vendor/flag-icon-css/flag-icon.css">
  <link rel="stylesheet" href="temp/global/vendor/footable/footable.core.css">
  <link rel="stylesheet" href="temp/assets/examples/css/tables/footable.css">


  <!-- Fonts -->
  <link rel="stylesheet" href="temp/global/fonts/font-awesome/font-awesome.css">
  <link rel="stylesheet" href="temp/global/fonts/web-icons/web-icons.min.css">
  <link rel="stylesheet" href="temp/global/fonts/brand-icons/brand-icons.min.css">
  <link rel='stylesheet' href='http://fonts.googleapis.com/css?family=Roboto:300,400,500,300italic'>
  <link rel="stylesheet" href="temp/assets/css/datatablesEdit.min.css">


  <!-- Scripts -->
  <script src="temp/global/vendor/breakpoints/breakpoints.js"></script>
  <script>
    Breakpoints();
  </script>
</head>
<?php 
include_once "./incluir/menu_lateral.php";
?>


<!-- Page -->
<!-- Page -->
<div class="page">
  <div class="page-header">
    <h1 class="page-title">Gerenciar todos revendedores</h1>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="/">Painel</a></li>

      <li class="breadcrumb-item active">Todos revendedores</li>
    </ol>
    <div class="page-header-actions">

    </div>
  </div>

  <div class="page-content container-fluid">
    <?php 
    if (isset($_GET["result"])) {
      $result = $_GET["result"];
      $result_message = "Aconteceu um problema, tente novamente mais tarde!";
      $result_type = "warning";
      switch ($result) {
        case "test_created":
        $result_message = "O teste rápido foi criado com sucesso.";
        $result_type = "success";
        break;
        case "no_min_credits":
        $result_message = "Você não tem a quantidade minima de créditos para criar o teste rápido.";
        break;
      }
      echo "            <div class=\"alert alert-";
      echo $result_type;
      echo " alert-dismissible\">\n              <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-hidden=\"true\">×</button>\n              <i class=\"icon fa fa-check\"></i>\n              ";
      echo $result_message;
      echo "            </div>\n          ";
    }
    ?>
    <div class="row">
      <div class="col-xl-12">
       <!-- Panel Row Toggler -->
       <div class="panel">
        <header class="panel-heading">
          <h3 class="panel-title"></h3>
        </header>
        <div class="panel-body">
          <table class="table table-striped table-hover toggle-circle" id="exampleRowToggler">
          </table>
        </div>
      </div>
    </div>

  </div>
</div>
</div>
</div>
<!-- End Page -->


<!-- Footer -->
<footer class="site-footer">
  <?php 
  include_once "./incluir/footer.php";
  ?>
</footer>
<!-- Core  -->
<script src="temp/global/vendor/babel-external-helpers/babel-external-helpers.js"></script>
<script src="temp/global/vendor/jquery/jquery.js"></script>
<script src="temp/global/vendor/popper-js/umd/popper.min.js"></script>
<script src="temp/global/vendor/bootstrap/bootstrap.js"></script>
<script src="temp/global/vendor/animsition/animsition.js"></script>
<script src="temp/global/vendor/mousewheel/jquery.mousewheel.js"></script>
<script src="temp/global/vendor/asscrollbar/jquery-asScrollbar.js"></script>
<script src="temp/global/vendor/asscrollable/jquery-asScrollable.js"></script>
<script src="temp/global/vendor/ashoverscroll/jquery-asHoverScroll.js"></script>

<!-- Plugins -->
<script src="temp/global/vendor/switchery/switchery.js"></script>
<script src="temp/global/vendor/intro-js/intro.js"></script>
<script src="temp/global/vendor/screenfull/screenfull.js"></script>
<script src="temp/global/vendor/slidepanel/jquery-slidePanel.js"></script>
<script src="temp/global/vendor/moment/moment.min.js"></script>
<script src="temp/global/vendor/footable/footable.min.js"></script>

<!-- Scripts -->
<script src="temp/global/js/Component.js"></script>
<script src="temp/global/js/Plugin.js"></script>
<script src="temp/global/js/Base.js"></script>
<script src="temp/global/js/Config.js"></script>

<script src="temp/assets/js/Section/Menubar.js"></script>
<script src="temp/assets/js/Section/GridMenu.js"></script>
<script src="temp/assets/js/Section/Sidebar.js"></script>
<script src="temp/assets/js/Section/PageAside.js"></script>
<script src="temp/assets/js/Plugin/menu.js"></script>

<script src="temp/global/js/config/colors.js"></script>
<script src="temp/assets/js/config/tour.js"></script>
<script>Config.set('assets', 'temp/assets');</script>

<!-- Page -->
<script src="temp/assets/js/Site.js"></script>
<script src="temp/global/js/Plugin/asscrollable.js"></script>
<script src="temp/global/js/Plugin/slidepanel.js"></script>
<script src="temp/global/js/Plugin/switchery.js"></script>

<script src="temp/assets/examples/js/tables/footable.js"></script>
<script src="temp/assets/js/bootbox.js"></script>
<script src="temp/assets/js/bootbox.min.js"></script>

<script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>

<script src="https://cdn.datatables.net/responsive/2.2.3/js/dataTables.responsive.min.js"></script>
<script type="text/javascript">
  $(function () {
    var table = $('#exampleRowToggler').DataTable({
      "ajax": '<?= $base_url; ?>' + "system/API.php?action=get_resellers",
      "processing": true,
      "serverSide": true,
      "columns": [ { 'data': null },
      {"data": "id","title":"ID"},
      {"data": "username","title":"Login"},
      {"data": "email","title":"Email"},
      {"data": "date_registered","title":"Adicionado"},
      {"data": "ip","title":"IP"},
      {"data": "credits","title":"Créditos"},
      {"data": "reseller_notes","title":"Notas"},
      {"data": "reseller_name","title":"Master"},
      {"data": "status","title":"Status"},
      {"data": "action","title":"Ações","width": "700px",}
      ],  
      'responsive': {
        'details': {
          'type': 'column',
          'target': 0
        }
      },
      'columnDefs': [
      {
        'data': null,
        'defaultContent': '',
        'className': 'control',
        'orderable': false,
        'targets': 0
      }
      ],
      'select': {
        'style': 'multi',
        'selector': 'td:not(.control)'
      },        
      "order": [[ 0, "desc" ]],
      "paging": true,
      "lengthChange": true,
      "searching": true,
      "ordering": true,
      "orderMulti": false,
      "info": true,
      "autoWidth": false,
      "language": {
        "processing": "Processando...",
        "lengthMenu": "Mostrar _MENU_ registros",
        "zeroRecords": "Não foram encontrados resultados",
        "info": "Mostrando de _START_ até _END_ de _TOTAL_ registros",
        "infoEmpty": "Mostrando de 0 até 0 de 0 registros",
        "sInfoFiltered": "",
        "sInfoPostFix": "",
        "search": "Buscar:",
        "url": "",
        "loadingRecords": "Carregando...",
        "paginate": {
          "first": "Primeiro",
          "previous": "Anterior",
          "next": "Seguinte",
          "last": "Último"
        }
      }, "drawCallback": function () {
        $('[data-toggle="tooltip"]').tooltip();
      }, "createdRow": function (row, data) {
        if (data['status'].includes('Expirado')) {
          $(row).addClass('text-red');
        }
      }
    });

    /* ADICIONAR/REMOVER CREDITOS */
    $(document).on('click', '.btcredits', function (e) {
      e.preventDefault();
      const id = $(this).data("id");
      bootbox.dialog({
        title: "Adic/Remover créditos",
        message: '<p>'+$(this).data("text")+'</p><form class="form-horizontal">' + '<div class="form-group col-md-12"><label class="form-control-label"><b>Quantidade de créditos</b></label><div class="input-group"><span class="input-group-addon"><i class="fa fa-dollar"></i></span><input type="number" class="form-control" required="" value="0" autocomplete="off" id="credits" name="credits"></div><label class="form-control-label"><b>Informações da recarga</b></label><textarea class="form-control" placeholder="Adicione informações relevantes" id="credits_notes" name="credits_notes" value=""></textarea></div>' + '<div class="form-group row">' + '<div class="col-md-12"><span class="text-blue">Escolha a quantidade de créditos.<br><b>*Para retirar créditos coloque o sinal de menos na frente.</b></span></div>' + '</div></form>',
        buttons: {
          cancel: {
            label: "Cancelar",
            className: 'btn-danger',
            callback: function () {
            }
          },
          noclose: {
            label: "Confirmar",
            className: 'btn-success btncredits',
            callback: function () {
              $('.btncredits').hide();

              const credits = $('#credits').val();
              const creditsnotes = $('#credits_notes').val();

              $.get('<?= $base_url; ?>' + 'system/API.php?action=change_credits&reseller_id=' + id + '&credits=' + credits +'&notas='+ creditsnotes, function (data) {
                if (data.result === 'success') {
                  table.ajax.reload();
                  messageConfirm('Os créditos foram adicionados/removidos com sucesso!');
                } else {
                  messageConfirm('Não foi possível adicionar/remover os créditos, verifique se a quantia é válida.');
                }
              }, "json");
            }
          },
        }
      });
    });


    /* BLOQUEAR/DESBLOQUEAR */
    $(document).on('click', '.btblock', function (e) {
      e.preventDefault();
      const id = $(this).data("id");
      bootbox.dialog({
        title: "Tem certeza que deseja bloquear/desbloquear este revendedor ?",
        message: "<p>" + $(this).data("text") + "</p>",
        buttons: {
          cancel: {
            label: "Cancelar",
            className: 'btn-danger',
            callback: function () {
            }
          },
          noclose: {
            label: "Confirmar",
            className: 'btn-success btnblock',
            callback: function () {
              $('.btnblock').hide();
              $.get('<?= $base_url; ?>' + 'system/API.php?action=toggle_block_reseller&reseller_id=' + id, function (data) {
                if (data.result === 'success') {
                  table.ajax.reload();
                  messageConfirm('Revendedor bloqueado/desbloqueado com sucesso!');
                } else {
                  messageConfirm('Não foi possível bloquear/desbloquear este revendedor.');
                }
              }, "json");
            }
          },
        }
      });
    });

    /* DELETAR */
    $(document).on('click', '.btdelete', function (e) {
      e.preventDefault();
      const id = $(this).data("id");
      bootbox.dialog({
        title: "Tem certeza que deseja deletar esta revenda ?",
        message: "<p>" + $(this).data("text") + "</p>",
        buttons: {
          cancel: {
            label: "Cancelar",
            className: 'btn-danger',
            callback: function () {
            }
          },
          noclose: {
            label: "Confirmar",
            className: 'btn-success btndelete',
            callback: function () {
              $('.btndelete').hide();
              $.get('<?= $base_url; ?>' + 'system/API.php?action=delete_reseller&reseller_id=' + id, function (data) {
                if (data.result === 'success') {
                  table.ajax.reload();
                  messageConfirm('Revendedor deletado com sucesso!');
                } else {
                  messageConfirm('Não foi possível deletar este revendedor.');
                }
              }, "json");
            }
          },
        }
      });
    });
  });

function messageConfirm(msg){
  bootbox.confirm(msg, function(result){ 
  });
}



</script>
<script type="text/javascript">

  $.ajax({
    statusCode: {
      500: function() {
        console.log(versao-assincrona.php?var1&var2...);
      }
    }
  });
</script>
</body>
</html>
