<?php

ini_set("log_errors", 1);

if (debugEnabled()) {
    error_reporting(0);
    ini_set("display_errors", 0);
} else {
    error_reporting(0);
    ini_set("display_errors", 0);
}
date_default_timezone_set('America/Sao_Paulo');
if (file_exists(__DIR__ . "/config.php")) {
    include_once __DIR__ . "/config.php";
}
class DB
{
    private $connection = NULL;
    private static $_instance = NULL;
    public static function getInstance()
    {
        if (!self::$_instance) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }
    private function __clone()
    {
    }
    public function getConnection($db_host, $db_port, $db_name, $db_user, $db_pass)
    {
        $con_name = $db_host . "_" . $db_name;
        try {
            if (!isset($this->connection[$con_name])) {
                $this->connection[$con_name] = new PDO("mysql:host=" . $db_host . ";port=" . $db_port . ";dbname=" . $db_name . ";charset=utf8", $db_user, $db_pass, array(PDO::ATTR_PERSISTENT => true, PDO::ATTR_TIMEOUT => 5));
                $this->connection[$con_name]->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            }
        } catch (PDOException $e) {
            if (debugEnabled()) {
                exit("Failed to connect to DB: " . $e->getMessage());
            }
            return NULL;
        } catch (Exception $d) {
            if (debugEnabled()) {
                exit("Failed to connect to DB: " . $d->getMessage());
            }
            return NULL;
        }
        return $this->connection[$con_name];
    }
}

function getConnection()
{
    return DB::getInstance()->getConnection(DB_HOST, DB_PORT, DB_NAME, DB_USER, DB_PASS);
}
function getOfficeConnection()
{
    return DB::getInstance()->getConnection(OFFICE_DB_HOST, OFFICE_DB_PORT, OFFICE_DB_NAME, OFFICE_DB_USER, OFFICE_DB_PASS);
}
function startSession()
{
    if (session_status() == PHP_SESSION_NONE) {
        session_start();
    }
}
function isLogged($destination = "./index.php")
{
    startsession();
    if (!isset($_SESSION["__l0gg3d_us3r__"])) {
        header("Location: " . $destination);
        exit;
    }
}
function loginUser($username, $password)
{
    $crypted_password = cryptPassword($password, "xtreamcodes");
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `reg_users` WHERE `username` = :username AND `password` LIKE :password LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":username", $username, PDO::PARAM_STR, 50);
        $stmt->bindParam(":password", $crypted_password, PDO::PARAM_STR, 255);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($result) {
            if ($result["status"] == 1) {
                $allowed_groups = json_decode(getServerProperty("allowed_groups"), true);
                if (!in_array($result["member_group_id"], $allowed_groups)) {
                    return 5;
                }
                startsession();
                $_SESSION["__l0gg3d_us3r__"] = $result["id"];
                return 1;
            }
            return 4;
        }else{
            $bar = '/';
            $XCStreamHostUrl = DNS_XTREAM_CODES;
            if (substr($XCStreamHostUrl, -1) == '/') {
                $bar = '';
            }

            $XCStreamHostUrl = $XCStreamHostUrl . $bar;
            $UserName = $username;
            $UserPassword = $password;
            $returnData = array();
            $ApiLinkIs = $XCStreamHostUrl . 'player_api.php?username=' . $UserName . '&password=' . $UserPassword;
            $checkLogin = webtvpanel_CallApiRequest($ApiLinkIs);
            $CateGoriesArray = array();
            $Catechanneldata = array();
            $Result = $checkLogin;

            if ($Result['result'] == 'success') {
                if (isset($Result['data']->user_info->auth)) {
                    if ($Result['data']->user_info->auth != 0) {
                        if ($Result['data']->user_info->status == 'Active') {
                            if ($rememberMe == 'on') {
                                setcookie('username', $UserName, time() + (2 * 7 * 24 * 60 * 60), '/', $_SERVER['SERVER_NAME'], false);
                                setcookie('userpassword', base64_encode($UserPassword), time() + (2 * 7 * 24 * 60 * 60), '/', $_SERVER['SERVER_NAME'], false);
                            }

                            $SessionArray = array('username' => $Result['data']->user_info->username, 'password' => $Result['data']->user_info->password, 'auth' => $Result['data']->user_info->auth, 'status' => $Result['data']->user_info->status, 'exp_date' => $Result['data']->user_info->exp_date, 'active_cons' => $Result['data']->user_info->active_cons, 'is_trial' => $Result['data']->user_info->is_trial, 'max_connections' => $Result['data']->user_info->max_connections, 'created_at' => $Result['data']->user_info->created_at, 'allowed_output_formats' => $Result['data']->user_info->allowed_output_formats, 'url' => $Result['data']->server_info->url, 'port' => $Result['data']->server_info->port, 'rtmp_port' => $Result['data']->server_info->rtmp_port, 'timezone' => $Result['data']->server_info->timezone);
                            session_start();
                            $_SESSION['webTvplayer'] = $SessionArray;
                        }
                        else {
                            return 7;
                        }
                    }
                    else {
                        return 8;
                    }
                }
                else {
                    return 9;
                }
            }
            else {
                $returnData = array('result' => 'error', 'message' => $Result['data']);
            }

            echo json_encode($returnData);
            return 6;
        }
        return 3;
    }
    return 2;
}


//MAC PUXAR
function getClientByMac($mac) {
    // Obtém a conexão do banco de dados
    $db = getConnection();
    
    if ($db === null) {
        error_log("Erro: Não foi possível conectar ao banco de dados.");
        return null;
    }

    // Limpa o MAC removendo caracteres inválidos e convertendo para maiúsculas
    $mac = strtoupper(preg_replace('/[^A-Za-z0-9]/', '', $mac));

    try {
        // Prepara a consulta SQL para buscar os dados do cliente pelo MAC (armazenado em `username`)
        $query = $db->prepare("SELECT username_, password, FROM_UNIXTIME(exp_date) as exp_date, username FROM users WHERE username = :mac LIMIT 1");
        $query->bindParam(":mac", $mac);
        $query->execute();

        // Retorna os dados encontrados ou `false` se não encontrar
        return $query->fetch(PDO::FETCH_ASSOC);

    } catch (PDOException $e) {
        // Se houver algum erro com a consulta, registre-o no log de erros
        error_log("Erro ao buscar cliente por MAC: " . $e->getMessage());
        return null;
    }
}


function logoutUser()
{
    startsession();
    unset($_SESSION);
    SESSION_DESTROY();
    header("Location: ./../index.php");
}
function getUserByID($userid)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `reg_users` WHERE `id` = :userid LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":userid", $userid, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
    return false;
}
function getLoggedUser()
{
    startsession();
    $user = getuserbyid($_SESSION["__l0gg3d_us3r__"]);
    if ($user) {
        return $user;
    }
    logoutuser();
    exit;
}
function getUserByUsername($username)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `reg_users` WHERE `username` = :username LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":username", $username, PDO::PARAM_STR, 255);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
    return false;
}
function getUserByEmail($email)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `reg_users` WHERE `email` = :email LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":email", $email, PDO::PARAM_STR, 255);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
    return false;
}
function getAllUsers()
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `reg_users`;";
        $stmt = $PDO->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    return array();
}
function updateUser($user_id, $username, $password, $email, $member_group_id, $notes)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "UPDATE `reg_users` SET `username` = :username, `password` = :password, `email` = :email, `member_group_id` = :member_group_id, `notes` = :notes WHERE `id` = :user_id LIMIT 1;";
        if (empty($password)) {
            $sql = "UPDATE `reg_users` SET `username` = :username, `email` = :email, `member_group_id` = :member_group_id, `notes` = :notes WHERE `id` = :user_id LIMIT 1;";
        }
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":username", $username, PDO::PARAM_STR, 255);
        if (!empty($password)) {
            $password = cryptPassword($password, "xtreamcodes");
            $stmt->bindParam(":password", $password, PDO::PARAM_STR, 255);
        }
        $stmt->bindParam(":email", $email, PDO::PARAM_STR, 255);
        $stmt->bindParam(":member_group_id", $member_group_id, PDO::PARAM_INT);
        $stmt->bindParam(":notes", $notes, PDO::PARAM_STR);
        $stmt->bindParam(":user_id", $user_id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function deleteExpiredTestUsersByOwner($owner_id, $remove_expired, $remove_test, $start_date, $end_date)
{

    // var_dump($end_date); die();
    if (!$remove_expired && !$remove_test) {
        return false;
    }
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "DELETE FROM `users` WHERE `member_id` = :owner_id AND `created_at` >= :start_date AND `created_at` <= :end_date";
        if ($remove_expired) {
            $sql .= " AND unix_timestamp(NOW()) > `exp_date`";
        }
        if ($remove_test) {
            $sql .= " AND `is_trial` = 1";
        }
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":owner_id", $owner_id, PDO::PARAM_INT);
        $stmt->bindParam(":start_date", $start_date, PDO::PARAM_INT);
        $stmt->bindParam(":end_date", $end_date, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function transferResellers($resellers, $new_owner, $new_group)
{
    $PDO = getconnection();
    foreach ($resellers as $reseller_id) {
        $sql = "UPDATE `reg_users` SET `owner_id` = :owner_id WHERE `id` = :user_id LIMIT 1;";
        if ($new_group) {
            $sql = "UPDATE `reg_users` SET `member_group_id` = :member_group_id, `owner_id` = :owner_id WHERE `id` = :user_id LIMIT 1;";
        }
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":owner_id", $new_owner, PDO::PARAM_INT);
        if ($new_group) {
            $stmt->bindParam(":member_group_id", $new_group, PDO::PARAM_INT);
        }
        $stmt->bindParam(":user_id", $reseller_id, PDO::PARAM_INT);
        $stmt->execute();
    }
    return true;
}
function updateUserPassword($user_id, $password)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "UPDATE `reg_users` SET `password` = :password WHERE `id` = :user_id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $password = cryptPassword($password, "xtreamcodes");
        $stmt->bindParam(":password", $password, PDO::PARAM_STR, 255);
        $stmt->bindParam(":user_id", $user_id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function insertTest($email)
{
    $PDO = getofficeconnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO `test_historic` (`id`, `email`) VALUES (NULL, :email)";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":email", $email, PDO::PARAM_STR, 255);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function existTest($email)
{
    $PDO = getofficeconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT `id` FROM `test_historic` WHERE `email` LIKE :email;";
        $stmt = $PDO->prepare($sql);
        $email_ = "%" . $email . "%";
        $stmt->bindParam(":email", $email_, PDO::PARAM_STR, 255);
        $stmt->execute();
        if (0 < $stmt->rowCount()) {
            return true;
        }
    }
    return false;
}
function createFastTest($owner_id, $package_id)
{
    $package = getPackageByID($package_id);
    if ($package && $package["is_trial"]) {
        $username = random_str(10);
        $password = random_str(10);
        $duration = $package["trial_duration"] . " " . $package["trial_duration_in"];
        if (createClient($owner_id, $username, $password, $duration, $package["bouquets"], "Criado com office.")) {
            $reseller = getuserbyid($owner_id);
            if ($reseller) {
                insertRegUserLog($owner_id, $username, $password, "[<b>UserPanel</b> -> <u>New Line</u>] with Package [" . $package["package_name"] . "], Credits: <font color=\"green\">" . $reseller["credits"] . "</font> -> <font color=\"red\">" . $reseller["credits"] . "</font>");
            }
            return true;
        }
    }
    return false;
}
/*
function createClient($owner_id, $username, $password, $duration = "2 hours", $bouquet, $reseller_notes, $is_trial = 0, $mac = NULL)
{
    $exp_date = strtotime("+" . $duration);
    return insertClient($owner_id, $username, $password, $exp_date, "", $reseller_notes, $bouquet, $is_trial, $mac);
}
function insertClient($owner_id, $username, $password, $exp_date, $admin_notes, $reseller_notes, $bouquet, $is_trial, $mac)
{
    if (existClient($mac)) {
        return false;
    }
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO `users` (`id`, `member_id`, `username`, `password`, `exp_date`, `admin_notes`, `reseller_notes`, `bouquet`, `max_connections`, `username_`, `is_trial`, `created_at`, `created_by`) VALUES \r\n            (NULL, :owner_id, :username, :password, :exp_date, :admin_notes, :reseller_notes, :bouquet, :max_connections, :username_, :is_trial, unix_timestamp(NOW()), :owner_id);";
        $stmt = $PDO->prepare($sql);
        $apo = 1;
        $stmt->bindParam(":owner_id", $owner_id, PDO::PARAM_INT);
        $stmt->bindParam(":username", $mac, PDO::PARAM_STR, 255);
        $stmt->bindParam(":password", $password, PDO::PARAM_STR, 255);
        $stmt->bindParam(":exp_date", $exp_date, PDO::PARAM_INT);
        $stmt->bindParam(":admin_notes", $admin_notes, PDO::PARAM_STR, 500);
        $stmt->bindParam(":reseller_notes", $reseller_notes, PDO::PARAM_STR, 500);
        $stmt->bindParam(":bouquet", $bouquet, PDO::PARAM_STR);
         $stmt->bindParam(":max_connections", $apo, PDO::PARAM_INT);
        $stmt->bindParam(":username_", $username, PDO::PARAM_STR);
        $stmt->bindParam(":is_trial", $is_trial, PDO::PARAM_INT);
        if ($stmt->execute()) {
            $user_id = $PDO->lastInsertId();
            $sql = "INSERT INTO `user_output` (`id`, `user_id`, `access_output_id`) VALUES (NULL, :userid1, '1'), (NULL, :userid2, '2')";
            $stmt = $PDO->prepare($sql);
            $stmt->bindParam(":userid1", $user_id, PDO::PARAM_INT);
            $stmt->bindParam(":userid2", $user_id, PDO::PARAM_INT);
            if ($stmt->execute()) {
                return $user_id;
            }
        }
    }
    return false;
}*/
function createClient($owner_id, $username, $password, $duration = "2 hours", $bouquet, $reseller_notes, $is_trial = 0, $mac = NULL, $dns = NULL)
{
    $exp_date = strtotime("+" . $duration);
    return insertClient($owner_id, $username, $password, $exp_date, "", $reseller_notes, $bouquet, $is_trial, $mac, $dns);
}
function insertClient($owner_id, $username, $password, $exp_date, $admin_notes, $reseller_notes, $bouquet, $is_trial, $mac, $dns)
{
    if (existClient($mac)) {
        return false;
    }
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO `users` (`id`, `member_id`, `username`, `password`, `exp_date`, `admin_notes`, `reseller_notes`, `bouquet`, `max_connections`, `username_`, `is_trial`, `created_at`, `created_by`, `play_token`) 
                VALUES (NULL, :owner_id, :username, :password, :exp_date, :admin_notes, :reseller_notes, :bouquet, :max_connections, :username_, :is_trial, unix_timestamp(NOW()), :owner_id, :dns);";
        $stmt = $PDO->prepare($sql);
        $apo = 1;
        $stmt->bindParam(":owner_id", $owner_id, PDO::PARAM_INT);
        $stmt->bindParam(":username", $mac, PDO::PARAM_STR, 255);
        $stmt->bindParam(":password", $password, PDO::PARAM_STR, 255);
        $stmt->bindParam(":exp_date", $exp_date, PDO::PARAM_INT);
        $stmt->bindParam(":admin_notes", $admin_notes, PDO::PARAM_STR, 500);
        $stmt->bindParam(":reseller_notes", $reseller_notes, PDO::PARAM_STR, 500);
        $stmt->bindParam(":bouquet", $bouquet, PDO::PARAM_STR);
        $stmt->bindParam(":max_connections", $apo, PDO::PARAM_INT);
        $stmt->bindParam(":username_", $username, PDO::PARAM_STR);
        $stmt->bindParam(":is_trial", $is_trial, PDO::PARAM_INT);
        $stmt->bindParam(":dns", $dns, PDO::PARAM_STR); // Adiciona o DNS no SQL
        if ($stmt->execute()) {
            $user_id = $PDO->lastInsertId();
            $sql = "INSERT INTO `user_output` (`id`, `user_id`, `access_output_id`) VALUES (NULL, :userid1, '1'), (NULL, :userid2, '2')";
            $stmt = $PDO->prepare($sql);
            $stmt->bindParam(":userid1", $user_id, PDO::PARAM_INT);
            $stmt->bindParam(":userid2", $user_id, PDO::PARAM_INT);
            if ($stmt->execute()) {
                return $user_id;
            }
        }
    }
    return false;
}
function existClient($username)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT `id` FROM `users` WHERE `username` = :username;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":username", $username, PDO::PARAM_STR, 255);
        $stmt->execute();
        if (0 < $stmt->rowCount()) {
            return true;
        }
    }
    return false;
}
function getAllClients()
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `users` ORDER BY `id` DESC;";
        $stmt = $PDO->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    return array();
}


function getClientByID($client_id)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `users` WHERE `id` = :client_id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":client_id", $client_id, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
    return false;
}
function getAllClientsAdmin()
{
    $results = array();
    $all_clients = getallclients();
    $all_users = getallusers();
    foreach ($all_clients as $current_client) {
        $reseller_key = array_search($current_client["member_id"], array_column($all_users, "id"));
        $reseller_name = $reseller_key !== false ? $all_users[$reseller_key]["username"] : "Desconhecido!";
        $current_client["reseller_name"] = $reseller_name;
        $results[] = $current_client;
    }
    return $results;
}
function getAllClientsAdminWithOptions($start = 0, $length = 10, $columns = array(), $search_value = "", $order_column_index = NULL, $order_type = "asc")
{
    $result = array("data" => array(), "recordsTotal" => 0, "recordsFiltered" => 0);
    $all_clients = dataOutput($columns, getallclientsadmin());    
    if ($order_column_index !== NULL && isset($columns[$order_column_index]["db"])) {
        $order_column = $columns[$order_column_index]["db"];
        usort($all_clients, function ($a, $b) use($order_column, $order_type) {
            if ($a[$order_column] === $b[$order_column]) {
                return 0;
            }
            if ($order_type == "asc") {
                return strip_tags($b[$order_column]) < strip_tags($a[$order_column]) ? 1 : -1;
            }
            return strip_tags($a[$order_column]) < strip_tags($b[$order_column]) ? 1 : -1;
        });
    }
    $current_index = 0;
    foreach ($all_clients as $current_client) {
        if (tryFind($current_client, $columns, $search_value)) {
            if ($start <= $current_index && count($result["data"]) < $length) {
                $result["data"][] = $current_client;
            }
            $current_index++;
        }
    }
    $result["recordsTotal"] = count($all_clients);
    $result["recordsFiltered"] = $current_index;
    return $result;
}
function getAllClientsByOwner($user)
{
    $resellers = array($user["id"]);
    $resellers = array_merge($resellers, getAllResellersIdByOwnerID($user["id"]));
    $sql_select = "SELECT t1.*, t2.username as 'reseller_name' FROM `users` t1, `reg_users` t2 WHERE t1.member_id = t2.id AND t1.member_id IN (" . implode(",", $resellers) . ")";
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $total_sql = $sql_select;
        $stmt = $PDO->prepare($total_sql);
        $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($result) {
            return $result;
        }
    }
    return array();
}
function getAllClientsByOwnerWithOptions($user, $start = 0, $length = 10, $columns = array(), $search_value = "", $order_column_index = NULL, $order_type = "asc")
{
    $result = array("data" => array(), "recordsTotal" => 0, "recordsFiltered" => 0);
    $all_clients = dataOutput($columns, getallclientsbyowner($user));
    if ($order_column_index !== NULL && isset($columns[$order_column_index]["db"])) {
        $order_column = $columns[$order_column_index]["db"];
        usort($all_clients, function ($a, $b) use($order_column, $order_type) {
            if ($a[$order_column] === $b[$order_column]) {
                return 0;
            }
            if ($order_type == "asc") {
                return strip_tags($b[$order_column]) < strip_tags($a[$order_column]) ? 1 : -1;
            }
            return strip_tags($a[$order_column]) < strip_tags($b[$order_column]) ? 1 : -1;
        });
    }
    $current_index = 0;
    foreach ($all_clients as $current_client) {
        if (tryFind($current_client, $columns, $search_value)) {
            if ($start <= $current_index && count($result["data"]) < $length) {
                $result["data"][] = $current_client;
            }
            $current_index++;
        }
    }
    $result["recordsTotal"] = count($all_clients);
    $result["recordsFiltered"] = $current_index;
    return $result;
}
function tryFind($array = array(), $columns = array(), $search_value)
{
    if (empty($search_value)) {
        return true;
    }
    foreach ($columns as $current_column) {
        $searchable = isset($current_column["searchable"]) ? $current_column["searchable"] : true;
        if ($searchable) {
            $striped_db_value = strip_tags($array[$current_column["db"]]);
            if (stripos($striped_db_value, $search_value) !== false) {
                return true;
            }
        }
    }
    return false;
}
function dataOutput($columns, $data)
{
    $out = array();
    $i = 0;
    for ($ien = count($data); $i < $ien; $i++) {
        $row = array();
        $j = 0;
        for ($jen = count($columns); $j < $jen; $j++) {
            $column = $columns[$j];
            $db_value = isset($data[$i][$column["db"]]) ? $data[$i][$column["db"]] : "";
            if (isset($column["formatter"])) {
                $row[$column["db"]] = $column["formatter"]($db_value, $data[$i]);
            } else {
                $row[$column["db"]] = $db_value;
            }
        }
        $out[] = $row;
    }
    return $out;
}
function getClientsByOwnerID($userid)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `users` WHERE `member_id` = :userid;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":userid", $userid, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    return array();
}
function getAllOnlineClients()
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "select users.id, users.username, streams.stream_display_name as `stream_name`, streams.stream_icon, user_activity_now.user_ip, user_activity_now.date_start as `time`, user_activity_now.geoip_country_code as `country`, user_activity_now.isp as `internet_server` from users, user_activity_now, streams where users.id=user_activity_now.user_id and user_activity_now.stream_id = streams.id";
        $stmt = $PDO->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    return array();
}
function getAllOnlineClientsWithOptions($start = 0, $length = 10, $columns = array(), $search_value = "", $order_column_index = NULL, $order_type = "asc")
{
    $result = array("data" => array(), "recordsTotal" => 0, "recordsFiltered" => 0);
    $all_clients = dataoutput($columns, getallonlineclients());
    if ($order_column_index !== NULL && isset($columns[$order_column_index]["db"])) {
        $order_column = $columns[$order_column_index]["db"];
        usort($all_clients, function ($a, $b) use($order_column, $order_type) {
            if ($a[$order_column] === $b[$order_column]) {
                return 0;
            }
            if ($order_type == "asc") {
                return strip_tags($b[$order_column]) < strip_tags($a[$order_column]) ? 1 : -1;
            }
            return strip_tags($a[$order_column]) < strip_tags($b[$order_column]) ? 1 : -1;
        });
    }
    $current_index = 0;
    foreach ($all_clients as $current_client) {
        if (tryfind($current_client, $columns, $search_value)) {
            if ($start <= $current_index && count($result["data"]) < $length) {
                $result["data"][] = $current_client;
            }
            $current_index++;
        }
    }
    $result["recordsTotal"] = count($all_clients);
    $result["recordsFiltered"] = $current_index;
    return $result;
}
function getAllOnlineClientsByOwnerID($userid)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "select users.id, users.username, streams.stream_display_name as `stream_name`, user_activity_now.user_ip, user_activity_now.date_start as `time`,user_activity_now.geoip_country_code as `country`, user_activity_now.isp as `internet_server` from users, user_activity_now, streams where users.id=user_activity_now.user_id and user_activity_now.stream_id = streams.id and users.member_id = :userid";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":userid", $userid, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    return array();
}
function getAllOnlineClientsByOwnerWithOptions($reseller, $start = 0, $length = 10, $columns = array(), $search_value = "", $order_column_index = NULL, $order_type = "asc")
{
    $result = array("data" => array(), "recordsTotal" => 0, "recordsFiltered" => 0);
    $all_clients = dataoutput($columns, getallonlineclientsbyownerid($reseller["id"]));
    if ($order_column_index !== NULL && isset($columns[$order_column_index]["db"])) {
        $order_column = $columns[$order_column_index]["db"];
        usort($all_clients, function ($a, $b) use($order_column, $order_type) {
            if ($a[$order_column] === $b[$order_column]) {
                return 0;
            }
            if ($order_type == "asc") {
                return strip_tags($b[$order_column]) < strip_tags($a[$order_column]) ? 1 : -1;
            }
            return strip_tags($a[$order_column]) < strip_tags($b[$order_column]) ? 1 : -1;
        });
    }
    $current_index = 0;
    foreach ($all_clients as $current_client) {
        if (tryfind($current_client, $columns, $search_value)) {
            if ($start <= $current_index && count($result["data"]) < $length) {
                $result["data"][] = $current_client;
            }
            $current_index++;
        }
    }
    $result["recordsTotal"] = count($all_clients);
    $result["recordsFiltered"] = $current_index;
    return $result;
}
function createReseller($owner_id, $username, $password, $credits, $member_group_id, $email, $notes)
{
    if (existReseller($username)) {
        return false;
    }
    $crypted_password = cryptPassword($password, "xtreamcodes");
    if ($member_group_id) {
        $settings = getServerSettings();
        if ($settings) {
            $language = $settings["default_lang"];
            return insertReseller($owner_id, $username, $crypted_password, $credits, $email, $notes, $member_group_id, $language);
        }
    }
    return false;
}
function insertReseller($owner_id, $username, $password, $credits, $email, $notes, $member_group_id, $language)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO `reg_users` (`id`, `username`, `password`, `email`, `ip`, `date_registered`, `verify_key`, `last_login`, `member_group_id`, `verified`, `credits`, `notes`, `status`, `default_lang`, `reseller_dns`, `owner_id`, `override_packages`, `google_2fa_sec`) VALUES (NULL, :username, :password, :email, NULL, unix_timestamp(NOW()), NULL, NULL, :member_group_id, '1', :credits, :notes, '1', :language, '', :owner_id, NULL, '')";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":owner_id", $owner_id, PDO::PARAM_INT);
        $stmt->bindParam(":username", $username, PDO::PARAM_STR, 255);
        $stmt->bindParam(":password", $password, PDO::PARAM_STR, 255);
        $stmt->bindParam(":credits", $credits, PDO::PARAM_INT);
        $stmt->bindParam(":email", $email, PDO::PARAM_STR, 255);
        $stmt->bindParam(":notes", $notes, PDO::PARAM_STR, 500);
        $stmt->bindParam(":member_group_id", $member_group_id, PDO::PARAM_INT);
        $stmt->bindParam(":language", $language, PDO::PARAM_STR, 255);
        if ($stmt->execute()) {
            $lastInsertId = $PDO->lastInsertId();
            // inserir um novo registro em DNS...
//dbPath =
$db = new SQLite3( '/home2/ultrad97/americamais.com/mytvfun/mytv_api/api/.db.db');
   //
 //   $db = new SQLite3('/home/rockstar/mytvfun.rockstards.com.br/mytv_api/api/.db.db');
    //$db = new SQLite3('/home/u137180050/domains/2bxt.xyz/public_html/mytvfun/mytv_api/api/.db.db');
               $db->busyTimeout(5000);
             $db->exec("INSERT INTO dns(id, portal1, portal2, portal3, portal4, portal5, portal6, portal7, portal8, portal9, portal10, portal11, portal12, portal13, portal14, portal15, portal16, portal17, portal18, portal19, portal20) VALUES('$lastInsertId', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)");
                $db->close();
                
                // inserir teste automatico
                
                 $stmt = $PDO->prepare("INSERT INTO `teste_automatico` (`id`, `status`, `url_chatbot`, `dns`) VALUES ('$lastInsertId', 'off', 'meu chatbot', 'minha dns')");
                 $stmt->execute();
             
            return true;
        }
    }
    return false;
}
function existReseller($username)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT `id` FROM `reg_users` WHERE `username` = :username;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":username", $username, PDO::PARAM_STR, 255);
        $stmt->execute();
        if (0 < $stmt->rowCount()) {
            return true;
        }
    }
    return false;
}
function getResellersAdmin()
{
    $results = array();
    $all_users = getallusers();
    foreach ($all_users as $current_user) {
        $reseller_key = array_search($current_user["owner_id"], array_column($all_users, "id"));
        $reseller_name = $reseller_key !== false ? $all_users[$reseller_key]["username"] : "-";
        $current_user["reseller_name"] = $reseller_name;
        array_push($results, $current_user);
    }
    return $results;
}
function getResellersByOwner($user)
{
    $results = array();
    $all_users = getallusers();
    $users = getAllResellersByOwnerID($user["id"]);
    foreach ($users as $current_user) {
        $reseller_key = array_search($current_user["owner_id"], array_column($all_users, "id"));
        $reseller_name = $reseller_key !== false ? $all_users[$reseller_key]["username"] : "-";
        $current_user["reseller_name"] = $reseller_name;
        array_push($results, $current_user);
    }
    return $results;
}
function toggleTicket($ticket_id)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "UPDATE `tickets` SET `status` = !`status` WHERE `id` = :ticket_id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":ticket_id", $ticket_id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function deleteTicket($ticket_id)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "DELETE FROM `tickets` WHERE `id` = :ticket_id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":ticket_id", $ticket_id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            $sql_two = "DELETE FROM `tickets_replies` WHERE `ticket_id` = :ticket_id;";
            $stmt = $PDO->prepare($sql_two);
            $stmt->bindParam(":ticket_id", $ticket_id, PDO::PARAM_INT);
            if ($stmt->execute()) {
                return true;
            }
        }
    }
    return false;
}
function updateReadTicket($ticket_id, $person, $read = 1)
{
    if ($person !== "admin" && $person !== "user") {
        return false;
    }
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "UPDATE `tickets` SET `" . $person . "_read` = :read WHERE `id` = :ticket_id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":ticket_id", $ticket_id, PDO::PARAM_INT);
        $stmt->bindParam(":read", $read, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function getTicketById($ticket_id)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `tickets` WHERE `tickets`.id = :ticket_id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":ticket_id", $ticket_id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return $stmt->fetch(PDO::FETCH_ASSOC);
        }
    }
    return false;
}
function getAllTickets()
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT `tickets`.id, `reg_users`.username as 'reseller', `tickets`.title, `tickets`.status, `tickets`.admin_read, `tickets`.user_read FROM `tickets`, `reg_users` WHERE `tickets`.member_id = `reg_users`.id";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return array();
}
function getAllTicketsByReseller($reseller_id)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT `tickets`.id, `reg_users`.username as 'reseller', `tickets`.title, `tickets`.status, `tickets`.admin_read, `tickets`.user_read FROM `tickets`, `reg_users` WHERE `tickets`.member_id = :member_id AND `tickets`.member_id = `reg_users`.id";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":member_id", $reseller_id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return array();
}
function getAllTicketsAdminWithOptions($start = 0, $length = 10, $columns = array(), $search_value = "", $order_column_index = NULL, $order_type = "asc")
{
    $result = array("data" => array(), "recordsTotal" => 0, "recordsFiltered" => 0);
    $all_resellers = dataoutput($columns, getalltickets());
    if ($order_column_index !== NULL && isset($columns[$order_column_index]["db"])) {
        $order_column = $columns[$order_column_index]["db"];
        usort($all_resellers, function ($a, $b) use($order_column, $order_type) {
            if ($a[$order_column] === $b[$order_column]) {
                return 0;
            }
            if ($order_type == "asc") {
                return strip_tags($b[$order_column]) < strip_tags($a[$order_column]) ? 1 : -1;
            }
            return strip_tags($a[$order_column]) < strip_tags($b[$order_column]) ? 1 : -1;
        });
    }
    $current_index = 0;
    foreach ($all_resellers as $current_reseller) {
        if (tryfind($current_reseller, $columns, $search_value)) {
            if ($start <= $current_index && count($result["data"]) < $length) {
                $result["data"][] = $current_reseller;
            }
            $current_index++;
        }
    }
    $result["recordsTotal"] = count($all_resellers);
    $result["recordsFiltered"] = $current_index;
    return $result;
}
function getAllTicketsByOwnerWithOptions($reseller, $start = 0, $length = 10, $columns = array(), $search_value = "", $order_column_index = NULL, $order_type = "asc")
{
    $result = array("data" => array(), "recordsTotal" => 0, "recordsFiltered" => 0);
    $all_resellers = dataoutput($columns, getallticketsbyreseller($reseller["id"]));
    if ($order_column_index !== NULL && isset($columns[$order_column_index]["db"])) {
        $order_column = $columns[$order_column_index]["db"];
        usort($all_resellers, function ($a, $b) use($order_column, $order_type) {
            if ($a[$order_column] === $b[$order_column]) {
                return 0;
            }
            if ($order_type == "asc") {
                return strip_tags($b[$order_column]) < strip_tags($a[$order_column]) ? 1 : -1;
            }
            return strip_tags($a[$order_column]) < strip_tags($b[$order_column]) ? 1 : -1;
        });
    }
    $current_index = 0;
    foreach ($all_resellers as $current_reseller) {
        if (tryfind($current_reseller, $columns, $search_value)) {
            if ($start <= $current_index && count($result["data"]) < $length) {
                $result["data"][] = $current_reseller;
            }
            $current_index++;
        }
    }
    $result["recordsTotal"] = count($all_resellers);
    $result["recordsFiltered"] = $current_index;
    return $result;
}
function getAllResellersAdminWithOptions($start = 0, $length = 10, $columns = array(), $search_value = "", $order_column_index = NULL, $order_type = "asc")
{
    $result = array("data" => array(), "recordsTotal" => 0, "recordsFiltered" => 0);
    $all_resellers = dataoutput($columns, getresellersadmin());
    if ($order_column_index !== NULL && isset($columns[$order_column_index]["db"])) {
        $order_column = $columns[$order_column_index]["db"];
        usort($all_resellers, function ($a, $b) use($order_column, $order_type) {
            if ($a[$order_column] === $b[$order_column]) {
                return 0;
            }
            if ($order_type == "asc") {
                return strip_tags($b[$order_column]) < strip_tags($a[$order_column]) ? 1 : -1;
            }
            return strip_tags($a[$order_column]) < strip_tags($b[$order_column]) ? 1 : -1;
        });
    }
    $current_index = 0;
    foreach ($all_resellers as $current_reseller) {
        if (tryfind($current_reseller, $columns, $search_value)) {
            if ($start <= $current_index && count($result["data"]) < $length) {
                $result["data"][] = $current_reseller;
            }
            $current_index++;
        }
    }
    $result["recordsTotal"] = count($all_resellers);
    $result["recordsFiltered"] = $current_index;
    return $result;
}
function getAllResellersByOwnerID($userid)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "select * from (select * from reg_users order by owner_id, id) users_sorted, (select @pv := :userid) initialisation where find_in_set(owner_id, @pv) and length(@pv := concat(@pv, ',', id));";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":userid", $userid, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    return array();
}
function getAllResellersIdByOwnerID($userid)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "select `id` from (select * from reg_users order by owner_id, id) users_sorted, (select @pv := :userid) initialisation where find_in_set(owner_id, @pv) and length(@pv := concat(@pv, ',', id));";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":userid", $userid, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_COLUMN);
    }
    return array();
}
function getAllResellersByOwnerWithOptions($reseller, $start = 0, $length = 10, $columns = array(), $search_value = "", $order_column_index = NULL, $order_type = "asc")
{
    $result = array("data" => array(), "recordsTotal" => 0, "recordsFiltered" => 0);
    $all_users = getallusers();
    $users = getallresellersbyownerid($reseller["id"]);
    foreach ($users as &$current_user) {
        $reseller_key = array_search($current_user["owner_id"], array_column($all_users, "id"));
        $reseller_name = $reseller_key !== false ? $all_users[$reseller_key]["username"] : "-";
        $current_user["reseller_name"] = $reseller_name;
    }
    $all_resellers = dataoutput($columns, $users);
    if ($order_column_index !== NULL && isset($columns[$order_column_index]["db"])) {
        $order_column = $columns[$order_column_index]["db"];
        usort($all_resellers, function ($a, $b) use($order_column, $order_type) {
            if ($a[$order_column] === $b[$order_column]) {
                return 0;
            }
            if ($order_type == "asc") {
                return strip_tags($b[$order_column]) < strip_tags($a[$order_column]) ? 1 : -1;
            }
            return strip_tags($a[$order_column]) < strip_tags($b[$order_column]) ? 1 : -1;
        });
    }
    $current_index = 0;
    foreach ($all_resellers as $current_reseller) {
        if (tryfind($current_reseller, $columns, $search_value)) {
            if ($start <= $current_index && count($result["data"]) < $length) {
                $result["data"][] = $current_reseller;
            }
            $current_index++;
        }
    }
    $result["recordsTotal"] = count($all_resellers);
    $result["recordsFiltered"] = $current_index;
    return $result;
}
function getResellersByOwnerID($userid)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `reg_users` WHERE `owner_id` = :userid;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":userid", $userid, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    return array();
}
function deleteReseller($reseller_id)
{
    deleteAllUserProperty($reseller_id);
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "DELETE FROM `reg_users` WHERE `id` = :reseller_id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":reseller_id", $reseller_id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function getClientsCount($reseller)
{
    return isAdmin($reseller) ? getAllClientsCount() : getClientsCountByOwnerId($reseller["id"]);
}
function getAllClientsCount()
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT count(*) FROM `users`";
        $stmt = $PDO->prepare($sql);
        $stmt->execute();
        return $stmt->fetchColumn();
    }
    return 0;
}
function getClientsCountByOwnerId($userid)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT count(*) FROM `users` WHERE `member_id` = :userid";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":userid", $userid, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchColumn();
    }
    return 0;
}
function getActiveCount($reseller)
{
    return isAdmin($reseller) ? getAllActiveClientsCount() : getActiveClientsCountByOwnerId($reseller["id"]);
}
function getAllActiveClientsCount()
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT count(*) FROM `users` WHERE (`exp_date` > unix_timestamp(NOW()) OR `exp_date` IS NULL) AND `is_trial` = 0;";
        $stmt = $PDO->prepare($sql);
        $stmt->execute();
        return $stmt->fetchColumn();
    }
    return 0;
}
function getActiveClientsCountByOwnerId($userid)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT count(*) FROM `users` WHERE `member_id` = :userid AND (`exp_date` > unix_timestamp(NOW()) OR `exp_date` IS NULL) AND `is_trial` = 0;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":userid", $userid, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchColumn();
    }
    return 0;
}
function getTrialClientsCount($reseller)
{
    return isAdmin($reseller) ? getAllTrialClientsCount() : getTrialClientsCountByOwnerId($reseller["id"]);
}
function getAllTrialClientsCount()
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT count(*) FROM `users` WHERE `is_trial` = 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->execute();
        return $stmt->fetchColumn();
    }
    return 0;
}
function getTrialClientsCountByOwnerId($userid)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT count(*) FROM `users` WHERE `member_id` = :userid AND `is_trial` = 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":userid", $userid, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchColumn();
    }
    return 0;
}
function getNewClientsCount($reseller)
{
    return isAdmin($reseller) ? getAllNewClientsCount() : getNewClientsCountByOwnerId($reseller["id"]);
}
function getAllNewClientsCount()
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT count(*) FROM `users` WHERE `is_trial` = 0 AND `created_at` >= unix_timestamp(NOW() - INTERVAL 1 DAY)";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            return $stmt->fetchColumn();
        }
    }
    return 0;
}
function getNewClientsCountByOwnerId($userid)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT count(*) FROM `users` WHERE `member_id` = :userid AND `is_trial` = 0 AND `created_at` >= unix_timestamp(NOW() - INTERVAL 1 DAY)";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":userid", $userid, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return $stmt->fetchColumn();
        }
    }
    return 0;
}
function getSalesShart($reseller)
{
    return isAdmin($reseller) ? getSalesShartByOwnerId() : getSalesShartByOwnerId($reseller["id"]);
}
function getSalesShartByOwnerId($userid = NULL)
{
    $result = array();
    $result["total"] = 0;
    $result["data"] = "";
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $first_day = strtotime(date("01-m-Y"));
        $last_day = strtotime(date("t-m-Y"));
        $sql = "SELECT `created_at` FROM `users` WHERE `is_trial` = 0 AND `created_at` >= :first_day AND `created_at` <= :last_day;";
        if ($userid) {
            $sql = "SELECT `created_at` FROM `users` WHERE `member_id` = :userid AND `is_trial` = 0 AND `created_at` >= :first_day AND `created_at` <= :last_day;";
        }
        $stmt = $PDO->prepare($sql);
        if ($userid) {
            $stmt->bindParam(":userid", $userid, PDO::PARAM_INT);
        }
        $stmt->bindParam(":first_day", $first_day, PDO::PARAM_INT);
        $stmt->bindParam(":last_day", $last_day, PDO::PARAM_INT);
        if ($stmt->execute()) {
            $array_result = array();
            for ($i = 0; $i < intval(date("t")); $i++) {
                $current_day = date("Y-m-d", strtotime("+" . $i . " days", $first_day));
                $array_result[$current_day] = 0;
            }
            $stmt_result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            foreach ($stmt_result as $row) {
                $created_at = date("Y-m-d", $row["created_at"]);
                $array_result[$created_at] = !$array_result[$created_at] ? 1 : $array_result[$created_at] + 1;
                $result["total"]++;
            }
            foreach ($array_result as $day => $count) {
                $result["data"] .= "{ y: '" . $day . "', item: '" . $count . "'}, ";
            }
            $result["data"] = substr($result["data"], 0, -2);
            return $result;
        }
    }
    return $result;
}
function verificaUserOnline($userid)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "select users.id, users.username, streams.stream_display_name as `stream_name`, streams.stream_icon, user_activity_now.user_ip, user_activity_now.date_start as `time`,user_activity_now.geoip_country_code as `country`, user_activity_now.isp as `internet_server` from users, user_activity_now, streams where users.id=user_activity_now.user_id and user_activity_now.stream_id = streams.id and users.id = :userid;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":userid", $userid, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    return array();
}
function getAllClientsTable($userid, $start, $length, $search, $order_column_index, $order_type)
{
    $reseller = getuserbyid($userid);
    if ($reseller) {
        $columns = array(array("db" => "id", "formatter" => function ($d, $row) {
            if (!$row["exp_date"] || time() < $row["exp_date"]) {
                if (!empty($d) && $row["is_trial"]) {
                    return "<span class=\"azul\"><b>".$d."</b></span>";
                }else{
                    if (!empty($d) && !$row["is_trial"]) {
                     return "<span class=\"verde\"><b>".$d."</b></span>";
                 }else{
                    return $d;
                }
            }
        }else{
            return "<span class=\"vermelho\" data-toggle=\"tooltip\" data-original-title=\"Linha de teste EXPIRADA\"><b>".$d."</b></span>";
        }
    }), array("db" => "display_username", "formatter" => function ($d, $row) {
        if (!$row["exp_date"] || time() < $row["exp_date"]) {
            if($row["is_trial"]){
                return "<i class=\"fa fa-hashtag vermelho\" data-toggle=\"tooltip\" data-original-title=\"Linha de teste ATIVA\"><b class=\"azul\"> " . $row["username"] ." </b></i>";
            }else{
                return "<i class=\"verde\" data-toggle=\"tooltip\" data-original-title=\"Linha OFICIAL ATIVA\"><b> " . $row["username"] ." </b></i>";
            }
        }else{
            if ($row["is_trial"]) {
                return "<i class=\"fa fa-hashtag vermelho\" data-toggle=\"tooltip\" data-original-title=\"Linha de teste EXPIRADA\"><b> " . $row["username"] ." </b></i>";
            }
            return "<i class=\"fa-power-off vermelho\" data-toggle=\"tooltip\" data-original-title=\"Linha oficial EXPIRADA\"><b> " . $row["username"] ." </b></i>";
        }
    }),
    
     array("db" => "display_username2", "formatter" => function ($d, $row) {
        if (!$row["exp_date"] || time() < $row["exp_date"]) {
            if($row["is_trial"]){
                return "<i class=\"fa fa-hashtag vermelho\" data-toggle=\"tooltip\" data-original-title=\"Linha de teste ATIVA\"><b class=\"azul\"> " . $row["username_"] ." </b></i>";
            }else{
                return "<i class=\"verde\" data-toggle=\"tooltip\" data-original-title=\"Linha OFICIAL ATIVA\"><b> " . $row["username_"] ." </b></i>";
            }
        }else{
            if ($row["is_trial"]) {
                return "<i class=\"fa fa-hashtag vermelho\" data-toggle=\"tooltip\" data-original-title=\"Linha de teste EXPIRADA\"><b> " . $row["username_"] ." </b></i>";
            }
            return "<i class=\"fa-power-off vermelho\" data-toggle=\"tooltip\" data-original-title=\"Linha oficial EXPIRADA\"><b> " . $row["username_"] ." </b></i>";
        }
    }),
    
    array("db" => "password", "formatter" => function ($d, $row){
        if (!$row["exp_date"] || time() < $row["exp_date"]) {
            if (!empty($row["password"]) && $row["is_trial"]) {
                return "<span class=\"azul\" data-toggle=\"tooltip\" data-original-title=\"Linha de teste ATIVA\"><b>".$row["password"]."</b></span>";
            }else{
                if (!empty($row["password"]) && !$row["is_trial"]) {
                    return "<span class=\"verde\" data-toggle=\"tooltip\" data-original-title=\"Linha OFICIAL ATIVA\"><b>".$row["password"]."</b></span>";
                }else{
                    return $r;
                }
            }
        }else{
            if ($row["is_trial"]) {
                return "<i class=\"fa fa-hashtag vermelho\" data-toggle=\"tooltip\" data-original-title=\"Linha de teste EXPIRADA\"><b> " . $row["password"] ." </b></i>";
            }
            return "<i class=\"vermelho\" data-toggle=\"tooltip\" data-original-title=\"Linha oficial EXPIRADA\"><b> " . $row["password"] ." </b></i>";
        }
    }), array("db" => "created_at", "formatter" => function ($d, $row) {
        if (!$row["exp_date"] || time() < $row["exp_date"]) {
            if (!empty($d) && $row["is_trial"]) {
                return "<span class=\"azul\" data-toggle=\"tooltip\" data-original-title=\"Linha de teste ATIVA\"><b>".date("d/m/Y", $d)."</b></span>";
            }else{
                if (!empty($d) && !$row["is_trial"]) {
                    return "<span class=\"fa-calendar verde\" data-toggle=\"tooltip\" data-original-title=\"Linha OFICIAL ATIVA\"><b>".date("d/m/Y", $d)."</b></span>";
                }else{
                    return $d;
                }
            }
        }else{
            if ($row["is_trial"]) {
                return "<span class=\"vermelho\" data-toggle=\"tooltip\" data-original-title=\"Linha de teste EXPIRADA\"><b>".date("d/m/Y", $d)."</b></span>";
            }
            return "<span class=\"vermelho\" data-toggle=\"tooltip\" data-original-title=\"Linha oficial EXPIRADA\"><b>".date("d/m/Y", $d)."</b></span>";
        }
    }), array("db" => "exp_date", "formatter" => function ($d, $row) {
        if (!$row["exp_date"] || time() < $row["exp_date"]) {
            if (!empty($d) && $row["is_trial"]) {
                return "<span class=\"badge badge-info\" data-toggle=\"tooltip\" data-original-title=\"Linha de teste ATIVA\">".date("d/m/Y H:i", $d)."</span>";
            }else{
                if (!empty($d) && !$row["is_trial"]) {
                 return "<span class=\"badge badge-success\" data-toggle=\"tooltip\" data-original-title=\"Linha OFICIAL ATIVA\">".date("d/m/Y H:i", $d)."</span>";
             }else{
                return $d;
            }
        }
    }else{
        if ($row["is_trial"]) {
            return "<span class=\"badge badge-danger\" data-toggle=\"tooltip\" data-original-title=\"Linha de teste EXPIRADA\">".date("d/m/Y H:i", $d)."</span>";
        }
        return "<span class=\"badge badge-danger\" data-toggle=\"tooltip\" data-original-title=\"Linha oficial EXPIRADA\">".date("d/m/Y H:i", $d)."</span>";
        
    }
}), array("db" => "reseller_name", "formatter" => function ($d, $row) {
    if (!$row["exp_date"] || time() < $row["exp_date"]) {
        if (!empty($d) && $row["is_trial"]) {
            return "<span class=\"azul\" data-toggle=\"tooltip\" data-original-title=\"Linha de teste ATIVA\"><b>".$d."</b></span>";
        }else{       
         return "<span class=\"verde\" data-toggle=\"tooltip\" data-original-title=\"Linha OFICIAL ATIVA\"><b>".$d."</b></span>";
     }
 }else{
    if ($row["is_trial"]) {
        return "<span class=\"vermelho\" data-toggle=\"tooltip\" data-original-title=\"Linha de teste EXPIRADA\"><b>".$d."</b></span>";
    }
    return "<span class=\"vermelho\" data-toggle=\"tooltip\" data-original-title=\"Linha OFICIAL EXPIRADA\"><b>".$d."</b></span>";  
}
}), 



//array("db" => "stream_icon", "formatter" => function ($d, $row) {
    //$pegaDados = verificaUserOnline($row["id"]);
    //$nomeCanal = $pegaDados[0]['stream_name'];


    //return $nomeCanal ? "<span class=\"badge badge-round badge-dark\" data-toggle=\"tooltip\" data-original-title=\"".$nomeCanal."\">".$nomeCanal."</span>" : "";
//}),

array("db" => "reseller_notes", "formatter" => function ($d, $row) {
    if (!$row["exp_date"] || time() < $row["exp_date"]) {
        if (!empty($d) && $row["is_trial"]) {
            return "<span class=\"azul\" data-toggle=\"tooltip\" data-original-title=\"" . $d . "\">" . str_limit($d, 10) . "</span>";
        }else{
            return "<span class=\"verde\" data-toggle=\"tooltip\" data-original-title=\"" . $d . "\">" . str_limit($d, 10) . "</span>";
        }
    }else{
        return "<span class=\"vermelho\" data-toggle=\"tooltip\" data-original-title=\"" . $d . "\">" . str_limit($d, 10) . "</span>";
    }
}), array("db" => "status", "formatter" => function ($d, $row) {
    $status = "";
    if ($row["admin_enabled"] && $row["enabled"]) {
        $status = "<span class=\"label label-success\">Ativo</span>";
        if (!$row["exp_date"] || time() < $row["exp_date"]) {
            if ($row["is_trial"]) {
                $status = "<span class=\"badge btn-info\" data-toggle=\"tooltip\" data-original-title=\"Linha de teste ATIVA\">Testando</span>";
            }else{

                $status = "<span class=\"badge badge-success\" data-toggle=\"tooltip\" data-original-title=\"Linha OFICIAL ATIVA\">Ativo</span>";
            }
        } else {
            if ($row["is_trial"]) {
               $status = "<span class=\"badge badge-danger\" data-toggle=\"tooltip\" data-original-title=\"Linha de teste EXPIRADA\">Expirado</span>";
           }
           $status = "<span class=\"badge badge-danger\" data-toggle=\"tooltip\" data-original-title=\"Linha OFICIAL EXPIRADA\">Expirado</span>"; 
       }
   } else {
    $status = "<span class=\"badge badge-danger\" data-toggle=\"tooltip\" data-original-title=\"Linha DESATIVADA\">Desativado</span>";
}
return $status;
}), /* CADA ARRAY UMA COLUNA */
array("db" => "action", "searchable" => false, "formatter" => function ($d, $row) {

    /* todos os botões da coluna action estão aqui */
    return "<div class=\"actions text-center\">\r\n 

    <!-- NOVO BOTÃO -->
    <!--
    <a href=\"#\" class=\"btn btn-icon text-yellow btdesblock\" data-toggle=\"tooltip\" data-original-title=\"Desbloqueio de confiança 3 dias\" data-id=\"" . $row["id"] . "\" data-text=\"Desbloquear o usuário: <b>".$row["username"]."</b> por mais 3 dias?". "\">\r\n   <i class=\"icon fa-handshake-o\" aria-hidden=\"true\" style=\"font-size: 16px\"></i>\r\n                            </a>\r\n -->
    <!-- NOVO BOTÃO -->


    <!-- NOVO BOTÃO -->
    <a href='#' class=\"btn btn-icon text-muted \" data-toggle=\"tooltip\" data-original-title=\"Limpar MAC\" onClick='limpar_mac(".$row["id"].");' >\r\n                                      
    <i class=\"icon fa-refresh\" aria-hidden=\"true\" style=\"font-size: 16px; color:#30bdae\"></i>\r\n                                    </a>\r\n
    <!-- NOVO BOTÃO -->
    <!-- NOVO BOTÃO -->
    <!--
    <a href=\"#\" class=\"btn btn-icon text-yellow btdesblock\" data-toggle=\"tooltip\" data-original-title=\"Desbloqueio de confiança 3 dias\" data-id=\"" . $row["id"] . "\" data-text=\"Desbloquear o usuário: <b>".$row["username"]."</b> por mais 3 dias?". "\">\r\n   <i class=\"icon fa-handshake-o\" aria-hidden=\"true\" style=\"font-size: 16px\"></i>\r\n                            </a>\r\n -->
    <!-- NOVO BOTÃO -->


    <!-- NOVO BOTÃO -->
    <!--<a href='#' class=\"btn btn-icon text-muted \" data-toggle=\"tooltip\" data-original-title=\"Informações rápidas\" onClick='get_user_infos(".$row["id"].");' >\r\n                                      
    <i class=\"icon fa-send\" aria-hidden=\"true\" style=\"font-size: 16px; color:#30bdae\"></i>\r\n                                    </a>\r\n-->
    <!-- NOVO BOTÃO -->



    <a href=\"./clientes_edit.php?client_id=" . $row["id"] . "\" class=\"btn btn-icon text-muted \" data-toggle=\"tooltip\" data-original-title=\"Editar Cliente\" data-id=\"" . $row["id"] . "\">\r\n                                      
    <i class=\"icon wb-edit\" aria-hidden=\"true\" style=\"font-size: 16px\"></i>\r\n                                    </a>\r\n                                    
    <a href=\"#\" class=\"btn btn-sm btn-icon btn-pure btn-success on-default btrenew\" data-toggle=\"tooltip\" data-original-title=\"Renovar 1 mes - custo " . 1 . " credito(s).\" data-id=\"" . $row["id"] . "\" data-text=\"Usuario: " . $row["username"] . " - Creditos a ser consumido: " . $row["max_connections"] . "\">\r\n                                      
    <i class=\"icon fas fa-desktop\" aria-hidden=\"true\" style=\"font-size: 16px\"></i>\r\n                                    </a>\r\n                                    
    <a href=\"#\" class=\"btn btn-sm btn-icon btn-pure btn-warning on-default edit-row btrenewplus\" data-toggle=\"tooltip\" data-original-title=\"Renovar vários meses - custo depende da quantidade de meses e telas.\" data-id=\"" . $row["id"] . "\" data-text=\"Usuario: " . $row["username"] . "\">\r\n                                      
    <i class=\"fa fa-calendar-plus-o\" aria-hidden=\"true\" style=\"font-size: 16px\"></i>\r\n                                    </a>\r\n                                    
   
    
   
    <a href=\"#\" class=\"btn btn-icon text-yellow btblock\" data-toggle=\"tooltip\" data-original-title=\"Bloquear/Desbloquear\" data-id=\"" . $row["id"] . "\" data-text=\"Bloquear/desbloquear o usuário: " . $row["username"] . "\">\r\n                                        <i class=\"fa fa-ban\" aria-hidden=\"true\" style=\"font-size: 16px\"></i>\r\n                                    </a>\r\n   

    <a href=\"#\" class=\"btn btn-icon text-red btdelete\" data-toggle=\"tooltip\" data-original-title=\"Deletar Cliente\" data-id=\"" . $row["id"] . "\" data-text=\"Deseja realmente deletar o Cliente: " . $row["username"]." ?" . " Não sera possivel recupera-lo!"."\">\r\n                                        
    <i class=\"fa fa-trash\" aria-hidden=\"true\" style=\"font-size: 16px\"></i>\r\n                                    </a>\r\n                                
    </div>";
}));
$clients = isAdmin($reseller) ? getallclientsadminwithoptions($start, $length, $columns, $search, $order_column_index, $order_type) : getallclientsbyownerwithoptions($reseller, $start, $length, $columns, $search, $order_column_index, $order_type);

return $clients;
}
return array();
}








function getAllOnlineClientsTable($userid, $start, $length, $search_value, $order_column_index, $order_type)
{
    $reseller = getuserbyid($userid);
    if ($reseller) {
        $columns = array(array("db" => "username"), 

            array("db" => "stream_icon" ,"formatter" => function ($d, $row) {
                $logoCanal = empty($d) ? "Canal sem logo" : $d;
                return "<img align=\"center\" width=\"45\" height=\"35\" src=\"".$logoCanal."\"/>";
            }), array("db" => "time", "formatter" => function ($d, $row) {
                return !empty($d) ? date("d/m/Y H:i", $d) : "";
            }), 

            array("db" => "user_ip"), array("db" => "country", "formatter" => function ($d, $row) {
                $country = empty($d) ? "unknown" : $d;
                return "<img align=\"center\" width=\"20\" height=\"20\" src=\"".$_SERVER['SCRIPT_URI']."/temp/assets/images/flags/" . $country . ".gif\"/>";
            }), 

            array("db" => "internet_server"));
        return isAdmin($reseller) ? getallonlineclientswithoptions($start, $length, $columns, $search_value, $order_column_index, $order_type) : getallonlineclientsbyownerwithoptions($reseller, $start, $length, $columns, $search_value, $order_column_index, $order_type);
    }
    return array();
}
function getAllResellersTable($userid, $start, $length, $search, $order_column_index, $order_type)
{
    $reseller = getuserbyid($userid);
    if ($reseller) {
        $columns = array(array("db" => "id"), array("db" => "username"), array("db" => "email"), array("db" => "date_registered", "formatter" => function ($d, $row) {
            return !empty($d) ? date("d/m/Y", $d) : "";
        }), array("db" => "ip"), array("db" => "credits"), array("db" => "reseller_notes"), array("db" => "reseller_name"), array("db" => "status", "formatter" => function ($d, $row) {
            return $row["status"] ? "<span class=\"badge badge-success\">Ativo</span>" : "<span class=\"badge badge-danger\">Bloqueado</span>";
        }), array("db" => "action", "searchable" => false, "formatter" => function ($d, $row) {
            return "<div class=\"actions text-center\">\r\n                                    <a href=\"./editar-revenda-master.php?reseller_id=" . $row["id"] . "\" class=\"btn btn-icon text-muted\" data-toggle=\"tooltip\" data-original-title=\"Editar Revendedor\" data-id=\"" . $row["id"] . "\">\r\n                                    <i class=\"icon wb-edit\" aria-hidden=\"true\" style=\"font-size: 16px\"></i>\r\n                                    </a>\r\n                                    <a href=\"#\" class=\"btn btn-icon text-green btcredits\" data-toggle=\"tooltip\" data-original-title=\"Adic/Remover Creditos\" data-id=\"" . $row["id"] . "\" data-text=\"Adicionar/remover creditos do revendedor: " . $row["username"] . "\">\r\n                                    <i class=\"fa fa-dollar\" aria-hidden=\"true\" style=\"font-size: 16px\"></i>\r\n                                    </a>\r\n                                    <a href=\"#\" class=\"btn btn-icon text-yellow btblock\" data-toggle=\"tooltip\" data-original-title=\"Bloquear/Desbloquear\" data-id=\"" . $row["id"] . "\" data-text=\"Bloquear/desbloquear o revendedor: " . $row["username"] . "\">\r\n                                    <i class=\"fa fa-ban\" aria-hidden=\"true\" style=\"font-size: 16px\"></i>\r\n                                    </a>\r\n                                    <a href=\"#\" class=\"btn btn-icon text-red btdelete\" data-toggle=\"tooltip\" data-original-title=\"Deletar Revendedor\" data-id=\"" . $row["id"] . "\" data-text=\"Deletar o revendedor: " . $row["username"] . "\">\r\n                                    <i class=\"fa fa-trash\" aria-hidden=\"true\" style=\"font-size: 16px\"></i>\r\n                                    </a>\r\n                                </div>";
        }));
        $resellers = isAdmin($reseller) ? getallresellersadminwithoptions($start, $length, $columns, $search, $order_column_index, $order_type) : getallresellersbyownerwithoptions($reseller, $start, $length, $columns, $search, $order_column_index, $order_type);
        return $resellers;
    }
    return array();
}
function getTickets($userid, $start, $length, $search, $order_column_index, $order_type)
{
    $reseller = getuserbyid($userid);
    if ($reseller) {
        $columns = array(array("db" => "id"), array("db" => "reseller"), array("db" => "title"), array("db" => "last_reply"), array("db" => "status", "formatter" => function ($d, $row) {
            return $row["status"] ? "<span class=\"badge badge-success\">Aberto</span>" : "<span class=\"badge badge-danger\">Fechado</span>";
        }), array("db" => "action", "searchable" => false, "formatter" => function ($d, $row) {
            return "<div class=\"actions text-center\">\r\n                                    <a href=\"./ver-chamado.php?ticket_id=" . $row["id"] . "\" class=\"btn btn-icon text-muted\" data-toggle=\"tooltip\" data-original-title=\"Ver Ticket\" data-id=\"" . $row["id"] . "\">\r\n                                    <i class=\"fa fa-search\" aria-hidden=\"true\" style=\"font-size: 16px\"></i>\r\n                                    </a>\r\n                                    <a href=\"#\" class=\"btn btn-icon text-yellow bttoggle\" data-toggle=\"tooltip\" data-original-title=\"Abrir/Fechar\" data-id=\"" . $row["id"] . "\" data-text=\"Abrir/Fechar o ticket\">\r\n                                    <i class=\"fa fa-ban\" aria-hidden=\"true\" style=\"font-size: 16px\"></i>\r\n                                    </a>\r\n                                </div>";
        }));
        $columns_admin = array(array("db" => "id"), array("db" => "reseller"), array("db" => "title"), array("db" => "last_reply"), array("db" => "status", "formatter" => function ($d, $row) {
            return $row["status"] ? "<span class=\"badge badge-success\">Aberto</span>" : "<span class=\"badge badge-danger\">Fechado</span>";
        }), array("db" => "action", "searchable" => false, "formatter" => function ($d, $row) {
            return "<div class=\"actions text-center\">\r\n                                    <a href=\"./ver-chamado.php?ticket_id=" . $row["id"] . "\" class=\"btn btn-icon text-muted\" data-toggle=\"tooltip\" data-original-title=\"Ver Ticket\" data-id=\"" . $row["id"] . "\">\r\n                                    <i class=\"fa fa-search\" aria-hidden=\"true\" style=\"font-size: 16px\"></i>\r\n                                    </a>\r\n                                    <a href=\"#\" class=\"btn btn-icon text-yellow bttoggle\" data-toggle=\"tooltip\" data-original-title=\"Abrir/Fechar\" data-id=\"" . $row["id"] . "\" data-text=\"Abrir/Fechar o ticket\">\r\n                                    <i class=\"fa fa-ban\" aria-hidden=\"true\" style=\"font-size: 16px\"></i>\r\n                                    </a>\r\n                                    <a href=\"#\" class=\"btn btn-icon text-red btdelete\" data-toggle=\"tooltip\" data-original-title=\"Deletar Ticket\" data-id=\"" . $row["id"] . "\" data-text=\"Deletar o ticket\">\r\n                                    <i class=\"fa fa-trash\" aria-hidden=\"true\" style=\"font-size: 16px\"></i>\r\n                                    </a>\r\n                                </div>";
        }));
        $tickets = isAdmin($reseller) ? getallticketsadminwithoptions($start, $length, $columns_admin, $search, $order_column_index, $order_type) : getallticketsbyownerwithoptions($reseller, $start, $length, $columns, $search, $order_column_index, $order_type);
        return $tickets;
    }
    return array();
}
function updateClient($client_id, $username, $password, $reseller_notes, $bouquet, $mac)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "UPDATE `users` SET `username` = :username, `username_` = :username_, `password` = :password, `reseller_notes` = :reseller_notes, `bouquet` = :bouquet WHERE `id` = :client_id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":username", $mac, PDO::PARAM_STR, 255);
          $stmt->bindParam(":username_", $username, PDO::PARAM_STR, 255);
        $stmt->bindParam(":password", $password, PDO::PARAM_STR, 255);
        $stmt->bindParam(":reseller_notes", $reseller_notes, PDO::PARAM_STR);
        $stmt->bindParam(":bouquet", $bouquet, PDO::PARAM_STR);
        $stmt->bindParam(":client_id", $client_id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function renewClient($client_id, $month)
{
    $client = getclientbyid($client_id);
    if ($client) {
        $exp_date = time() < $client["exp_date"] ? $client["exp_date"] : time();
        $exp_date = strtotime("+" . $month . " month", $exp_date);
        $PDO = getconnection();
        if ($PDO !== NULL) {
            $sql = "UPDATE `users` SET `exp_date` = :exp_date, `is_trial` = '0' WHERE `id` = :client_id LIMIT 1;";
            $stmt = $PDO->prepare($sql);
            $stmt->bindParam(":exp_date", $exp_date, PDO::PARAM_INT);
            $stmt->bindParam(":client_id", $client_id, PDO::PARAM_INT);
            if ($stmt->execute()) {
                return true;
            }
        }
    }
    return false;
}
function desbloqueioConfianca($client_id, $day)
{
    $client = getclientbyid($client_id);
    if ($client) {
        $exp_date = time() < $client["exp_date"] ? $client["exp_date"] : time();
        $exp_date = strtotime("+" . $day . " days", $exp_date);
        $PDO = getconnection();
        if ($PDO !== NULL) {
            $sql = "UPDATE `users` SET `exp_date` = :exp_date, `is_trial` = '0' WHERE `id` = :client_id LIMIT 1;";
            $stmt = $PDO->prepare($sql);
            $stmt->bindParam(":exp_date", $exp_date, PDO::PARAM_INT);
            $stmt->bindParam(":client_id", $client_id, PDO::PARAM_INT);
            if ($stmt->execute()) {
                return true;
            }
        }
    }
    return false;
}
function addScreenClient($client_id, $max_connections)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        
        $sql = "SELECT `max_connections` FROM users WHERE `id` = :client_id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":client_id", $client_id, PDO::PARAM_INT);
        $stmt->execute();
        $max = $stmt->fetchColumn();
        
        if($max >= 2) {
            return false;
        }
        
        $sql = "UPDATE `users` SET `max_connections` = `max_connections` + :max_connections WHERE `id` = :client_id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":max_connections", $max_connections, PDO::PARAM_INT);
        $stmt->bindParam(":client_id", $client_id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
}

function limparDispositivos ($client_id, $max_connections)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
      
        $sql = "UPDATE `users` SET `device_1` = NULL, `device_2` = NULL WHERE `id` = :client_id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":client_id", $client_id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
}


$cont=0;
function addOrRemoveCredits($user_id = null, $credits=0)
{
    $reseller = getuserbyid($user_id);
    if ($reseller) {

        $saldo_futuro = (int) $reseller["credits"];
        $saldo_futuro += (int) $credits;
        $cont++;
        if (0 <= $saldo_futuro){
            $PDO = getconnection();
            if ($PDO !== NULL) {
             /* se for admin o valor da operação é convertido em zero */
             if ($user_id == 1){
                /* inicializar por segurança */
                $saldo_futuro = 1000000;
                return true;
                exit;
            }else{
                $sql = "UPDATE `reg_users` SET `credits` = :credits WHERE `id` = :user_id LIMIT 1;";
                $stmt = $PDO->prepare($sql);
                $stmt->bindParam(":credits", $saldo_futuro, PDO::PARAM_INT);
                $stmt->bindParam(":user_id", $user_id, PDO::PARAM_INT);
                if ($stmt->execute() && 0 < $stmt->rowCount()){

                    return true;
                }
            }
        }
    }
}
return false;
}
function toggleBlock($user_id)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "UPDATE `reg_users` SET `status` = !`status` WHERE `id` = :user_id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":user_id", $user_id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function toggleClientBlock($user_id)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "UPDATE `users` SET `enabled` = !`enabled` WHERE `id` = :user_id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":user_id", $user_id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function deleteClient($user_id)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "DELETE FROM `users` WHERE `id` = :user_id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":user_id", $user_id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function getGroupByID($group_id)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `member_groups` WHERE `group_id` = :group_id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":group_id", $group_id, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
    return false;
}
function getBouquets()
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `bouquets`;";
        $stmt = $PDO->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    return array();
}
function getAllGroups()
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `member_groups`;";
        $stmt = $PDO->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    return array();
}
function getPackageByID($package_id)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `packages` WHERE `id` = :package_id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":package_id", $package_id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return $stmt->fetch(PDO::FETCH_ASSOC);
        }
    }
    return false;
}
function getPackages()
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `packages`;";
        $stmt = $PDO->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    return array();
}
function getLastChannels($limit = 10)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT `stream_display_name` FROM `streams` WHERE `type` = 1 OR `type` = 3 ORDER BY `added` DESC LIMIT :_limit;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":_limit", $limit, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return $stmt->fetchAll(PDO::FETCH_COLUMN);
        }
    }
    return array();
}

function getLastMovies($limit = 10)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT `stream_display_name` FROM `streams` WHERE `type` = 2 ORDER BY `added` DESC LIMIT :_limit;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":_limit", $limit, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return $stmt->fetchAll(PDO::FETCH_COLUMN);
        }
    }
    return array();
}

function totalDeFilmes()
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
       // $sql = "SELECT `stream_display_name` FROM `streams` WHERE `type` = 2";
       // $stmt = $PDO->prepare($sql);
      //  if ($stmt->execute()) {
         //   return $stmt->fetchAll(PDO::FETCH_COLUMN);
       // }
    }
    return array();
}

function getLastSeries($limit = 10)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT REPLACE(`title`, 'SERIE - ', '') as 'title' FROM `series` ORDER BY `id` DESC LIMIT :_limit;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":_limit", $limit, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return $stmt->fetchAll(PDO::FETCH_COLUMN);
        }
    }
    return array();
}

function totalDeSeries()
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
       // $sql = "SELECT REPLACE(`title`, 'SERIE - ', '') as 'title' FROM `series`";
      //  $stmt = $PDO->prepare($sql);
      //  if ($stmt->execute()) {
      //      return $stmt->fetchAll(PDO::FETCH_COLUMN);
      //  }
    }
    return array();
}


function isAdmin($user)
{
    $group_settings = json_decode(getServerProperty("group_settings"), true);
    return $group_settings["admin"] == $user["member_group_id"];
}
function isUltra($user)
{
    $group_settings = json_decode(getServerProperty("group_settings"), true);
    return $group_settings["ultra"] == $user["member_group_id"];
}
function isMaster($user)
{
    $group_settings = json_decode(getServerProperty("group_settings"), true);
    if ($group_settings["master"] == $user["member_group_id"]) {
        $owner_id = $user["owner_id"];
        if ($owner_id) {
            $owner = getuserbyid($owner_id);
            if ($owner && $group_settings["master"] == $owner["member_group_id"]) {
                return false;
            }
        }
        return true;
    }
    return false;
}
function isReseller($user)
{
    $group_settings = json_decode(getServerProperty("group_settings"), true);
    return $group_settings["reseller"] == $user["member_group_id"];
}
function hasPermission($user_id, $client_id)
{
    $owner = getuserbyid($user_id);
    if ($owner) {
        if (isadmin($owner)) {
            return true;
        }
        $client = getclientbyid($client_id);
        if ($client) {
            $reseller = getuserbyid($client["member_id"]);
            while ($reseller && $reseller["id"] != $user_id) {
                $reseller = getuserbyid($reseller["owner_id"]);
            }
            return $reseller;
        }
    }
    return false;
}
function masterHasPermission($master_id, $reseller_id)
{
    $owner = getuserbyid($master_id);
    if ($owner && isAdmin($owner)) {
        return true;
    }
    $reseller = getuserbyid($reseller_id);
    return $reseller && $reseller["owner_id"] == $master_id;
}
function createTicket($logged_user, $reseller_id, $title, $message)
{
    $member_id = $logged_user["id"];
    $admin_read = 0;
    $user_read = 1;
    if (isadmin($logged_user)) {
        $member_id = $reseller_id;
        $admin_read = 1;
        $user_read = 0;
    }
    $ticket_id = insertTicket($member_id, $title, 1, $admin_read, $user_read);
    if ($ticket_id !== false && insertTicketReply($ticket_id, $admin_read, $message)) {
        return $ticket_id;
    }
    return false;
}
function insertTicket($member_id, $title, $status, $admin_read, $user_read)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO `tickets` (`id`, `member_id`, `title`, `status`, `admin_read`, `user_read`) VALUES (NULL, :member_id, :title, :status, :admin_read, :user_read)";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":member_id", $member_id, PDO::PARAM_INT);
        $stmt->bindParam(":title", $title, PDO::PARAM_STR, 255);
        $stmt->bindParam(":status", $status, PDO::PARAM_INT);
        $stmt->bindParam(":admin_read", $admin_read, PDO::PARAM_INT);
        $stmt->bindParam(":user_read", $user_read, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return $PDO->lastInsertId();
        }
    }
    return false;
}
function insertTicketReply($ticket_id, $admin_reply, $message)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO `tickets_replies` (`id`, `ticket_id`, `admin_reply`, `message`, `date`) VALUES (NULL, :ticket_id, :admin_reply, :message, unix_timestamp(NOW()))";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":ticket_id", $ticket_id, PDO::PARAM_INT);
        $stmt->bindParam(":admin_reply", $admin_reply, PDO::PARAM_INT);
        $stmt->bindParam(":message", $message, PDO::PARAM_STR, 1000);
        if ($stmt->execute()) {
            $other_person = $admin_reply ? "user" : "admin";
            updatereadticket($ticket_id, $other_person, 0);
            return true;
        }
    }
    return false;
}
function getTicketReplies($ticket_id)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `tickets_replies` WHERE `ticket_id` = :ticket_id ORDER BY `id` DESC;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":ticket_id", $ticket_id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return array();
}
function resetPassword($email)
{
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        return 2;
    }
    $user = getuserbyemail($email);
    if ($user) {
        $reset_key = getRandomMD5($user["id"]);
        deleteUserProperty($user["id"], "reset_key");
        if (addUserProperty($user["id"], "reset_key", $reset_key)) {
            $reset_link = getBaseURL() . "reset_password.php?key=" . $reset_key;
            $email_settings = json_decode(getServerProperty("email_settings"), true);
            $sender_name = $email_settings["sender_name"];
            $sender_email = $email_settings["sender_email"];
            $email_messages = json_decode(getServerProperty("email_messages"), true);
            $server_name = getServerProperty("server_name");
            $pass_recovery_subject = str_replace(array("{USERNAME}", "{SERVER_NAME}"), array($user["username"], $server_name), $email_messages["pass_recovery_subject"]);
            $pass_recovery_message = str_replace(array("{USERNAME}", "{SERVER_NAME}", "{RESET_LINK}"), array($user["username"], $server_name, $reset_link), $email_messages["pass_recovery_message"]);
            if (smtpmailer($email, $pass_recovery_subject, $pass_recovery_message)) {
                return 1;
            }
        }
        return 4;
    }
    return 3;
}
function addUserProperty($userid, $property, $value)
{
    $PDO = getofficeconnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO `user_properties` (`userid`, `property`, `value`) VALUES (:userid, :property, :_value);";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":userid", $userid, PDO::PARAM_INT);
        $stmt->bindParam(":property", $property, PDO::PARAM_STR, 255);
        $stmt->bindParam(":_value", $value, PDO::PARAM_STR, 10000);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function getUserProperty($userid, $property, $default_value = "")
{
    $PDO = getofficeconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `user_properties` WHERE `userid` = :userid AND `property` = :property LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":userid", $userid, PDO::PARAM_INT);
        $stmt->bindParam(":property", $property, PDO::PARAM_STR, 255);
        if ($stmt->execute()) {
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($result) {
                return $result["value"];
            }
        }
    }
    return $default_value;
}
function getUserPropertyByValue($property, $value, $default_value = "")
{
    $PDO = getofficeconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `user_properties` WHERE `value` = :value AND `property` = :property LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":value", $value, PDO::PARAM_STR, 10000);
        $stmt->bindParam(":property", $property, PDO::PARAM_STR, 255);
        if ($stmt->execute()) {
            return $stmt->fetch(PDO::FETCH_ASSOC);
        }
    }
    return $default_value;
}
function deleteUserProperty($userid, $property)
{
    $PDO = getofficeconnection();
    if ($PDO !== NULL) {
        $sql = "DELETE FROM `user_properties` WHERE `userid` = :userid AND `property` = :property LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":userid", $userid, PDO::PARAM_INT);
        $stmt->bindParam(":property", $property, PDO::PARAM_STR, 255);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function deleteAllUserProperty($userid)
{
    $PDO = getofficeconnection();
    if ($PDO !== NULL) {
        $sql = "DELETE FROM `user_properties` WHERE `userid` = :userid;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":userid", $userid, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function addServerProperty($property, $value)
{
    $PDO = getofficeconnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO `office_properties` (`property`, `value`) VALUES (:property, :_value);";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":property", $property, PDO::PARAM_STR, 255);
        $stmt->bindParam(":_value", $value, PDO::PARAM_STR, 10000);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function getServerProperties()
{
    $PDO = getofficeconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT `property`, `value` FROM `office_properties`;";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            return $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
        }
    }
    return array();
}
function getServerProperty($property, $default_value = "")
{
    $PDO = getofficeconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `office_properties` WHERE `property` = :property LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":property", $property, PDO::PARAM_STR, 255);
        if ($stmt->execute()) {
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            if (isset($result["value"])) {
                return $result["value"];
            }
        }
    }
    return $default_value;
}
function updateServerProperty($property, $value)
{
    if (getserverproperty($property, NULL) !== NULL) {
        $PDO = getofficeconnection();
        if ($PDO !== NULL) {
            $sql = "UPDATE `office_properties` SET `value` = :_value WHERE `property` = :property LIMIT 1;";
            $stmt = $PDO->prepare($sql);
            $stmt->bindParam(":property", $property, PDO::PARAM_STR, 255);
            $stmt->bindParam(":_value", $value, PDO::PARAM_STR, 10000);
            if ($stmt->execute()) {
                return true;
            }
        }
        return false;
    }
    return addserverproperty($property, $value);
}
function deleteServerProperty($property)
{
    $PDO = getofficeconnection();
    if ($PDO !== NULL) {
        $sql = "DELETE FROM `office_properties` WHERE `property` = :property LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":property", $property, PDO::PARAM_STR, 255);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function getServerSettings()
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `settings`;";
        $stmt = $PDO->prepare($sql);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
    return array();
}
function getTestUrl($userid)
{
    $result = getuserproperty($userid, "test_key");
    if (!$result) {
        $result = getRandomMD5($userid);
        if (!adduserproperty($userid, "test_key", $result)) {
            return "You dont have a test url :c";
        }
    }
    return getBaseURL() . "auto_teste.php?key=" . $result;
}
function insertRegUserLog($owner, $username, $password, $type)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO `reg_userlog` (`id`, `owner`, `username`, `password`, `date`, `type`) VALUES (NULL, :owner, :username, :password, unix_timestamp(NOW()), :type);";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":owner", $owner, PDO::PARAM_INT);
        $stmt->bindParam(":username", $username, PDO::PARAM_STR);
        $stmt->bindParam(":password", $password, PDO::PARAM_STR);
        $stmt->bindParam(":type", $type, PDO::PARAM_STR, 255);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function insertCreditsLog($target_id, $admin_id, $amount, $reason)
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO `credits_log` (`id`, `target_id`, `admin_id`, `amount`, `date`, `reason`) VALUES (NULL, :target_id, :admin_id, :amount, unix_timestamp(NOW()), :reason);";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":target_id", $target_id, PDO::PARAM_INT);
        $stmt->bindParam(":admin_id", $admin_id, PDO::PARAM_INT);
        $stmt->bindParam(":amount", $amount, PDO::PARAM_INT);
        $stmt->bindParam(":reason", $reason, PDO::PARAM_STR);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function injectCustomCss()
{
    $custom_file_name = basename($_SERVER["SCRIPT_FILENAME"], ".php") . "_style.css";
    $full_path = "dist/css/custom/" . $custom_file_name;
    if (file_exists($full_path)) {
        echo "<link rel=\"stylesheet\" href=\"" . $full_path . "\">" . PHP_EOL;
    }
}
function getTranslatedDuration($package)
{
    $duration_in = "";
    switch ($package["trial_duration_in"]) {
        case "minutes":
        $duration_in = "minuto(s)";
        break;
        case "hours":
        $duration_in = "hora(s)";
        break;
        case "days":
        $duration_in = "dia(s)";
        break;
        case "months":
        $duration_in = "mes(es)";
        break;
        case "years":
        $duration_in = "ano(s)";
        break;
    }
    return $package["trial_duration"] . " " . $duration_in;
}
function getServerDNS()
{
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `streaming_servers` WHERE `can_delete` = 0 LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($result) {
            if (!empty($result["domain_name"])) {
                return "http://" . $result["domain_name"] . ":" . $result["http_broadcast_port"];
            }
            return "http://" . $result["ip"] . ":" . $result["http_broadcast_port"];
        }
    }
    return false;
}

function getBaseURL()
{
    return sprintf("%s://%s%s%s", isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] != "off" ? "https" : "http", $_SERVER["SERVER_NAME"], isset($_SERVER["SERVER_PORT"]) && $_SERVER["SERVER_PORT"] != "80" && $_SERVER["SERVER_PORT"] != "443" ? ":" . $_SERVER["SERVER_PORT"] : "", substr(dirname($_SERVER["REQUEST_URI"]), -1) == "/" ? dirname($_SERVER["REQUEST_URI"]) : dirname($_SERVER["REQUEST_URI"]) . "/");
}
function ShortenList($list)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, SHORTENER_URL . "/?url=" . urlencode($list));
    curl_setopt($ch, CURLOPT_POST, 0);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_VERBOSE, 0);
    $response = curl_exec($ch);
    curl_close($ch);
    if ($response === false) {
        return $list;
    }
    return $response;
}
function GetList($username, $password)
{
    $server_dns = getserverdns();
    $list_url = (string) $server_dns . "/get.php?username=" . $username . "&password=" . $password . "&type=m3u_plus&output=ts";
    return shortenlist($list_url);
}
function cryptPassword($password, $salt = "", $rounds = 20000)
{
    $hash = crypt($password, sprintf("\$6\$rounds=%d\$%s\$", $rounds, $salt));
    return $hash;
}
function str_limit($value, $limit = 100, $end = "...")
{
    if (mb_strwidth($value, "UTF-8") <= $limit) {
        return $value;
    }
    return rtrim(mb_strimwidth($value, 0, $limit, "", "UTF-8")) . $end;
}
function smtpmailer($para, $assunto, $corpo)
{
    if (!file_exists(__DIR__ . "/phpmailer/class.phpmailer.php")) {
        return false;
    }
    include_once __DIR__ . "/phpmailer/class.phpmailer.php";
    $mail = new PHPMailer();
    $email_settings = json_decode(getserverproperty("email_settings"), true);
   // var_dump($email_settings); die();
    if ($email_settings["use_smtp"] == 1) {
        $mail->IsSMTP();
        $mail->SMTPAuth = true;
        $mail->SMTPSecure = strtolower($email_settings["encryption_type"]);
        $mail->Host = $email_settings["smtp_server"];
        $mail->Port = intval($email_settings["smtp_port"]);
        $mail->Username = $email_settings["smtp_username"];
        $mail->Password = $email_settings["smtp_password"];
    } else {
        $mail->IsMail();
    }
    $mail->SetFrom($email_settings["sender_email"], $email_settings["sender_name"]);
    $mail->AddAddress($para);
    $mail->CharSet = "UTF-8";
    $mail->isHTML(true);
    $mail->Subject = $assunto;
    $mail->Body = $corpo;
   
    if (debugEnabled()) {
        $mail->SMTPDebug = 2;
    }
    
   
    if (!$mail->Send()) {
        return false;
    }
    
    return true;
}
function debugEnabled()
{
    if (defined("OFFICE_DEBUG") && OFFICE_DEBUG) {
        return true;
    }
    return false;
}
function random_str($length, $keyspace = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")
{
    $str = "";
    $max = mb_strlen($keyspace, "8bit") - 1;
    if ($max < 1) {
        return "";
    }
    for ($i = 0; $i < $length; $i++) {
        $str .= $keyspace[rand(0, $max)];
    }
    return $str;
}
function getRandomMD5($salt = "")
{
    return md5(random_str(20) . "#" . $salt);
}
function checkLicence($licence_key)
{

}
function writeLocalKey($localKey)
{

}

/* filtrar valores dentro do indice array */
function filtro($arr,$where,$campo,$param){

 foreach($arr as $key => $val){

    if($val[$where] == $param){
        return $val[$campo];
    }       
}

return "";

}

function buscarNovosFilmes($params=array())
{
    $PDO = getofficeconnection();
    if ($PDO !== NULL) {

        if(count($params) > 0){
            $sql = "SELECT `ID`, `titulo`, `diretorio_servidor`, `diretorio_imagem`, `data`, `comentario` FROM `novos_filmes` LIMIT ".$params->pg.",".$params->indice." ;";
        }else{

            $sql = "SELECT `ID`, `titulo`, `diretorio_servidor`, `diretorio_imagem`, `data`, `comentario` FROM `novos_filmes` WHERE 1;";

        }
       // var_dump($sql);die();
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}

function buscarNovasSeries($params=array())
{
    $PDO = getofficeconnection();
    if ($PDO !== NULL) {

        if(count($params) > 0){
            $sql = "SELECT `ID`, `titulo`, `diretorio_servidor`, `diretorio_imagem`, `data`, `comentario` FROM `novas_series` LIMIT ".$params->pg.",".$params->indice." ;";
        }else{

            $sql = "SELECT `ID`, `titulo`, `diretorio_servidor`, `diretorio_imagem`, `data`, `comentario` FROM `novas_series` WHERE 1;";

        }
       // var_dump($sql);die();
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}


function uploadPagFilme($titulo, $dir_serv, $nome, $comentario ){

    $PDO = getofficeconnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO `novos_filmes`(`ID`, `titulo`, `diretorio_servidor`, `diretorio_imagem`, `data`, `comentario`) VALUES (NULL, '$titulo', '$dir_serv', '$nome', NOW(), '$comentario')";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}

function uploadPaginaSeries($titulo_serie, $dir_servidor, $nome_serie, $data= NULL, $comentario ){
    $PDO = getofficeconnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO `novas_series`(`ID`, `titulo`, `diretorio_servidor`, `diretorio_imagem`, `data`, `comentario`) VALUES (NULL, '$titulo_serie', '$dir_servidor', '$nome_serie', NOW(), '$comentario')";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}
function getPaginaLoginRevenda($userid)
{
    $result = getuserproperty($userid, "test_key");
    if (!$result) {
        $result = getRandomMD5($userid);
        if (!adduserproperty($userid, "test_key", $result)) {
            return "You dont have a test url :c";
        }
    }
    return getBaseURL() . "?l=" . $result;
}
function getPaginaWebPlayer($userid)
{
    $result = getuserproperty($userid, "test_key");
    if (!$result) {
        $result = getRandomMD5($userid);
        if (!adduserproperty($userid, "test_key", $result)) {
            return "You dont have a test url :c";
        }
    }
    return getBaseURL() . "?web=" . $result;
}



function webtvpanel_CallApiRequest($ApiLinkIs = '')
{
    $returnData = '0';
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $ApiLinkIs);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

    if (curl_exec($ch) === false) {
        return array('result' => 'error', 'data' => 'Invalid Host Url');
    }

    $Result = json_decode(curl_exec($ch));

    if (!empty($Result)) {
        $returnData = $Result;
        return array('result' => 'success', 'data' => $returnData);
    }

    return array('result' => 'error');
}

function substituiStatus($status, $conta){
    $statusAtual = $status;
    $conta = $conta;
    if ($statusAtual == "Active" && $conta == 1) {
        $texto = substr_replace($statusAtual, 'Ativo', 0);
        $statusAlterado  = array('texto' => $texto, 'cor' => 'danger');
        return $statusAlterado;
    }else{
        $texto = substr_replace($statusAtual, 'Ativo', 0);
        $statusAlterado  = array('texto' => $texto, 'cor' => 'success');
        return $statusAlterado;
    }
}

function verificaConta($conta){
    $conta = $conta;
    if ($conta == 0) {
        $contaAtual = array('texto' => 'Plano OFFICIAL', 'cor' => 'info');
        return $contaAtual;
    }else{
       $contaAtual = array('texto' => 'Plano gratuito (TESTE)', 'cor' => 'danger');
       return $contaAtual;
   }
}

function verificaTelas($telas){
    $telas = $telas;
    if ($telas) {
        $quantidadeTelas = array('texto' => $telas, 'cor' => 'info');
        return 1;
    }
}

function buscarBouquetCliente($usuario, $senha)
{
    $user = $usuario;
    $pass = $senha;
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `users` WHERE `username` = :username AND `password` LIKE :password LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":username", $user, PDO::PARAM_STR, 50);
        $stmt->bindParam(":password", $pass, PDO::PARAM_STR, 255);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
    return false;
}

function buscarIDcliente($usuario, $senha)
{
    $user = $usuario;
    $pass = $senha;
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM `users` WHERE `username` = :username AND `password` LIKE :password LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":username", $user, PDO::PARAM_STR, 50);
        $stmt->bindParam(":password", $pass, PDO::PARAM_STR, 255);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
    return false;
}

function pegarIPusuario() {
    $ipaddress = '';
    if (isset($_SERVER['HTTP_CLIENT_IP']))
        $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
    else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
        $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
    else if(isset($_SERVER['HTTP_X_FORWARDED']))
        $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
    else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
        $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
    else if(isset($_SERVER['HTTP_FORWARDED']))
        $ipaddress = $_SERVER['HTTP_FORWARDED'];
    else if(isset($_SERVER['REMOTE_ADDR']))
        $ipaddress = $_SERVER['REMOTE_ADDR'];
    else
        $ipaddress = 'UNKNOWN';
    return $ipaddress;
}

function pegarRegiao()
{
    $ip = pegarIPusuario();
    $query = "http://ip-api.com/json/".$ip."?fields=status,message,country,countryCode,region,regionName,city,zip,lat,lon,timezone,isp,org,as,mobile,query";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $query);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

    if (curl_exec($ch) === false) {
        return array('resultado' => 'error', 'data' => 'Link invalido');
    }
    $Result = json_decode(curl_exec($ch));

    if (!empty($Result)) {
        $returnData = $Result;
        return array('resultado' => 'success', 'data' => $returnData);
    }

    return array('resultado' => 'error');

}

function verificaDispositivo ()
{
    $iphone = strpos($_SERVER['HTTP_USER_AGENT'],"iPhone");
    $ipad = strpos($_SERVER['HTTP_USER_AGENT'],"iPad");
    $android = strpos($_SERVER['HTTP_USER_AGENT'],"Android");
    $palmpre = strpos($_SERVER['HTTP_USER_AGENT'],"webOS");
    $berry = strpos($_SERVER['HTTP_USER_AGENT'],"BlackBerry");
    $ipod = strpos($_SERVER['HTTP_USER_AGENT'],"iPod");
    $symbian = strpos($_SERVER['HTTP_USER_AGENT'],"Symbian");
    $windowsphone = strpos($_SERVER['HTTP_USER_AGENT'],"Windows Phone");

    if ($iphone || $ipad || $android || $palmpre || $ipod || $berry || $symbian || $windowsphone == true) {
       $dispositivo = "mobile";
       return $dispositivo;
   }

   else { return $dispositivo = "computador";} 
}

function verificarLinkQuebrado($url, $limite = 5){
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $url);        // Inicia uma nova sessão do cURL
    curl_setopt($curl, CURLOPT_TIMEOUT, $limite); // Define um tempo limite da requisição
    curl_setopt($curl, CURLOPT_NOBODY, true);     // Define que iremos realizar uma requisição "HEAD"
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, false); // Não exibir a saída no navegador
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false); // Não verificar o certificado do site

    curl_exec($curl);  // Executa a sessão do cURL
    $status = curl_getinfo($curl, CURLINFO_HTTP_CODE) == 200; // Se a resposta for OK, a URL está ativa
    curl_close($curl); // Fecha a sessão do cURL

    return $status;
}
function curlUrl($ApiLinkIs = '')
{

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $ApiLinkIs);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

    $Result = json_decode(curl_exec($ch));

    

    return $Result;
}
function serverMonitoracao(){
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT *, SUBSTRING_INDEX(SUBSTRING_INDEX(watchdog_data, ',', 1), ':', -1) AS cpu, SUBSTRING_INDEX(SUBSTRING_INDEX(watchdog_data, ',', 12), ':', -1) AS down, SUBSTRING_INDEX(SUBSTRING_INDEX(watchdog_data, ',', 11), ':', -1) AS up, SUBSTRING_INDEX(SUBSTRING_INDEX(watchdog_data, ',', 9), ':', -1) AS uptime  FROM streaming_servers";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}

function testantoO(){
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT on_demand,current_source,stream_source,stream_info,stream_status,stream_started,diff_time_main,stream_id,streams.id,stream_display_name from streams left join streams_sys on streams.id = streams_sys.stream_id left join streaming_servers on streams_sys.server_id = streaming_servers.id 
        LEFT JOIN stream_categories on streams.category_id = stream_categories.id WHERE type = 1 ORDER BY cat_order;";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}
function secondsToTime($inputSeconds) {

    $secondsInAMinute = 60;
    $secondsInAnHour  = 60 * $secondsInAMinute;
    $secondsInADay    = 24 * $secondsInAnHour;

    // extract days
    $days = floor($inputSeconds / $secondsInADay);

    // extract hours
    $hourSeconds = $inputSeconds % $secondsInADay;
    $hours = floor($hourSeconds / $secondsInAnHour);

    // extract minutes
    $minuteSeconds = $hourSeconds % $secondsInAnHour;
    $minutes = floor($minuteSeconds / $secondsInAMinute);

    // extract the remaining seconds
    $remainingSeconds = $minuteSeconds % $secondsInAMinute;
    $seconds = ceil($remainingSeconds);

    // return the final array
    $obj = array(
        'd' => (int) $days,
        'h' => (int) $hours,
        'm' => (int) $minutes,
        's' => (int) $seconds,
    );
//    return $obj;
    if ($days >=1) return $days. "d".$hours . "h" . $minutes . "m" . $seconds . "s";
    if ($hours >=1) return $hours . "h" . $minutes . "m" . $seconds . "s";
    if ($minutes >=1) return $minutes . "m" . $seconds . "s";
    if ($seconds >=1) return $seconds . "s";
    return $seconds . "s";
    return $days. "d".$hours . "h" . $minutes . "m" . $seconds . "s";
}
function iniciaStream($streamid){
    $id = $streamid;
    $dns = getServerDNS();
    $resultado = file_get_contents("$dns/api.php?action=stream&sub=start&stream_ids[]=$id");

    return $resultado;
}
function paraStream($streamid){
    $id = $streamid;
    $dns = getServerDNS();
    $resultado = file_get_contents("$dns/api.php?action=stream&sub=stop&stream_ids[]=$id");

    return $resultado;
}
function reiniciaStream($streamid){
    $id = $streamid;
    $dns = getServerDNS();
    $resultado = file_get_contents("$dns/api.php?action=stream&sub=start&stream_ids[]=$id");

    return $resultado;
}
function logDeCreditosRevenda($idMaster, $idUsuario){
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM credits_log WHERE admin_id = :idMaster AND target_id = :idUsuario ORDER BY reason ASC;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":idMaster", $idMaster, PDO::PARAM_INT);
        $stmt->bindParam(":idUsuario", $idUsuario, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    return array();
    //var_dump($stmt); die();
}

function deletarTodosOsTestes($remove_expired, $remove_test, $start_date, $end_date)
{

    // var_dump($end_date); die();
    if (!$remove_expired && !$remove_test) {
        return false;
    }
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "DELETE FROM `users` WHERE `created_at` >= :start_date AND `created_at` <= :end_date";
        if ($remove_expired) {
            $sql .= " AND unix_timestamp(NOW()) > `exp_date`";
        }
        if ($remove_test) {
            $sql .= " AND `is_trial` = 1";
        }
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":start_date", $start_date, PDO::PARAM_INT);
        $stmt->bindParam(":end_date", $end_date, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function canaisOnOff(){
    $tess = testantoO();
    $resultado =  array_map(
      function ($value) { 
        return $value['stream_status'];
    }, $tess);
    return array_count_values($resultado);
}

function pegarCategoriasStreams(){
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM stream_categories WHERE category_type = 'live';";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}

function pegarCategoriasMovie(){
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM stream_categories WHERE category_type = 'movie';";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}

function pegarCategoriasSeries(){
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM stream_categories WHERE category_type = 'series';";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}

function pegarUltimoCatOrder($tipo){
    $tipo_da_categoria = $tipo;

    if ($tipo_da_categoria == 'live') {
        $query = "SELECT cat_order FROM stream_categories WHERE category_type = 'live' ORDER BY cat_order DESC LIMIT 1;";
    }
    if ($tipo_da_categoria == 'movie') {
        $query = "SELECT cat_order FROM stream_categories WHERE category_type = 'movie' ORDER BY cat_order DESC LIMIT 1;";
    }
    if ($tipo_da_categoria == 'series') {
        $query = "SELECT cat_order FROM stream_categories WHERE category_type = 'series' ORDER BY cat_order DESC LIMIT 1;";
    }

    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = $query;
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}

function adicionarCategoria($nome_nova_categoria, $tipo_categoria){
    $nv_cat_nome = $nome_nova_categoria;
    $tipo = $tipo_categoria;

    $pegar_ult_cat_order = pegarUltimoCatOrder($tipo);
    $ultimo_cat_order = intval($pegar_ult_cat_order[0]['cat_order']);
    $ultimo_cat_order++;

    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO stream_categories (id, category_type, category_name, parent_id, cat_order) VALUES (NULL, :tipo_cat, :nome_cat, 0, :nv_cat_order);";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":nome_cat", $nv_cat_nome, PDO::PARAM_STR, 255);
        $stmt->bindParam(":tipo_cat", $tipo, PDO::PARAM_STR, 50);
        $stmt->bindParam(":nv_cat_order", $ultimo_cat_order, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function atualizarNomeCategoria($cat_id, $nv_nome){
    $categoria = $cat_id;
    $nome = $nv_nome;

    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "UPDATE stream_categories SET category_name = :nome WHERE id = :id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":nome", $nome, PDO::PARAM_STR, 255);
        $stmt->bindParam(":id", $categoria, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function pegarPacotes(){
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT id, package_name, is_trial, is_official, official_credits, trial_credits, trial_duration, trial_duration_in, official_duration, official_duration_in FROM packages;";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}

function pegarGrupos(){
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT group_id, group_name, is_banned, is_admin, is_reseller, create_sub_resellers FROM member_groups;";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}

function pegarEpg(){
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM epg;";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}

function atualizarEpg($id1, $epg_name1, $epg_link1, $epg_dias1){
    $id          = $id1;
    $epg_name    = $epg_name1;
    $epg_link    = $epg_link1;
    $epg_dias    = $epg_dias1;

    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "UPDATE epg SET epg_name = :epg_name, epg_file = :epg_link, days_keep = :epg_dias WHERE id = :id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":id", $id, PDO::PARAM_INT);
        $stmt->bindParam(":epg_name", $epg_name, PDO::PARAM_STR, 255);
        $stmt->bindParam(":epg_link", $epg_link, PDO::PARAM_STR, 255);
        $stmt->bindParam(":epg_dias", $epg_dias, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function excluirEpg($id){
    $id          = $id;

    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "DELETE FROM epg WHERE id = :id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":id", $id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function excluirPacote($id){
    $id_pac          = $id;

    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "DELETE FROM packages WHERE id = :id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":id", $id_pac, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function excluirCategoria($id){
    $id_cat          = $id;

    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "DELETE FROM stream_categories WHERE id = :id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":id", $id_cat, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function atualizarPacote($id, $pac_nome, $eTeste, $tempo_teste, $creditos_teste, $eOfficial, $tempo_official, $creditos_official, $hora_teste, $hora_official){
    $id1 = $id;
    $pac_nome1 = $pac_nome;
    $eTeste1 = $eTeste;
    $tempo_teste1 = $tempo_teste;
    $hora_teste1 = $hora_teste;
    $creditos_teste1 = $creditos_teste;
    $eOfficial1 = $eOfficial;
    $tempo_official1 = $tempo_official;
    $hora_official1 = $hora_official;
    $creditos_official1 = $creditos_official;

    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "UPDATE epg SET epg_name = :epg_name, epg_file = :epg_link, days_keep = :epg_dias WHERE id = :id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":id", $id, PDO::PARAM_INT);
        $stmt->bindParam(":epg_name", $epg_name, PDO::PARAM_STR, 255);
        $stmt->bindParam(":epg_link", $epg_link, PDO::PARAM_STR, 255);
        $stmt->bindParam(":epg_dias", $epg_dias, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}
function GetConnections($end, $server_id = NULL)
{
    $extra = "";

    if (!is_null($server_id)) {
        $extra = "WHERE t1.server_id = '" . intval($server_id) . "'";
    }

    switch ($end) {
        case "open":
        $sql = "\n                SELECT t1.*,t2.*,t3.*,t4.*,t5.mac,t6.bitrate\n                FROM `user_activity_now` t1\n                LEFT JOIN `users` t2 ON t2.id = t1.user_id\n                LEFT JOIN `streams` t3 ON t3.id = t1.stream_id\n                LEFT JOIN `streaming_servers` t4 ON t4.id = t1.server_id\n                LEFT JOIN `mag_devices` t5 on t5.user_id = t2.id\n                LEFT JOIN `streams_sys` t6 ON t6.stream_id = t1.stream_id AND t6.server_id = t1.server_id\n                $extra\n                ORDER BY t1.activity_id DESC";
        break;

        case "closed":
        $sql = "\n                SELECT t1.*,t2.*,t3.*,t4.*,t5.mac,t6.bitrate\n                FROM `user_activity` t1\n                LEFT JOIN `users` t2 ON t2.id = t1.user_id\n                LEFT JOIN `streams` t3 ON t3.id = t1.stream_id\n                LEFT JOIN `streaming_servers` t4 ON t4.id = t1.server_id\n                LEFT JOIN `mag_devices` t5 on t5.user_id = t2.id\n                LEFT JOIN `streams_sys` t6 ON t6.stream_id = t1.stream_id AND t6.server_id = t1.server_id\n                $extra\n                ORDER BY t1.activity_id DESC";
        break;
    }

    $PDO = getconnection();
    if ($PDO !== NULL) {
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $count = $stmt->rowCount();
            return $count;
        }
    }
    return false;
}
function memory_usage()
{

    $memory_usage = trim(shell_exec("free -m"));

    if (empty($memory_usage)) {
        return false;
    }

    $data = explode("\n", $memory_usage);
    $memory_usage = array();
    $swap_usage = array();

    foreach ($data as $line ) {
        $output = preg_replace("!\s+!", " ", str_replace(":", "", $line));
        if (!strstr($output, "Mem") && !strstr($output, "Swap")) {
            continue;
        }

        $info = explode(" ", $output);

        if ($info[0] == "Mem") {
            $memory_usage["total"] = $info[1];
            $memory_usage["used"] = $info[2] - $info[6];

            if ($memory_usage["used"] < 0) {
                $memory_usage["used"] = $info[2];
            }

            $memory_usage["free"] = $info[3];
            $memory_usage["percent"] = sprintf("%0.2f", ($memory_usage["used"] / $memory_usage["total"]) * 100);
        }
        else {
            $swap_usage["total"] = $info[1];
            $swap_usage["used"] = $info[2];
            $swap_usage["free"] = $info[3];

            if ($swap_usage["total"] != 0) {
                $swap_usage["percent"] = sprintf("%0.2f", ($info[2] / $info[1]) * 100);
            }
            else {
                $swap_usage["percent"] = 0;
            }
        }
    }

    return array($memory_usage, $swap_usage);
}


function pegarStatusLista($username, $password){

    $UserName = $username;
    $UserPassword = $password;

    $bar = '/';
    $XCStreamHostUrl = DNS_XTREAM_CODES;
    if (substr($XCStreamHostUrl, -1) == '/') {
        $bar = '';
    }

    $XCStreamHostUrl = $XCStreamHostUrl . $bar;
    $ApiLinkIs = $XCStreamHostUrl . 'player_api.php?username=' . $UserName . '&password=' . $UserPassword;

    $Result = webtvpanel_CallApiRequest($ApiLinkIs);

    if ($Result['result'] == 'success') {
        return $Result;
    }else{
        return 'Não foi possivel';
    }
}

function pegarInfoStreamID($id){
    $id        = $id;
    
    

    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT stream_display_name, stream_source, stream_icon, epg_id, channel_id FROM streams WHERE id = :id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":id", $id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return $stmt->fetchAll(PDO::FETCH_ASSOC);;
        }
    }
    return false;
}



function editarStreamId($id, $stream_display_name, $stream_source, $stream_icon){
    $id        = $id;
    $nome_canal = $stream_display_name;
    $url_canal  = $stream_source;
    $logo_canal = $stream_icon;
    

    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "UPDATE streams SET stream_display_name = :canal_nome, stream_source = :canal_link, stream_icon = :canal_logo WHERE id = :id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":id", $id, PDO::PARAM_INT);
        $stmt->bindParam(":canal_nome", $nome_canal, PDO::PARAM_STR, 255);
        $stmt->bindParam(":canal_link", $stream_source, PDO::PARAM_STR, 500);
        $stmt->bindParam(":canal_logo", $stream_icon, PDO::PARAM_STR, 500);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function pegarEpgChannelID(){   

    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT epg_id, channel_id FROM epg_data LIMIT 1000;";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            return $stmt->fetchAll(PDO::FETCH_ASSOC);;
        }
    }
    return false;
}

function limpar($texto){

    return str_replace('"',"", str_replace('"',"", str_replace("]","", str_replace("\\","", str_replace("[", "", nl2br($texto))))));
}

function getUserIP()
{
    foreach (array("REMOTE_ADDR", "HTTP_INCAP_CLIENT_IP", "HTTP_CF_CONNECTING_IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED") as $key ) {
        if (array_key_exists($key, $_SERVER) === true) {
            foreach (explode(",", $_SERVER[$key]) as $IPaddress ) {
                $IPaddress = trim($IPaddress);

                if (filter_var($IPaddress, FILTER_VALIDATE_IP) !== false) {
                    return $IPaddress;
                }
            }
        }
    }
}

function tmdbAPI($link){
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $link,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_POSTFIELDS => "{}",
    ));

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    if ($err) {
        return "cURL Error #:" . $err;
    } else {
      return $response;
  }
}
function UrlAtual(){
 $dominio= $_SERVER['HTTP_HOST'].'/';
 $url = isset($_SERVER['HTTPS']) ? 'https' : 'http'.'://' . $dominio;
 return $url;
}

function salvarImagemTMDBposter ($link, $id_tmdb_filme){

  $url = $link;
  $id = $id_tmdb_filme;
  $i = 0;


  $img = file_get_contents($url);
  if ($img) {
      $resulta = file_put_contents("temp/assets/images/tmdb_img/".$id."_movie_poster_".$i.".jpg",$img);
      $caminho = '/temp/assets/images/tmdb_img/'.$id.'_movie_poster_'.$i.'.jpg';
      return array('result' => 'success', 'data' => $caminho);

  }
  return false;
}

function salvarImagemTMDBbackgrouond ($link, $id_tmdb_filme){

  $url = $link;
  $id = $id_tmdb_filme;
  $i = 0;


  $img = file_get_contents($url);
  if ($img) {
      $resulta = file_put_contents("temp/assets/images/tmdb_img/".$id."_movie_backdrop_".$i.".jpg",$img);
      $caminho = '/temp/assets/images/tmdb_img/'.$id.'_movie_backdrop_'.$i.'.jpg';
      return array('result' => 'success', 'data' => $caminho);

  }
  return false;
}


function adicionarFilme($type, $category_id, $stream_display_name, $stream_source, $stream_icon, $notes, $enable_transcode, $movie_propeties, $target_container, $added, $direct_source, $redirect_stream, $probesize_ondemand, $map_custom, $transcod_attr){

    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO streams (id, type, category_id, stream_display_name, stream_source, stream_icon, notes, enable_transcode, movie_propeties, target_container, added, direct_source, redirect_stream, probesize_ondemand, custom_map, transcode_attributes)
        VALUES (NULL, :tipo, :categoria, :nome_filme, :link_filme, :capa_filme, :nota_filme, :transcode, :info_filme, :tipo_mp4, :adicionado, :link_direto, :redirecionar, :on_demand, :custom_map, :transcode_attrib);";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":tipo", $type, PDO::PARAM_INT);
        $stmt->bindParam(":categoria", $category_id, PDO::PARAM_INT);
        $stmt->bindParam(":nome_filme", $stream_display_name, PDO::PARAM_STR, 255);
        $stmt->bindParam(":link_filme", $stream_source, PDO::PARAM_STR, 255);
        $stmt->bindParam(":capa_filme", $stream_icon, PDO::PARAM_STR, 255);
        $stmt->bindParam(":nota_filme", $notes, PDO::PARAM_STR, 255);
        $stmt->bindParam(":transcode", $enable_transcode, PDO::PARAM_INT);
        $stmt->bindParam(":info_filme", $movie_propeties, PDO::PARAM_STR, 8000);
        $stmt->bindParam(":tipo_mp4", $target_container, PDO::PARAM_STR, 255);
        $stmt->bindParam(":adicionado", $added, PDO::PARAM_STR, 255);
        $stmt->bindParam(":link_direto", $direct_source, PDO::PARAM_INT);
        $stmt->bindParam(":redirecionar", $redirect_stream, PDO::PARAM_INT);
        $stmt->bindParam(":on_demand", $probesize_ondemand, PDO::PARAM_INT);
        $stmt->bindParam(":custom_map", $map_custom, PDO::PARAM_STR, 255);
        $stmt->bindParam(":transcode_attrib", $transcod_attr, PDO::PARAM_STR, 255);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function buscarFilmes(){
    $PDO = getconnection();
    if ($PDO !== NULL) {
        $sql = "SELECT on_demand,current_source,stream_source,stream_info,stream_status,stream_started,diff_time_main,stream_id,streams.id,stream_display_name from streams left join streams_sys on streams.id = streams_sys.stream_id left join streaming_servers on streams_sys.server_id = streaming_servers.id 
        LEFT JOIN stream_categories on streams.category_id = stream_categories.id WHERE type = 2 ORDER BY cat_order;";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}

?>
