<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Caminho para o banco de dados SQLite
//$dbFile = '/home/rockstar/mytvfun.rockstards.com.br/mytv_api/api/.db.db';
 // Conecta ao banco de dados SQLite
        $dbFile = '/home2/ultrad97/americamais.com/mytvfun/mytv_api/api/.db.db';
  
$table_name = "dns"; // Nome da tabela a ser gerenciada

// Função para conectar ao banco de dados
function connectDb($dbFile) {
    $db = new SQLite3($dbFile);
    if (!$db) {
        die("Erro ao conectar ao banco de dados.");
    }
    return $db;
}

// Processar ações do formulário
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $action = $_POST['action'] ?? '';
    $db = connectDb($dbFile);

    if ($action == "add") {
        $columns = $_POST['columns'];
        $values = $_POST['values'];
        $columnsStr = implode(", ", array_map('trim', $columns));
        $placeholders = implode(", ", array_fill(0, count($values), '?'));
        $stmt = $db->prepare("INSERT INTO $table_name ($columnsStr) VALUES ($placeholders)");
        foreach ($values as $key => $value) {
            $stmt->bindValue($key + 1, $value);
        }
        $stmt->execute();
        echo "Registro adicionado com sucesso.";
    } elseif ($action == "edit") {
        $id = $_POST['id'];
        $columns = $_POST['columns'];
        $values = $_POST['values'];
        $setStr = implode(", ", array_map(fn($col) => "$col = ?", $columns));
        $stmt = $db->prepare("UPDATE $table_name SET $setStr WHERE id = ?");
        foreach ($values as $key => $value) {
            $stmt->bindValue($key + 1, $value);
        }
        $stmt->bindValue(count($values) + 1, $id);
        $stmt->execute();
        echo "Registro atualizado com sucesso.";
    } elseif ($action == "delete") {
        $id = $_POST['id'];
        $stmt = $db->prepare("DELETE FROM $table_name WHERE id = ?");
        $stmt->bindValue(1, $id);
        $stmt->execute();
        echo "Registro removido com sucesso.";
    }
    $db->close();
}

?>
<!DOCTYPE html>
<html>
<head>
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
        }
        th, td {
            border: 1px solid #dddddd;
            text-align: left;
            padding: 8px;
        }
        th {
            background-color: #f2f2f2;
        }
        form {
            margin: 20px 0;
        }
        label, input, textarea {
            display: block;
            margin-bottom: 10px;
        }
    </style>
    <title>Gerenciar Banco de Dados SQLite</title>
</head>
<body>
    <h2>Dados da Tabela SQLite: <?php echo $table_name; ?></h2>
    <table>
        <thead>
            <tr>
                <?php
                $db = connectDb($dbFile);
                $columnsQuery = $db->query("PRAGMA table_info($table_name)");
                $columns = [];
                while ($column = $columnsQuery->fetchArray(SQLITE3_ASSOC)) {
                    $columns[] = $column['name'];
                    echo "<th>" . $column['name'] . "</th>";
                }
                echo "<th>Ações</th>";
                $db->close();
                ?>
            </tr>
        </thead>
        <tbody>
            <?php
            $db = connectDb($dbFile);
            $dataQuery = $db->query("SELECT * FROM $table_name");
            while ($row = $dataQuery->fetchArray(SQLITE3_ASSOC)) {
                echo "<tr>";
                foreach ($row as $value) {
                    echo "<td>$value</td>";
                }
                echo '<td>
                        <form style="display:inline;" method="post">
                            <input type="hidden" name="id" value="' . $row['id'] . '">
                            <input type="hidden" name="action" value="edit">
                            <button type="button" onclick="loadEditForm(' . htmlspecialchars(json_encode($row)) . ')">Editar</button>
                        </form>
                        <form style="display:inline;" method="post">
                            <input type="hidden" name="id" value="' . $row['id'] . '">
                            <input type="hidden" name="action" value="delete">
                            <button type="submit">Remover</button>
                        </form>
                      </td>';
                echo "</tr>";
            }
            $db->close();
            ?>
        </tbody>
    </table>

    <h2>Adicionar Novo Registro</h2>
    <form method="post">
        <input type="hidden" name="action" value="add">
        <?php foreach ($columns as $col): ?>
            <?php if ($col != "id"): // Ignorar a coluna ID, geralmente autoincrement ?>
                <label for=""><?php echo $col; ?>:</label>
                <input type="text" name="values[]" required>
            <?php endif; ?>
        <?php endforeach; ?>
        <button type="submit">Adicionar</button>
    </form>

    <h2>Editar Registro</h2>
    <form id="editForm" method="post">
        <input type="hidden" name="action" value="edit">
        <input type="hidden" name="id" id="editId">
        <?php foreach ($columns as $col): ?>
            <?php if ($col != "id"): ?>
                <label for=""><?php echo $col; ?>:</label>
                <input type="text" name="values[]" id="edit_<?php echo $col; ?>" required>
            <?php endif; ?>
        <?php endforeach; ?>
        <button type="submit">Salvar Alterações</button>
    </form>

    <script>
        function loadEditForm(data) {
            document.getElementById('editId').value = data.id;
            <?php foreach ($columns as $col): ?>
                <?php if ($col != "id"): ?>
                    document.getElementById('edit_<?php echo $col; ?>').value = data['<?php echo $col; ?>'];
                <?php endif; ?>
            <?php endforeach; ?>
        }
    </script>
</body>
</html>