<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

    $dbFile = '/home/rockstar/mytvfun.rockstards.com.br/mytv_api/api/.db.db';
$adb = new SQLite3($dbFile);
$db = $adb;

$table_name = "dns";
$query = "PRAGMA table_info($table_name)";

// Executar a consulta
$result = $db->query($query);

// Verificar se a consulta foi bem-sucedida
if (!$result) {
    echo "Erro ao executar a consulta.";
    exit;
}

// Loop através dos resultados e imprimir a estrutura da tabela
while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
    echo "Nome da coluna: " . $row['name'] . "<br>";
    echo "Tipo de dado: " . $row['type'] . "<br>";
    echo "Permite nulo: " . ($row['notnull'] ? "Não" : "Sim") . "<br>";
    echo "Valor padrão: " . ($row['dflt_value'] !== null ? $row['dflt_value'] : "Nenhum") . "<br>";
    echo "Chave primária: " . ($row['pk'] ? "Sim" : "Não") . "<br><br>";
}

?>

<!DOCTYPE html>
<html>
<head>
      <style>
        table {
            border-collapse: collapse;
            width: 100%;
        }
        th, td {
            border: 1px solid #dddddd;
            text-align: left;
            padding: 8px;
        }
        th {
            background-color: #f2f2f2;
        }
    </style>
    <title>Executar Consultas SQLite</title>
</head>
<body>
     <h2>Dados da Tabela SQLite</h2>

    <table>
        <thead>
            <tr>
                <?php
               

                // Conectar ao banco de dados SQLite
                $db = new SQLite3($dbFile);

                // Verificar se a conexão foi estabelecida com sucesso
                if (!$db) {
                    echo "Erro ao conectar ao banco de dados.";
                    exit;
                }

                // Consulta para obter os nomes das colunas da tabela
                $columnsQuery = $db->query("PRAGMA table_info($table_name)");

                // Verificar se a consulta foi bem-sucedida
                if (!$columnsQuery) {
                    echo "Erro ao obter as colunas da tabela.";
                    exit;
                }

                // Loop para exibir os nomes das colunas na tabela HTML
                while ($column = $columnsQuery->fetchArray(SQLITE3_ASSOC)) {
                    echo "<th>" . $column['name'] . "</th>";
                }

                // Fechar conexão com o banco de dados
                $db->close();
                ?>
            </tr>
        </thead>
        <tbody>
            <?php
            // Conectar novamente ao banco de dados SQLite
            $db = new SQLite3($dbFile);

            // Verificar se a conexão foi estabelecida com sucesso
            if (!$db) {
                echo "<tr><td colspan='" . $columnsQuery->numColumns() . "'>Erro ao conectar ao banco de dados.</td></tr>";
                exit;
            }

            // Consulta para obter todos os dados da tabela
            $dataQuery = $db->query("SELECT * FROM $table_name");

            // Verificar se a consulta foi bem-sucedida
            if (!$dataQuery) {
                echo "<tr><td colspan='" . $columnsQuery->numColumns() . "'>Erro ao obter dados da tabela.</td></tr>";
                exit;
            }

            // Loop para exibir os dados na tabela HTML
            while ($row = $dataQuery->fetchArray(SQLITE3_ASSOC)) {
                echo "<tr>";
                foreach ($row as $value) {
                    echo "<td>$value</td>";
                }
                echo "</tr>";
            }

            // Fechar conexão com o banco de dados
            $db->close();
            ?>
        </tbody>
    </table>
    <h2>Executar Consultas SQLite</h2>

    <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
        <label for="consulta">Consulta SQL:</label><br>
        <textarea id="consulta" name="consulta" rows="4" cols="50"></textarea><br><br>
        <input type="submit" value="Executar Consulta">
    </form>

    <?php
    // Verificar se o formulário foi submetido
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
     
        // Verificar se a consulta está presente e não está vazia
        if (isset($_POST['consulta']) && !empty(trim($_POST['consulta']))) {
            // Conectar ao banco de dados SQLite
            $db = new SQLite3($dbFile);

            // Verificar se a conexão foi estabelecida com sucesso
            if (!$db) {
                echo "Erro ao conectar ao banco de dados.";
                exit;
            }

            // Pegar a consulta do formulário
            $consulta = $_POST['consulta'];

            // Executar a consulta
            $result = $db->query($consulta);

            // Verificar se a consulta foi bem-sucedida
            if ($result) {
                // Se a consulta for uma consulta SELECT
                if (strpos(strtolower($consulta), 'select') !== false) {
                    echo "<h2>Resultado da Consulta:</h2>";
                    echo "<pre>";
                    while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
                        print_r($row);
                    }
                    echo "</pre>";
                } else {
                    echo "Consulta executada com sucesso.";
                }
            } else {
                echo "Erro ao executar a consulta.";
            }

            // Fechar conexão com o banco de dados
            $db->close();
        } else {
            echo "Por favor, forneça uma consulta SQL.";
        }
    }
    ?>
</body>
</html>