<?php

include_once './system/functions.php';
isLogged();
$logged_user = getLoggedUser();
if (!isAdmin($logged_user) && getServerProperty("manutencaoPainel", 0)) {
  header("Location: ./sair.php");
  exit();
}
$server_name = getServerProperty("server_name");
$fast_packages = json_decode(getServerProperty("fast_packages"), true);
$logotipo = getUserProperty($logged_user['id'], "logotipo");
$titulo = getUserProperty($logged_user['id'], "nomePainel");
$copyright = getUserProperty($logged_user['id'], "copyright");
if (!isset($_GET["ticket_id"])) {
	exit;
}
$ticket_id = intval($_GET["ticket_id"]);
$ticket = getTicketByID($ticket_id);
if (!$ticket) {
	exit;
}
if ($ticket["member_id"] !== $logged_user["id"] && !isAdmin($logged_user)) {
	exit;
}
if (isset($_POST["send_message"]) && isset($_POST["message"]) && $ticket["status"]) {
	$message = $_POST["message"];
	$admin_reply_ = isAdmin($logged_user) ? 1 : 0;
	insertTicketReply($ticket_id, $admin_reply_, $message);
	$other_person = isAdmin($logged_user) ? "user" : "admin";
	updateReadTicket($ticket_id, $other_person, 0);
	header("location: ?ticket_id=" . $ticket_id . "&result=success");
	exit;
}
$reseller = getUserById($ticket["member_id"]);
$reseller_name = $reseller ? $reseller["username"] : "Desconhecido(Não encontrado)";
$ticket_replies = getTicketReplies($ticket_id);
$person = isAdmin($logged_user) ? "admin" : "user";
updateReadTicket($ticket_id, $person, 1);
?>
<!DOCTYPE html>
<html class="no-js css-menubar" lang="en">
<head>
	<style type="text/css">
		.paragrafo1{

			color: #ff0000;

		}
	</style>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
	<meta name="description" content="bootstrap admin template">
	<meta name="author" content="">

	<title>CHAMADOS</title>

	<link rel="apple-touch-icon" href="temp/assets/images/apple-touch-icon.png">
	<link rel="shortcut icon" href="temp/assets/images/favicon.ico">

	<!-- Stylesheets -->
	<link rel="stylesheet" href="temp/global/css/bootstrap.min.css">
	<link rel="stylesheet" href="temp/global/css/bootstrap-extend.min.css">
	<link rel="stylesheet" href="temp/assets/css/site.min.css">
	<link rel="stylesheet" href="temp/assets/css/responsive.bootstrap.min.css">
	<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet"/>
	<link rel="stylesheet" href="temp/global/vendor/toastr/toastr.css">
	<link rel="stylesheet" href="temp/assets/examples/css/advanced/toastr.css">


	<!-- Plugins -->
	<link rel="stylesheet" href="temp/global/vendor/animsition/animsition.css">
	<link rel="stylesheet" href="temp/global/vendor/asscrollable/asScrollable.css">
	<link rel="stylesheet" href="temp/global/vendor/switchery/switchery.css">
	<link rel="stylesheet" href="temp/global/vendor/intro-js/introjs.css">
	<link rel="stylesheet" href="temp/global/vendor/slidepanel/slidePanel.css">
	<link rel="stylesheet" href="temp/global/vendor/flag-icon-css/flag-icon.css">
	<link rel="stylesheet" href="temp/global/vendor/footable/footable.core.css">
	<link rel="stylesheet" href="temp/assets/examples/css/tables/footable.css">


	<!-- Fonts -->
	<link rel="stylesheet" href="temp/global/fonts/font-awesome/font-awesome.css">
	<link rel="stylesheet" href="temp/global/fonts/web-icons/web-icons.min.css">
	<link rel="stylesheet" href="temp/global/fonts/brand-icons/brand-icons.min.css">
	<link rel='stylesheet' href='http://fonts.googleapis.com/css?family=Roboto:300,400,500,300italic'>
	<link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">


	<!-- Scripts -->
	<script src="temp/global/vendor/breakpoints/breakpoints.js"></script>
	<script>
		Breakpoints();
	</script>
</head>
<?php 
include_once "./incluir/menu_lateral.php";
?>


<!-- Page -->
<div class="page">
	<div class="page-header">
		<h1 class="page-title">Abrir chamado</h1>
		<ol class="breadcrumb">
			<li class="breadcrumb-item"><a href="/">Painel</a></li>
			<li class="breadcrumb-item active">Abrir chamado</li>
		</ol>
		<?php  
		if (isset($_GET["result"])) {
			$result = $_GET["result"];
			$result_message = "Aconteceu um problema, tente novamente mais tarde!";
			$result_type = "warning";
			switch ($result) {
				case "success":
				$result_message = "O ticket foi enviado com sucesso.";
				$result_type = "success";
				break;
			}
			echo "<div id='toast-bottomFullWidth' class='toast-bottom-full-width' aria-live='polite' role='alert'>
			<div class='toast toast-$result_type' style=''>
			<div class='toast-message'>$result_message</div>
			</div>
			</div>";
		}
		?>
	</div>
	<div class="page-content panel-bordered panel-danger">
		<div class="card card-block p-30 bg-red-600">
			<div class="card-watermark darker font-size-80 m-15"><i class="icon wb-users" aria-hidden="true"></i></div>
			<div class="counter counter-md counter-inverse text-left">
				<div class="counter-number-group">
					<span class="counter-number">Assunto: <b>#<?php echo $ticket["title"]; ?></b></span>
				</div>
				<div class="counter-label text-capitalize">Por: <b>#<?php echo $reseller_name; ?></b></div>
			</div>
		</div>
		<!-- Panel Title -->
		<div class="panel">
			<div class="panel-body">
				<div class="chat-box">
					<div class="chats">
						<?php  
						foreach (array_reverse($ticket_replies) as $current_reply) {
							$is_owner = isAdmin($logged_user) == $current_reply["admin_reply"];
							?>
							<div class="chat <?php echo $is_owner ? "" : "chat-left";?>">
								<div class="chat-avatar">
									<a class="avatar" data-toggle="tooltip" href="#" data-placement="<?php echo $is_owner ? "right" : "left";?>" title="" data-original-title="<?php echo $current_reply["admin_reply"] ? "Admin" : $reseller_name; ?>">
										<img src="<?php echo $current_reply["admin_reply"] ? "temp/assets/images/avatar-ticket-adm.png" : "temp/assets/images/avatar-ticket.png" ?>" alt="<?php echo $current_reply["admin_reply"] ? "Admin" : $reseller_name; ?>">
									</a>
								</div>
								<div class="chat-body">
									<div class="chat-content">
										<p>
											<?php echo $current_reply["message"]; ?>
										</p>
										<time class="chat-time" datetime="<?php echo date("d/m/Y H:i:s", $current_reply["date"]); ?>"><?php echo date("d/m/Y H:i:s", $current_reply["date"]); ?></time>
									</div>
								</div>
							</div>
							<?php 
						} ?>
					</div>
				</div>
			</div>
			<div class="panel-footer pb-30">
				<form action="#" method="post">
					<div class="input-group">
						<textarea class="form-control" cols="80" id="message" rows="10" data-sample-short name="message" rows="3" <?php if (!$ticket["status"]) {echo "disabled";}?>></textarea>
						<span class="input-group-btn">
							<button class="btn btn-primary" type="submit" name="send_message" <?php if (!$ticket["status"]) {
								echo "disabled";
							} ?>>Enviar ticket</button>
						</span>
					</div>
				</form>
			</div>
			<div class="panel-footer pb-30">
				<div class="panel-footer pb-30">
				</div>
			</div>
		</div>
		<!-- End Panel Title -->
	</div>
</div>
<!-- End Page -->


<!-- Footer -->
<footer class="site-footer">
	<?php 
	include_once "./incluir/footer.php";
	?>
</footer>
<!-- Core  -->
<script src="temp/global/vendor/babel-external-helpers/babel-external-helpers.js"></script>
<script src="temp/global/vendor/jquery/jquery.js"></script>
<script src="temp/global/vendor/popper-js/umd/popper.min.js"></script>
<script src="temp/global/vendor/bootstrap/bootstrap.js"></script>
<script src="temp/global/vendor/animsition/animsition.js"></script>
<script src="temp/global/vendor/mousewheel/jquery.mousewheel.js"></script>
<script src="temp/global/vendor/asscrollbar/jquery-asScrollbar.js"></script>
<script src="temp/global/vendor/asscrollable/jquery-asScrollable.js"></script>
<script src="temp/global/vendor/ashoverscroll/jquery-asHoverScroll.js"></script>

<!-- Plugins -->
<script src="temp/global/vendor/switchery/switchery.js"></script>
<script src="temp/global/vendor/intro-js/intro.js"></script>
<script src="temp/global/vendor/screenfull/screenfull.js"></script>
<script src="temp/global/vendor/slidepanel/jquery-slidePanel.js"></script>
<script src="temp/global/vendor/moment/moment.min.js"></script>
<script src="temp/global/vendor/footable/footable.min.js"></script>

<!-- Scripts -->
<script src="temp/global/js/Component.js"></script>
<script src="temp/global/js/Plugin.js"></script>
<script src="temp/global/js/Base.js"></script>
<script src="temp/global/js/Config.js"></script>

<script src="temp/assets/js/Section/Menubar.js"></script>
<script src="temp/assets/js/Section/GridMenu.js"></script>
<script src="temp/assets/js/Section/Sidebar.js"></script>
<script src="temp/assets/js/Section/PageAside.js"></script>
<script src="temp/assets/js/Plugin/menu.js"></script>

<script src="temp/global/js/config/colors.js"></script>
<script src="temp/assets/js/config/tour.js"></script>
<script>Config.set('assets', 'temp/assets');</script>

<!-- Page -->
<script src="temp/assets/js/Site.js"></script>
<script src="temp/global/js/Plugin/asscrollable.js"></script>
<script src="temp/global/js/Plugin/slidepanel.js"></script>
<script src="temp/global/js/Plugin/switchery.js"></script>

<script src="temp/assets/examples/js/tables/footable.js"></script>
<script src="temp/assets/js/bootbox.js"></script>
<script src="temp/assets/js/bootbox.min.js"></script>

<script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>

<script src="https://cdn.datatables.net/responsive/2.2.3/js/dataTables.responsive.min.js"></script>
<script src="temp/assets/js/bootbox.js"></script>
<script src="temp/assets/js/bootbox.min.js"></script>
<script src="temp/global/vendor/toastr/toastr.js"></script>
<script src="temp/global/js/Plugin/toastr.js"></script>
<script src="https://cdn.ckeditor.com/4.13.0/basic/ckeditor.js"></script>
<script>
    CKEDITOR.replace('message', {
      height: 150
    });
  </script>
<script type="text/javascript">
	$("#toast-bottomFullWidth").show();
	setTimeout(function () {
		$("#toast-bottomFullWidth").fadeOut();
	}, 6000);
</script>
</body>
</html>
